---
name: email-sequences
description: Creates automated email sequences for every stage of the customer journey including welcome, nurture, conversion, and launch flows. This skill should be used when building automated email flows, launching products, improving email-driven conversions, or onboarding new customers.
---

# Email Sequences

This skill creates automated email sequences that move subscribers through the customer journey - from stranger to subscriber to customer to advocate.

## Objective

Build email sequences that deliver the right message at the right time, nurturing relationships and driving conversions without manual effort.

## Intake Questions

Before creating email sequences, gather context:

1. **Entry point**: How do people join this sequence? (Lead magnet, purchase, signup)
2. **Desired outcome**: What should they do after the sequence? (Buy, book, engage)
3. **Product/Offer**: What are you eventually selling or promoting?
4. **Timeline**: Over what period should the sequence run?
5. **Audience knowledge**: How familiar are they with you/your solution?
6. **Objections**: What prevents people from taking the desired action?
7. **Existing sequences**: What automation already exists?

## The 6 Sequence Types

### 1. Welcome Sequence
**Trigger**: New subscriber (lead magnet, newsletter signup)
**Goal**: Build relationship, set expectations, introduce brand
**Length**: 3-7 emails over 1-2 weeks

**Email structure**:
1. **Email 1 (Immediate)**: Deliver promised content + set expectations
2. **Email 2 (Day 1-2)**: Share your story/origin
3. **Email 3 (Day 3-4)**: Deliver unexpected value (bonus content)
4. **Email 4 (Day 5-7)**: Social proof + best content
5. **Email 5 (Day 7-10)**: Soft intro to paid offer (optional)

**Key principles**:
- Deliver on lead magnet promise immediately
- Set email frequency expectations
- Show personality and build connection
- Don't hard sell too early

### 2. Nurture Sequence
**Trigger**: After welcome sequence ends
**Goal**: Stay top of mind, continue providing value
**Length**: Ongoing, 1-4 emails per week

**Content rotation**:
- Educational content
- Case studies and examples
- Behind-the-scenes
- Curated resources
- Occasional promotional content (20% max)

**Key principles**:
- Maintain consistent schedule
- 80/20 rule: 80% value, 20% promotional
- Segment based on engagement
- Re-engage inactive subscribers

### 3. Conversion Sequence
**Trigger**: Interest signal (page visit, link click, webinar signup)
**Goal**: Convert interest to purchase
**Length**: 4-7 emails over 5-10 days

**Email structure**:
1. **Email 1**: Acknowledge interest, expand on benefits
2. **Email 2**: Handle main objection #1
3. **Email 3**: Case study/success story
4. **Email 4**: Handle main objection #2
5. **Email 5**: FAQ compilation
6. **Email 6**: Urgency/scarcity (if real)
7. **Email 7**: Last chance + final push

**Key principles**:
- One email, one focus
- Address objections directly
- Use social proof strategically
- Create urgency without being sleazy

### 4. Launch Sequence
**Trigger**: Product launch or promotion period
**Goal**: Maximize sales during limited window
**Length**: 7-14 emails over launch period

**Three phases**:

**Pre-Launch (3-5 emails)**:
- Build anticipation
- Warm up to the offer
- Share relevant content
- Hint at what's coming

**Launch Week (4-7 emails)**:
1. Doors open + full details
2. Deep dive on specific benefit
3. Case study/proof
4. FAQ + objection handling
5. Bonuses (if applicable)
6. Urgency: limited time/spots
7. Final hours + cart close

**Post-Launch (2-3 emails)**:
- Thank buyers, onboard them
- Waitlist for non-buyers
- Reset expectations

### 5. Onboarding Sequence
**Trigger**: New purchase/signup
**Goal**: Help customers succeed and reduce churn
**Length**: 5-10 emails over first 30 days

**Email structure**:
1. **Email 1 (Immediate)**: Welcome + quick start guide
2. **Email 2 (Day 1)**: First milestone to complete
3. **Email 3 (Day 3)**: Common mistake to avoid
4. **Email 4 (Day 5)**: Success story inspiration
5. **Email 5 (Day 7)**: Check-in + support offer
6. **Emails 6-10**: Progressive feature introduction

**Key principles**:
- Focus on one action per email
- Celebrate early wins
- Anticipate confusion points
- Make support easy to access

### 6. Re-engagement Sequence
**Trigger**: Inactive subscriber (30-90 days no opens)
**Goal**: Win back or clean list
**Length**: 3-5 emails over 1-2 weeks

**Email structure**:
1. **Email 1**: "We miss you" + best content
2. **Email 2**: "What's changed" + new value
3. **Email 3**: Incentive or exclusive offer
4. **Email 4**: "Last chance before we part ways"
5. **Email 5**: Goodbye + unsubscribe

**Key principles**:
- Acknowledge the gap honestly
- Lead with value, not guilt
- Give a real reason to re-engage
- Clean list if no response

## Email Structure Template

Each email should follow this structure:

### Subject Line
- See newsletter skill for formulas
- Test curiosity vs. clarity

### Preview Text
- First 40-90 characters
- Complement (don't repeat) subject line

### Opening Hook (First 1-3 lines)
- Pattern interrupt
- Story hook
- Surprising statement
- Direct question

### Body
- One main idea
- Conversational tone
- Short paragraphs (1-3 sentences)
- Use "you" more than "I"

### Call to Action
- Single, clear CTA
- Benefit-focused button text
- Link multiple times if needed

### P.S.
- Second CTA or curiosity hook
- High readership area - use it

## Timing & Spacing Guidelines

| Sequence Type | Spacing | Best Send Times |
|---------------|---------|-----------------|
| Welcome | Days 0, 1, 3, 5, 7 | Immediate + morning |
| Nurture | 2-3x per week | Tue/Wed/Thu morning |
| Conversion | Daily during push | 10am or 7pm |
| Launch | Daily + urgency stacks | 10am + 5pm on close |
| Onboarding | Days 0, 1, 3, 5, 7, 14, 21, 30 | Matches product usage |
| Re-engagement | Days 0, 3, 7, 10, 14 | Morning, mid-week |

## Personalization Triggers

Advanced automation based on behavior:

| Trigger | Action |
|---------|--------|
| Opened 5+ emails | Move to engaged segment |
| Clicked pricing page | Start conversion sequence |
| Abandoned cart | Cart recovery sequence |
| Purchased | Onboarding sequence |
| No opens in 30 days | Re-engagement sequence |
| Clicked specific topic | Topic-specific content |

## Output Format

When creating email sequences, deliver:

1. **Sequence Map**: Visual flow showing triggers and emails
2. **Email Briefs**: For each email - goal, subject options, key points
3. **Full Email Copy**: Complete copy for each email in sequence
4. **Timing Schedule**: When each email sends
5. **Success Metrics**: What to track (opens, clicks, conversions)
6. **Segmentation Recommendations**: How to split audiences

## Cross-References

- Apply `brand-voice` for consistent tone across all emails
- Use `lead-magnet` to inform welcome sequence delivery
- `direct-response-copy` techniques apply to conversion emails
- `newsletter` handles broadcast vs. automated (this skill)
- Launch sequences may promote offers from `lead-magnet`
- `orchestrator` routes here for email marketing projects
