---
name: "Employment Verification"
description: "Verify employment history and professional background"
allowed-tools:
  - src.tools.employment_verify
---

# Employment Verification

## Purpose

Verify employment history, job titles, dates of employment, and professional background for background checks, due diligence, and compliance screening.

## When to Use

- Executive background verification for key personnel screening
- Due diligence on business partners and counterparties
- Compliance screening for regulated industries
- Fraud investigation involving employment claims
- Background checks for high-risk transactions
- Professional credential validation
- Investigation of potential conflicts of interest
- Verification of claims in CVs, applications, or disclosures

## How to Use

The employment verification tool validates professional history through:

- **Employment Dates**: Start and end dates of employment
- **Job Titles**: Official positions and role responsibilities
- **Employer Verification**: Company existence and legitimacy
- **Salary Information**: Where legally permissible and relevant
- **Professional References**: Contact verification and validation
- **Industry Experience**: Sector-specific experience and expertise

## Examples

**Executive due diligence:**
```
Subject: John Smith, proposed CFO
Verification: Confirm 10-year employment history at Fortune 500 companies
Focus: Financial services experience, regulatory roles
```

**Business partner screening:**
```
Individual: Jane Doe, potential joint venture partner
Background: Verify claimed tech industry experience and startup exits
Analysis: Assess professional competence and track record
```

**Regulatory compliance check:**
```
Person: Proposed board member for regulated entity
Requirement: Verify "fit and proper" criteria for regulatory approval
Investigation: Employment history, industry experience, potential conflicts
```

**Fraud investigation:**
```
Subject: Individual making false employment claims
Investigation: Verify actual vs claimed employment at target companies
Evidence: Document discrepancies for potential legal action
```

## Important Notes

- Employment verification laws vary by jurisdiction - ensure compliance
- Some employers have policies limiting information disclosure
- Verify through official HR departments rather than personal references
- Be aware of privacy rights and obtain appropriate consent
- Consider time limitations - older employment may be harder to verify
- Cross-reference with other professional information (LinkedIn, industry databases)
- Some industries have specialized verification services (finance, healthcare)
- Document verification attempts even if unsuccessful for compliance records