---
name: english-to-thai-cultural-translation
description: Translate English content to Thai with cultural adaptation for idioms, formality levels (กระผม/ผม/ครับ/ค่ะ/นะ), honorifics, and context-appropriate register. Use when translating to Thai, adapting cultural references, localizing English content for Thai audiences, or questions about Thai language formality and cultural nuance.
---

# English to Thai Cultural Translation

This skill provides culturally-aware translation from English to Thai, ensuring the translation sounds natural and culturally appropriate rather than literal or awkward.

## Instructions

When translating English to Thai, follow this process:

### 1. Analyze Source Content

- **Identify formality level**: Academic, professional, casual, intimate?
- **Detect cultural idioms**: Are there English idioms that need Thai equivalents?
- **Understand context**: Technical documentation, personal message, business communication?
- **Recognize target audience**: Students, professionals, general public, elders?

### 2. Select Appropriate Formality Register

Choose pronouns and particles based on context:

**Personal Pronouns:**
- **Formal written (academic/official)**: กระผม (male), ดิฉัน (female)
- **Professional/polite**: ผม (male), ฉัน/ดิฉัน (female)
- **Casual**: ฉัน (neutral), เรา (we/informal I)
- **Intimate (close friends)**: กู/มึง (very informal, use with caution)

**Polite Particles:**
- **Formal/polite**: ครับ (male), ค่ะ (female) - end of sentences
- **Casual friendly**: นะ, จ้า, จ้ะ - soften tone
- **Professional writing**: Often omit particles for brevity

### 3. Apply Cultural Adaptations

**Idioms and Expressions:**
- Don't translate idioms literally
- Find Thai equivalents or rephrase naturally
- Examples:
  - "Break a leg" → "ขอให้โชคดี" (wish you luck)
  - "Piece of cake" → "ง่ายมาก" or "เป็นเรื่องง่าย"
  - "It's raining cats and dogs" → "ฝนตกหนัก"
  - "Under the weather" → "ไม่สบาย" (not well)

**Cultural References:**
- Western holidays → Explain or use Thai equivalent
- Imperial measurements → Convert to metric (Thailand uses metric)
- Cultural concepts → Add brief explanation if no Thai equivalent

**Honorifics and Respect:**
- Use คุณ for general respectful "you"
- Use ท่าน for very formal/honored persons
- Add titles: อาจารย์ (professor), ครู (teacher), หมอ (doctor)
- Buddhist/religious contexts require special vocabulary

### 4. Adjust for Natural Thai Phrasing

**Avoid Direct Translation:**
- ❌ Bad: "ผมมีแมวสามตัว" (literal: I have three cats)
- ✅ Good: "ผมเลี้ยงแมวสามตัว" (I raise three cats - more natural)

**Thai Communication Style:**
- Thai often uses implicit subjects (omit "I", "you" when clear)
- Soften direct statements with particles
- Use question particles: ไหม, หรือ, เหรอ, มั้ย
- Prefer indirect polite phrasing over blunt statements

**Word Order:**
- Thai: Subject - Verb - Object (similar to English)
- But adjectives follow nouns: "red car" = "รถสีแดง" (car color red)
- Time expressions often at start or end

## Formality Level Guide

### Formal Written (Academic, Government, Official Documents)

**Characteristics:**
- Use กระผม/ดิฉัน for first person
- Use ท่าน or คุณ for second person
- Include ครับ/ค่ะ consistently
- Avoid slang, colloquialisms
- Use complete sentences
- Formal vocabulary (ปฏิบัติ not ทำ, ดำเนินการ not ทำ)

**Example:**
- English: "I am preparing a lecture for students."
- Formal Thai: "กระผม/ดิฉันกำลังเตรียมการบรรยายสำหรับนักศึกษา"

### Professional (Business, Workplace)

**Characteristics:**
- Use ผม/ฉัน/ดิฉัน
- Add ครับ/ค่ะ for politeness
- Can omit particles in written communication for brevity
- Mix of formal and everyday vocabulary
- Clear, direct but polite

**Example:**
- English: "I will send the document tomorrow."
- Professional Thai: "ผมจะส่งเอกสารพรุ่งนี้ครับ"

### Casual (Friends, Peers, Social Media)

**Characteristics:**
- Use ผม/ฉัน or just ฉัน
- Add นะ, จ้า for friendly tone
- Can use shortened forms
- Emoticons acceptable
- More relaxed grammar

**Example:**
- English: "I'll send it tomorrow!"
- Casual Thai: "พรุ่งนี้ส่งให้นะ!" or "ส่งให้พรุ่งนี้!"

### Intimate (Very Close Friends, Family)

**Characteristics:**
- May use กู/มึง (very informal, potentially rude outside close relationships)
- Minimal particles
- Heavy use of slang
- Very abbreviated

**Example:**
- English: "Did you eat yet?"
- Intimate Thai: "กินข้าวยัง" or "กินข้าวรึยัง"

## Common Translation Patterns

### Technical Terms

**Preserve English when:**
- Widely used technical terms: AI, machine learning, API
- Acronyms: DNA, CPU, HTTP
- Brand names: Google, GitHub

**Translate when:**
- Common technical concepts with established Thai terms
- Mathematical terms: topology = โทโพโลยี
- General computing: computer = คอมพิวเตอร์

**Hybrid approach:**
- Use both: "AI (ปัญญาประดิษฐ์)"
- First mention: explain, later use: shorthand

### Numbers and Measurements

- Use Arabic numerals: 123, not ๑๒๓ (unless formal government docs)
- Convert imperial to metric
- Use Thai baht: "100 dollars" → "ประมาณ 3,500 บาท" (with context)

### Time and Dates

- Thai format: วัน/เดือน/ปี (day/month/year)
- Use Buddhist Era (+543 years) or clarify Christian Era (ค.ศ.)
- Example: January 15, 2025 = 15 มกราคม 2568 (BE) or 2025 (CE)

### Names and Titles

- Keep English names in English
- Add Thai titles when appropriate: คุณJohn, อาจารย์Sarah
- For Thai audiences, may transliterate: John = จอห์น

## Best Practices

1. **Context is King**: Always consider who is reading and why
2. **Natural Over Literal**: If literal translation sounds awkward, rephrase
3. **Formality Matching**: Match formality of source in target (casual → casual)
4. **Cultural Sensitivity**: Be aware of Thai cultural norms and taboos
5. **Ask When Unclear**: If context isn't clear, ask about target audience and purpose
6. **Consistency**: Maintain consistent formality throughout document
7. **Technical Accuracy**: Preserve meaning especially in technical/academic content
8. **Readability**: Thai readers should feel content was written in Thai, not translated

## Common Mistakes to Avoid

❌ **Direct Word-for-Word Translation**
- Loses natural Thai flow
- Can create confusion or unintended meanings

❌ **Inconsistent Formality**
- Mixing กระผม with casual particles
- Switching between polite and informal randomly

❌ **Literal Idiom Translation**
- Results in nonsensical Thai
- Confuses readers

❌ **Ignoring Cultural Context**
- Western-centric references without explanation
- Assuming Thai readers know foreign customs

❌ **Wrong Pronoun/Particle for Situation**
- Using intimate pronouns in professional settings
- Omitting polite particles when needed

## Examples

### Example 1: Academic Translation

**English:**
"I am preparing a lecture for senior undergraduate students on Urysohn's Lemma—one of the most beautiful results in topology."

**Poor Translation (too literal):**
"ผมกำลังเตรียมการบรรยายสำหรับนักเรียนปริญญาตรีอาวุโสเกี่ยวกับเล็มมาของอูริซอห์น—หนึ่งในผลลัพธ์ที่สวยงามที่สุดในทอพอโลจี"

**Good Translation (cultural adaptation):**
"ผมกำลังเตรียมการสอนสำหรับนักศึกษาปีที่ 4 สาขาคณิตศาสตร์ เรื่อง 'เล็มมาของอูริซอห์น (Urysohn's Lemma)' ซึ่งเป็นหนึ่งในทฤษฎีบทที่สวยงามที่สุดในโทโพโลยี"

**Why it's better:**
- "senior undergraduate" → "ปีที่ 4" (4th year) - more natural in Thai context
- Added "คณิตศาสตร์" (mathematics) for clarity
- Used "การสอน" (teaching) instead of "การบรรยาย" (lecture) - more common
- Kept English term in parentheses
- "ทฤษฎีบท" (theorem) instead of "ผลลัพธ์" (result) - more accurate for context

### Example 2: Professional Email

**English:**
"Hi, I will send you the document tomorrow. Let me know if you need anything else."

**Good Translation (professional):**
"สวัสดีครับ/ค่ะ ผมจะส่งเอกสารให้คุณพรุ่งนี้นะครับ/ค่ะ ถ้ามีอะไรที่ต้องการเพิ่มเติม บอกได้เลยครับ/ค่ะ"

**Why it works:**
- Polite greeting
- Added นะ for softer tone
- "บอกได้เลย" = "feel free to tell me" (more inviting than literal)
- Consistent ครับ/ค่ะ throughout

### Example 3: Casual Message

**English:**
"Did you finish the homework? It was super hard!"

**Good Translation (casual):**
"ทำการบ้านเสร็จยัง? ยากมากเลย!"

**Why it works:**
- No need for pronouns (implied)
- Omitted particles for casual tone
- "มากเลย" = "super/very" (emphatic)
- Question mark sufficient, no need for ไหม in casual text

## When to Use This Skill

Invoke this skill when the user:
- Asks to "translate to Thai"
- Requests "Thai translation"
- Asks about Thai language formality
- Needs cultural adaptation for Thai audience
- Questions about ครับ/ค่ะ/นะ usage
- Wants to localize English content for Thailand
- Asks how to say something "naturally" in Thai
- Needs help with Thai pronouns or particles

This skill ensures translations are culturally appropriate, naturally phrased, and use the correct formality level for the context.
