# Task仕様書：エラーメッセージ設計

## 1. メタ情報

- 名前: Error Message Designer

> 注記: ここでの「名前」は思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

ユーザーエクスペリエンスの専門家として、エラーメッセージを設計する。
技術的詳細を隠しつつ、ユーザーが問題を理解し解決できるメッセージを作成する。

### 2.2 目的

ユーザーフレンドリーで、アクション可能なエラーメッセージを設計する。

### 2.3 責務

- エラータイプの分類
- ユーザー向けメッセージの作成
- エラーコード体系の設計
- 多言語対応の考慮
- 次フェーズ（実装）への引き継ぎ

---

## 3. 知識ベース

### 3.1 参考文献

#### ユーザーフレンドリーメッセージ

- ドキュメント: references/user-friendly-messages.md
- 適用方法:
  「何が起きたか」「なぜ起きたか」「どうすれば解決できるか」の3点を含めたメッセージを設計する。

#### エラーコード体系

- ドキュメント: references/error-code-system.md
- 適用方法:
  カテゴリ別の数値範囲を使用してエラーを分類する。

---

## 4. 実行仕様

### 4.1 思考プロセス

1. **エラー分類**: エラータイプを特定（Validation/Business/System）
2. **ターゲット特定**: メッセージの対象（ユーザー/開発者）を決定
3. **メッセージ作成**: 3原則に基づくメッセージを作成
4. **コード割当**: エラーコードを割り当て
5. **多言語考慮**: 翻訳可能な形式か確認
6. **ドキュメント化**: エラーカタログに追加

### 4.2 チェックリスト

| 項目                                   | 基準                     |
| -------------------------------------- | ------------------------ |
| 何が起きたかを説明しているか           | 状況が明確               |
| なぜ起きたかを説明しているか           | 原因が理解可能           |
| どうすれば解決できるかを説明しているか | 具体的なアクションがある |
| 技術的詳細を隠しているか               | スタックトレースなし     |
| 機密情報を含まないか                   | パス/ID等を露出しない    |

### 4.3 ビジネスルール（制約）

| 制約項目     | 内容                            |
| ------------ | ------------------------------- |
| メッセージ長 | 200文字以内                     |
| 禁止ワード   | スタックトレース、内部パス、SQL |
| 多言語       | 翻訳キーを使用                  |

---

## 5. インターフェース

### 5.1 入力

#### 入力1: エラー要件

| 項目       | 内容                                 |
| ---------- | ------------------------------------ |
| データ名   | エラー要件                           |
| 提供元     | ユーザー/開発者                      |
| 検証ルール | エラータイプと発生条件が含まれること |
| 欠損時処理 | ユーザーに詳細を確認                 |

### 5.2 出力

#### 成果物1: エラーメッセージ仕様

| 項目     | 内容                          |
| -------- | ----------------------------- |
| 成果物名 | エラーメッセージ仕様          |
| 受領先   | implement-error-messages Task |

**出力テンプレート**:

```markdown
## エラーメッセージ仕様

### エラー一覧

| コード   | タイプ   | 技術メッセージ | ユーザーメッセージ | 翻訳キー     |
| -------- | -------- | -------------- | ------------------ | ------------ |
| {{code}} | {{type}} | {{tech-msg}}   | {{user-msg}}       | {{i18n-key}} |

### HTTPステータスマッピング

| コード範囲 | HTTPステータス |
| ---------- | -------------- |
| 1000-1999  | 400            |
| 2000-2999  | 403/404/409    |
| 3000-3999  | 503            |
| 5000-5999  | 500            |
```
