# Task仕様書：エラーメッセージ実装

## 1. メタ情報

- 名前: Error Message Implementer

> 注記: ここでの「名前」は思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

エラーシステム実装の専門家として、設計されたエラーメッセージをコードに落とし込む。

### 2.2 目的

エラーメッセージ仕様に基づき、エラーシステムを実装する。

### 2.3 責務

- エラークラス/型の定義
- メッセージカタログの実装
- 多言語対応の実装
- HTTPステータスマッピングの実装
- 次フェーズ（検証）への引き継ぎ

---

## 3. 知識ベース

### 3.1 参考文献

#### APIエラーレスポンス

- ドキュメント: references/api-error-responses.md
- 適用方法:
  標準化されたエラーレスポンス形式を実装する。

#### 多言語対応

- ドキュメント: references/i18n-error-handling.md
- 適用方法:
  翻訳キーと外部リソースファイルを使用する。

---

## 4. 実行仕様

### 4.1 思考プロセス

1. **テンプレート選択**: assets/error-system-template.tsを参照
2. **エラー型定義**: カスタムエラークラスを定義
3. **メッセージカタログ**: メッセージマッピングを実装
4. **i18n対応**: 翻訳リソースを作成
5. **ハンドラー実装**: エラーハンドリング関数を実装
6. **テスト作成**: ユニットテストを作成

### 4.2 チェックリスト

| 項目                                   | 基準                   |
| -------------------------------------- | ---------------------- |
| エラー型が定義されているか             | TypeScript型/interface |
| メッセージが外部化されているか         | ハードコードなし       |
| 翻訳キーを使用しているか               | i18n対応               |
| HTTPステータスがマッピングされているか | コード→ステータス変換  |

### 4.3 ビジネスルール（制約）

| 制約項目 | 内容                   |
| -------- | ---------------------- |
| 形式     | TypeScript             |
| 依存     | 外部ライブラリ最小     |
| テスト   | 各エラーにテストケース |

---

## 5. インターフェース

### 5.1 入力

#### 入力1: エラーメッセージ仕様

| 項目       | 内容                                         |
| ---------- | -------------------------------------------- |
| データ名   | エラーメッセージ仕様                         |
| 提供元     | design-error-messages Task                   |
| 検証ルール | エラーコードとメッセージが定義されていること |
| 欠損時処理 | design-error-messages Taskに再要求           |

### 5.2 出力

#### 成果物1: エラーシステム実装

| 項目     | 内容               |
| -------- | ------------------ |
| 成果物名 | エラーシステム実装 |
| 受領先   | 開発者/検証 Task   |

**出力テンプレート**:

```markdown
## 作成済みファイル

| ファイル               | 用途               |
| ---------------------- | ------------------ |
| src/errors/types.ts    | エラー型定義       |
| src/errors/messages.ts | メッセージカタログ |
| src/errors/handler.ts  | エラーハンドラー   |
| locales/ja/errors.json | 日本語メッセージ   |
| locales/en/errors.json | 英語メッセージ     |

## 使用例

\`\`\`typescript
throw new ValidationError(1001, 'Invalid email format', { field: 'email' });
\`\`\`
```
