# エラー復旧プロンプトテンプレート

## ネットワークエラー用

```
## 接続エラー

{{service-name}}に接続できませんでした。

**解決方法**:
1. インターネット接続を確認してください
2. 数分後にもう一度お試しください

[再試行] [オフラインで続行]

エラーコード: {{error-code}}
```

## セッション期限切れ用

```
## セッション期限切れ

セキュリティのため、セッションが終了しました。

作業内容は自動保存されています。

[再ログイン]

問題が続く場合は、ブラウザのCookieを確認してください。
```

## 入力エラー用

```
## 入力エラー

{{field-name}}に問題があります。

{{error-message}}

例: {{example}}

[修正する]
```

## サーバーエラー用

```
## サービス一時停止

申し訳ありません。現在サービスをご利用いただけません。

復旧予定: {{recovery-time}}

[ステータスを確認] [後で再試行のリマインダーを設定]

作業内容は保存されています。
```

## 権限エラー用

```
## アクセス権限が必要です

この操作には{{permission-name}}が必要です。

[権限をリクエスト] [キャンセル]

管理者: {{admin-contact}}
```

## カスタマイズ変数

| 変数                  | 説明           | 例                       |
| --------------------- | -------------- | ------------------------ |
| `{{service-name}}`    | サービス名     | "データベース"           |
| `{{error-code}}`      | エラーコード   | "NET-001"                |
| `{{field-name}}`      | フィールド名   | "メールアドレス"         |
| `{{error-message}}`   | 具体的なエラー | "形式が正しくありません" |
| `{{example}}`         | 正しい入力例   | "user@example.com"       |
| `{{recovery-time}}`   | 復旧予定時刻   | "15:00頃"                |
| `{{permission-name}}` | 必要な権限     | "編集権限"               |
| `{{admin-contact}}`   | 管理者連絡先   | "admin@company.com"      |
