# エラー復旧プロンプトパターン

## 概要

ユーザーがエラーから回復するための効果的なプロンプト設計パターン。

## 基本原則

### 1. 明確なアクション提示

ユーザーが次に何をすべきかを明確に示す。

**悪い例**: "エラーが発生しました"
**良い例**: "エラーが発生しました。[再試行]ボタンをクリックしてください"

### 2. 段階的な回復オプション

複数の回復方法を難易度順に提示。

```
1. 再試行 (最も簡単)
2. ページを更新
3. サポートに問い合わせ (最後の手段)
```

### 3. 進捗の保持

可能な限りユーザーの入力/進捗を保持。

```
"入力内容は保存されています。問題を修正してから続行してください。"
```

## パターンカタログ

### ネットワークエラー

```
接続に問題が発生しました。

[再試行] [オフラインモードで続行]

問題が解決しない場合は、ネットワーク接続を確認してください。
```

### 認証エラー

```
セッションが期限切れになりました。

[再ログイン]

作業内容は自動保存されています。
```

### 入力エラー

```
メールアドレスの形式が正しくありません。

例: user@example.com

[修正する]
```

### サーバーエラー

```
サービスが一時的に利用できません。

自動的に再試行しています... (3回中1回目)

[手動で再試行] [後で再試行]
```

## 回復フロー設計

### 自動回復

- 一時的なエラーは自動リトライ
- 進捗インジケーターを表示
- 最大試行回数後に手動オプションを表示

### 手動回復

- 明確なアクションボタンを配置
- キーボードショートカットをサポート
- フォーカス管理（ボタンに自動フォーカス）

### エスカレーション

- 自動回復 → 手動回復 → サポート問い合わせ
- 各段階で必要な情報を収集
