---
name: evidence-collection
description: Collect, format, and cite evidence for LeadFraud.org. Use this skill when gathering G2 reviews, traffic data, or documenting patterns to ensure proper attribution and credibility.
license: Internal use only
---

This skill ensures all evidence on LeadFraud.org is properly sourced, attributed, and formatted for maximum credibility and legal defensibility.

## Evidence Sources

### Primary Sources (Highest Weight)

| Source | What to Collect | How to Access |
|--------|-----------------|---------------|
| **G2.com** | Customer reviews with star ratings | Search "[vendor] reviews g2" |
| **SimilarWeb** | Monthly traffic estimates | similarweb.com/website/[domain] |
| **Ahrefs/SEMrush** | Organic traffic, backlinks | Paid tools, use free trials |
| **LinkedIn** | Professional discussions, comments | Search platform posts |
| **Reddit** | Community discussions | r/sales, r/marketing, r/b2bmarketing |

### Secondary Sources

- Court filings and legal documents
- SEC filings for public companies
- Better Business Bureau complaints
- Industry analyst reports

## G2 Evidence Library

Verbatim quotes from verified G2 reviews. Use these as primary evidence:

### DemandScience Reviews

> *"We got a couple of complaints from our sales team that these leads never downloaded our material, or even heard of us."*
> — Adam W., Mid-Market, 2/7/2023

> *"Great ICP contacts, zero engagement, better off paying for a list. None of the nearly 800 contacts provided engaged in any further content, offers, emails, or sales meeting requests. It's as if they never downloaded the content we provided to DS. We asked for proof that the contacts actually downloaded our assets as part of the syndication program. They could not. I asked for proof that any of the contacts showed 'purchase intent'. They could not."*
> — Verified User in Marketing and Advertising, 12/16/2022

> *"Some leads don't remember interacting with our content."*
> — Tanya T., Mid-Market, 2/8/2023

### INFUSE Media Reviews

> *"No clarity behind HOW the lead was delivered i.e. clicked from a display ad on X website, landed on page. Leads often report no memory of downloading content or filling in form."*
> — Verified User in Marketing and Advertising, 12/5/2024

> *"When we reach out to people who downloaded our content pieces and checked a box that they want our company to contact them, they say that they have never heard of us."*
> — Verified User in Information Technology and Services, 8/12/2025

> *"Though the leads received look good on paper, we still haven't had a conversion into sales."*
> — Verified User in Information Technology and Services, 12/1/2020

### Common Patterns Across Reviews

When analyzing reviews, document these recurring themes:
- Leads don't recall downloading anything
- Zero engagement from delivered contacts
- Vendor cannot provide proof of download/consent
- "Better off paying for a list" (unintentional admission)
- Good ICP match but no actual intent

## Email Domains to Document

Known email domains used for "content delivery":

```
info@ittechpapers.com
noreply@cloud-downloads.net
content@whitepaperdownloads.io
downloads@b2b-resources.com
marketing@tech-content-hub.com
whitepaper@enterprise-downloads.com
```

When documenting email evidence:
- Screenshot the email (redact personal info)
- Show spam folder placement if applicable
- Document 0% open rates from SDR tools
- Connect domains to specific vendors when provable
- Include email headers if available

## Content Shell Sites by Vendor

| Vendor | Known Sites |
|--------|-------------|
| Headley Media | itcorporate.com, cybersecuritycorporate.com, fintechcorporate.com |
| INFUSE Media | securitycurated.com, cloudcurated.com, fintechcurated.com |
| DemandScience | softwaretrends.com |
| OpGen Media / Reel Axis | channelbytes.com |
| InboxInsight | insightsforprofessionals.com |
| DemandWorks Media | ebulletins.com, techebulletins.com |

## Citation Format

### Quote Citation
```
"[Direct quote, verbatim]"
— [Name or Verified User in [Industry]], [Platform], [Date]
```

### Traffic Data Citation
```
[Domain] shows approximately [X] monthly visitors according to SimilarWeb (as of [Month Year]).
```

### Pattern Citation
```
Across [N] reviews on [Platform], buyers describe a consistent pattern:
1. [Pattern element]
2. [Pattern element]
3. [Pattern element]
```

## Screenshot Standards

When capturing evidence:

1. **Include timestamp** — Browser date/time visible or noted
2. **Full context** — Don't crop in ways that change meaning
3. **Source visible** — URL bar showing source domain
4. **Highlight sparingly** — Use boxes/arrows only when necessary
5. **Save as PNG** — Lossless format preserves quality

### File Naming Convention
```
[source]-[vendor]-[date]-[description].png

Examples:
g2-demandscience-2024-01-15-zero-engagement-review.png
similarweb-softwaretrends-2024-01-10-traffic.png
```

## Adding New Evidence

When you discover new evidence:

1. **Verify source authenticity** — Is this from a legitimate platform?
2. **Capture screenshot immediately** — Pages can be edited or removed
3. **Document the date** — When was this posted/captured?
4. **Check for patterns** — Does this corroborate existing evidence?
5. **Add to appropriate section** — G2 Library, Email Domains, or Content Sites

## Evidence Quality Checklist

Before using any evidence, verify:

- [ ] Source is publicly accessible
- [ ] Quote is verbatim (no paraphrasing)
- [ ] Attribution includes platform and date
- [ ] Screenshot captures full context
- [ ] Evidence supports pattern, not isolated complaint
- [ ] No private/confidential information included

---

Remember: Strong evidence is the foundation of credibility. Every claim should be traceable to a public source. When in doubt, over-cite rather than under-cite.
