---
name: executive-persuasion
description: Create a customized persuasion strategy based on Cialdini's six principles of influence. Use after /clarify when the goal involves persuading colleagues, getting buy-in, or building support for an initiative. Produces a blueprint that can feed into /battle-plan. Covers Reciprocity, Commitment, Social Proof, Liking, Authority, and Scarcity.
---

# Executive Persuasion Blueprint

Create customized persuasion strategies based on Cialdini's six principles of influence.

## Where This Fits

```
/clarify → /executive-persuasion → /battle-plan
   ↓              ↓                      ↓
 Goals,       Persuasion            Sequenced
 Stakes,      Strategy by           Actions with
 Key People   Principle             Dependencies
```

This skill takes Clarify output and adds a persuasion science lens. The blueprint then feeds into Battle Plan for execution sequencing.

## Quick Reference: The Six Principles

### Reciprocity
People feel obligated to repay favors and concessions. Provide value before asking. Make concessions visible ("I've reduced my original ask"). The obligation is strong enough to override personal preferences.

### Commitment & Consistency
Once people commit—especially publicly, in writing, or with effort—they align future behavior to match. Get small yeses before big yeses. Reference their past statements. Written commitments stick harder than verbal.

### Social Proof
We look to others to determine what's correct, especially when uncertain. Show what peers, competitors, and respected others are doing. Similarity matters—proof from people like them carries more weight.

### Liking
We comply more with people we like. Build genuine connection through similarity, appreciation, familiarity, and cooperation. Frame as "solving this together" not "I need you to approve this."

### Authority
We defer to credible experts. Establish relevant expertise, but the key multiplier is trustworthiness—acknowledge one weakness or cost of your proposal to dramatically increase credibility on everything else.

### Scarcity
Opportunities seem more valuable when less available. More importantly: loss framing beats gain framing. "We risk losing X" motivates more than "We could gain X." Use genuine deadlines and competitive pressure.

## Before Starting

### First Question: Document Depth

```
Do you want fast or thorough document review?
A) Fast - use doc-summary/ (smaller files, quicker responses)
B) Thorough - use docs/ (full documents, more context)
C) Skip documents - just work from what I tell you
```

### Then:

1. **Check for Clarify output** - Look in chosen folder for `clarify-*.md` files
2. **If found**, extract: goal, key people (especially the persuasion target), stakes, evidence gaps
3. **If not found**, ask: "Want to run /clarify first, or should I gather what I need now?"
4. **Summarize understanding** before proceeding: "Here's what I understand about your situation..."

## Phase 1: Discovery Interview

Use Clarify output where available. Fill gaps through conversation. Use multiple choice for speed.

### 1.1 The Proposal

```
What are you trying to persuade them of?
A) Approve a specific initiative or investment
B) Change their position on a strategic direction
C) Support me/my team in a political situation
D) Take a specific action or make a decision
E) Let me explain in my own words
```

**Follow-up questions** (as needed):
- What are the genuine benefits?
- What are the honest costs or risks?
- What's the timeline for the decision?

### 1.2 The Target

```
Who specifically needs to be persuaded?
A) One key decision-maker
B) A small group (2-4 people)
C) A committee or leadership team
D) Multiple stakeholders at different levels
E) Let me explain in my own words
```

```
What's their decision-making style?
A) Data-driven - needs numbers and analysis
B) Relationship-oriented - trusts people over data
C) Risk-averse - worried about what could go wrong
D) Visionary - excited by big ideas and potential
E) Political - focused on how this affects power dynamics
F) I'm not sure / Mix of these
G) Let me explain in my own words
```

```
What's your current relationship with them?
A) Strong - we have history and mutual trust
B) Neutral - professional but not close
C) Weak - limited interaction, no real relationship
D) Strained - some tension or past conflict
E) Let me explain in my own words
```

### 1.3 The Context

```
Has this topic come up before?
A) Yes, it was rejected previously
B) Yes, it's been discussed but no decision
C) Somewhat related topics have come up
D) No, this is new territory
E) Let me explain in my own words
```

```
What organizational dynamics are at play?
A) Budget pressure - cost sensitivity is high
B) Political tension - competing factions or priorities
C) Change fatigue - lots of recent initiatives
D) Crisis mode - urgent problems dominating attention
E) Stable/open - reasonable environment for new ideas
F) Multiple of the above (which?)
G) Let me explain in my own words
```

## Phase 2: Principle Assessment

For each principle, assess: (1) Do you have resources to apply it? (2) Will it resonate with this target?

Rate each principle: **Strong fit**, **Moderate fit**, **Weak fit**, or **Not applicable**

### Reciprocity Assessment

```
What value can you provide BEFORE making your ask?
A) Analysis, data, or insights they need
B) Help with one of their priorities
C) Exclusive information or access
D) A visible concession from a larger initial ask
E) Nothing obvious comes to mind
F) Let me explain what I might offer
```

**Rate Reciprocity:** Based on answer, assess fit.

### Commitment & Consistency Assessment

```
What has the target publicly committed to that aligns with your proposal?
A) They've championed similar values or priorities
B) They've supported related initiatives before
C) They've made statements I can reference
D) Nothing specific comes to mind
E) Let me explain what they've said or done
```

```
Can you get a small commitment before the big ask?
A) Yes - I can get them to agree the problem matters
B) Yes - I can get written input or feedback
C) Yes - I can involve them in analysis or workshops
D) Limited opportunity for small commitments
E) Let me explain my options
```

**Rate Commitment & Consistency:** Based on answers, assess fit.

### Social Proof Assessment

```
What external validation exists?
A) Competitors are doing this
B) Industry leaders or analysts recommend this
C) Peer companies have succeeded with this
D) Internal respected figures already support this
E) Limited external proof available
F) Let me explain what proof exists
```

**Rate Social Proof:** Based on answer, assess fit.

### Liking Assessment

```
What genuine common ground do you share with the target?
A) Shared background, interests, or experiences
B) Past successful collaboration
C) Mutual respect and good rapport
D) We admire similar things or share values
E) Limited personal connection
F) Let me explain our relationship
```

```
Can this be framed as collaboration rather than a request?
A) Yes - we can solve this together
B) Somewhat - I can involve them in shaping it
C) Not really - this is clearly my ask
D) Let me explain the dynamic
```

**Rate Liking:** Based on answers, assess fit.

### Authority Assessment

```
What makes you credible on this topic?
A) Direct expertise and track record
B) Access to data or analysis others don't have
C) External experts who support my position
D) I don't have strong authority here - I need borrowed authority
E) Let me explain my credibility
```

```
What weakness or cost of your proposal can you openly acknowledge?
A) There's a clear tradeoff I can name honestly
B) There are risks I can acknowledge upfront
C) There are limitations I should be transparent about
D) I haven't thought about what to concede
E) Let me explain what I might acknowledge
```

**Rate Authority:** Based on answers, assess fit.

### Scarcity Assessment

```
What genuine urgency or scarcity exists?
A) Real deadline or window of opportunity
B) Competitive pressure - others are moving
C) Costs increase if we delay
D) Opportunity may not come again
E) Limited genuine urgency
F) Let me explain the timing
```

```
Can you frame this as loss prevention rather than gain?
A) Yes - clear risks if we don't act
B) Somewhat - there are things at stake
C) Not really - this is mostly about upside
D) Let me explain the stakes
```

**Rate Scarcity:** Based on answers, assess fit.

### Assessment Summary

After rating all six, identify:
- **Primary principles** (Strong fit) - Lead with these
- **Supporting principles** (Moderate fit) - Weave these in
- **Skip or minimize** (Weak/Not applicable) - Don't force these

## Phase 3: Blueprint Generation

Generate a persuasion blueprint with checkboxes for execution.

### Output Format

Save to `docs/persuasion-blueprint-[target-name]-[YYYY-MM-DD].md`

```markdown
# Persuasion Blueprint: [Goal]
Generated: [date]
Target: [name/role]
Based on: [link to clarify doc if exists]

---

## Situation Summary

[3-4 sentences: what you're trying to accomplish, who you're persuading, key context]

---

## Principle Assessment

| Principle | Rating | Key Resource/Lever |
|-----------|--------|-------------------|
| Reciprocity | [Strong/Moderate/Weak/N/A] | [what you can offer] |
| Commitment | [Strong/Moderate/Weak/N/A] | [past statements, small yeses available] |
| Social Proof | [Strong/Moderate/Weak/N/A] | [peers, competitors, trends] |
| Liking | [Strong/Moderate/Weak/N/A] | [relationship, common ground] |
| Authority | [Strong/Moderate/Weak/N/A] | [credibility, what to concede] |
| Scarcity | [Strong/Moderate/Weak/N/A] | [urgency, loss framing] |

**Primary principles:** [2-3 strongest]
**Supporting principles:** [others to weave in]

---

## The Strategy

> **Note:** This is your action checklist. Leave it in project docs for reference and to feed into Battle Plan.

### Pre-Work (Before the Conversation)

**Reciprocity - Provide value first:**
- [ ] [Specific action to deliver value before asking]
- [ ] [What to offer, share, or help with]

**Commitment - Get small yeses:**
- [ ] [Small agreement to obtain first]
- [ ] [Way to get them on record]

**Social Proof - Gather evidence:**
- [ ] [Peer examples to collect]
- [ ] [Internal supporters to line up]

**Liking - Build connection:**
- [ ] [Relationship action before the ask]
- [ ] [Common ground to establish]

**Authority - Establish credibility:**
- [ ] [Expertise to demonstrate]
- [ ] [Weakness to acknowledge (builds trust)]

**Scarcity - Frame urgency:**
- [ ] [Genuine deadline or window to reference]
- [ ] [Loss framing to prepare]

### Opening the Conversation

- [ ] **Common ground**: [How to start with shared interest/value]
- [ ] **Credibility signal**: [Brief expertise marker]
- [ ] **Against-interest acknowledgment**: [Weakness or cost to name upfront]
- [ ] **Frame**: [How to position what follows]

### Core Message

**Lead with primary principles:**

[Principle 1]:
- [ ] [Specific argument/point using this principle]
- [ ] Suggested language: "[exact phrasing to consider]"

[Principle 2]:
- [ ] [Specific argument/point using this principle]
- [ ] Suggested language: "[exact phrasing to consider]"

**Weave in supporting principles:**
- [ ] [How to incorporate secondary principles]

**Loss framing** (if Scarcity applies):
- [ ] Frame as: "[What's at risk if no action]" rather than "[What we gain]"

### Closing the Conversation

- [ ] **Secure commitment**: [Specific ask - ideally written or public]
- [ ] **Next step with timeline**: [Concrete action with date]
- [ ] **Make it easy to say yes**: [Remove friction points]

### Follow-Through

- [ ] **Reinforce any commitment made**: [How to make it stick]
- [ ] **Continue relationship investment**: [Ongoing connection]
- [ ] **Build momentum with others**: [How to expand support]

---

## Objection Preparation

| Likely Objection | Principle Response | Specific Counter |
|------------------|-------------------|------------------|
| [What they might say] | [Which principle addresses this] | [Your response] |
| [What they might say] | [Which principle addresses this] | [Your response] |

---

## Risk Factors

- [What could undermine this approach]
- [Contingency if initial approach fails]

---

## Feed into Battle Plan

This blueprint covers the persuasion strategy. To sequence all actions with dependencies (including research, document creation, and multi-stakeholder navigation), run `/battle-plan`.
```

## Key Reminders

- **Combine principles**: Reciprocity + Contrast, Authority + Scarcity, Social Proof + Commitment work well together
- **Subtlety matters**: Heavy-handed application creates resistance
- **Loss > Gain**: Frame what's at stake to lose, not just what could be gained
- **Written commitments stick**: Any opportunity to get something in writing strengthens commitment
- **Trustworthiness through candor**: Acknowledging one weakness dramatically increases credibility on everything else
- **Ethical foundation**: These principles amplify genuine value - don't use them to manufacture false value

## After Completion

Ask: "Want to create a Battle Plan that sequences these actions with your research and other stakeholder moves?"

If yes, invoke battle-plan skill.
