# Cialdini's Six Principles of Influence

Detailed reference for applying each principle in executive persuasion contexts.

---

## 1. RECIPROCITY

### Core Mechanism
People feel obligated to repay favors, gifts, and concessions. This obligation is powerful enough to override personal preferences—we comply even with people we don't like if they've given us something first.

### How It Works
- **Uninvited debts**: The favor doesn't need to be requested to create obligation
- **Unequal exchanges**: Small favors can trigger disproportionately large returns
- **Rejection-then-retreat**: Starting with a larger request, then "conceding" to the real ask frames the smaller request as a concession that must be reciprocated

### Executive Applications
- Provide valuable analysis, data, or insights before making your ask
- Offer help with their priorities before requesting help with yours
- Share exclusive information that benefits them
- Make concessions visible: "I've reduced the scope from my original proposal"
- If asking for a large commitment, first ask for something even larger, then retreat

### Warning Signs of Misuse
- Gifts or favors that feel disproportionate to the relationship
- Pressure to reciprocate immediately
- "Free" offers with hidden strings

---

## 2. COMMITMENT AND CONSISTENCY

### Core Mechanism
Once people commit to something—especially publicly, in writing, or with effort—they feel strong internal pressure to behave consistently. The commitment becomes part of their self-image, and inconsistency creates psychological discomfort.

### How It Works
- **Written > verbal**: Written commitments are more binding
- **Public > private**: Commitments made before others are stickier
- **Effortful > easy**: Commitments requiring work create stronger bonds
- **Active > passive**: Freely chosen commitments bind more than coerced ones
- **Foot-in-the-door**: Small commitments escalate naturally to large ones

### Executive Applications
- Get small agreements first: "Do you agree this is a problem worth solving?"
- Reference their past public statements or positions
- Ask questions that lead them to articulate supportive positions
- Request written confirmation at milestones (email, meeting notes)
- Make the decision process effortful (workshops, analysis sessions)
- Have them state their values, then show alignment with your proposal

### The Self-Image Mechanism
When someone takes a stand, they adjust their self-image to match. This new self-image then drives future behavior. A person who writes a pro-change statement begins to see themselves as pro-change, and acts accordingly.

### Warning Signs of Misuse
- Extracting commitments through deception about what's being agreed to
- Escalating demands after initial commitment (bait and switch)
- Pressure to commit before adequate information is provided

---

## 3. SOCIAL PROOF

### Core Mechanism
We determine what's correct by observing what others do. This shortcut is especially powerful when we're uncertain and when the "others" are similar to us.

### How It Works
- **Uncertainty amplifies**: The less sure we are, the more we look to others
- **Similarity matters**: We follow people like us more than dissimilar people
- **Numbers persuade**: Many people doing something is more convincing than one
- **Breaking pluralistic ignorance**: One person acting can unlock a group

### Executive Applications
- Reference peer companies or competitors who've adopted similar approaches
- Find internal champions—especially respected peers of your target
- Cite adoption rates, trends, and industry benchmarks
- Share testimonials from people in similar roles at other organizations
- If presenting to a group, identify who might commit first to create momentum
- Present data showing this is becoming standard practice

### The Similarity Principle
Social proof from similar others carries much more weight. A peer executive's endorsement matters more than a junior employee's. Industry peers matter more than unrelated industries.

### Warning Signs of Misuse
- Fabricated testimonials or fake social proof
- Cherry-picked examples that don't represent reality
- Creating artificial appearance of consensus

---

## 4. LIKING

### Core Mechanism
We comply more readily with people we like. Liking is generated through multiple pathways, all of which can be cultivated.

### Liking Generators

**Similarity**
- Shared backgrounds, interests, opinions, styles
- Even superficial similarities increase liking
- Mirroring communication style builds rapport

**Compliments**
- Genuine appreciation creates liking
- Even obviously strategic flattery has some effect
- Acknowledging their expertise or accomplishments

**Familiarity**
- Repeated exposure increases liking (mere exposure effect)
- More contact before critical conversations helps
- Consistency across interactions builds trust

**Cooperation**
- Working toward shared goals creates bonds
- "We're solving this together" framing
- Finding common enemies or challenges

**Association**
- We like people connected to things we already like
- Associating your proposal with their past successes
- Connecting to values they've championed

### Executive Applications
- Find genuine common ground before persuasion attempts
- Express authentic appreciation for their work or perspective
- Increase contact frequency before critical conversations
- Frame as collaboration: "I need your help solving this"
- Have someone they like make the introduction or endorsement
- Associate your proposal with initiatives they've championed

### Warning Signs of Misuse
- Manufactured similarity or false common ground
- Excessive flattery that feels manipulative
- Friendship used purely as leverage for requests

---

## 5. AUTHORITY

### Core Mechanism
We defer to experts and authority figures, often automatically. Importantly, the *symbols* of authority can be as persuasive as actual expertise.

### Authority Markers
- **Expertise**: Demonstrated knowledge in the relevant domain
- **Credentials**: Titles, degrees, experience, track record
- **Trappings**: Confidence, professional presentation, setting
- **Trustworthiness**: This is the critical multiplier

### The Trustworthiness Key
The most powerful authority move is demonstrating trustworthiness by appearing to argue against your own interest. When you acknowledge a weakness or cost of your proposal before advocating for it, credibility on everything else increases dramatically.

Example (Vincent the Waiter): A waiter who steers customers away from an expensive dish ("That's not as good tonight, try this instead") gains enormous credibility when recommending wine or dessert. He appeared to sacrifice his tip to give honest advice.

### Executive Applications
- Establish relevant expertise early in the conversation
- Cite external authorities (research, analysts, respected experts)
- Acknowledge weaknesses or costs of your proposal openly
- Present one point against your apparent interest before making your case
- Bring in others with relevant authority to support
- Present credentials naturally, not boastfully

### Warning Signs of Misuse
- False or exaggerated credentials
- Symbols of authority without substance
- Expert opinions outside their domain of expertise

---

## 6. SCARCITY

### Core Mechanism
Opportunities seem more valuable when less available. More importantly, we're more motivated by potential loss than by equivalent potential gain.

### How It Works
- **Limited quantity**: "Only X available" increases desire
- **Limited time**: Deadlines create urgency
- **Loss framing**: Emphasizing what could be lost beats what could be gained
- **Newly scarce**: Things that become scarce are desired more than things always scarce
- **Competition**: Knowing others want something increases our desire
- **Exclusive information**: Information presented as scarce is more persuasive

### Executive Applications
- Frame in terms of risk and potential loss, not just opportunity
- Create genuine urgency through real windows of opportunity
- Present information as exclusive or not widely known
- Highlight competitive pressure (what competitors are doing)
- Emphasize what's newly at risk or newly available
- Use deadlines, but only genuine ones

### Loss vs. Gain Framing
Research consistently shows loss framing is more motivating:
- "We risk losing market position" > "We could gain market share"
- "We'll lose this talent" > "We could attract talent"
- "We'll fall behind competitors" > "We could lead competitors"

### Psychological Reactance
When freedoms are restricted, we want them more. This is why newly scarce things are more desired than always-scarce things—we react against the loss of previously available options.

### Warning Signs of Misuse
- Artificial scarcity or fake deadlines
- Manufactured competition
- Pressure tactics that prevent thoughtful evaluation

---

## Combining Principles

The principles are most powerful in combination:

**Reciprocity + Contrast**: Make a large request, retreat to smaller one. The retreat is a concession (reciprocity) and the smaller request looks small by comparison (contrast).

**Authority + Trustworthiness**: Establish expertise, then acknowledge a weakness. Credibility multiplies.

**Social Proof + Similarity**: Show that similar others (peer companies, peer executives) have adopted your position.

**Commitment + Consistency**: Get them to articulate values, then show how your proposal aligns with what they just said.

**Scarcity + Social Proof**: "Others are already moving on this, and the window is closing."

**Liking + Authority**: A credible expert who is also personally likable is maximally persuasive.

---

## Ethical Application

These principles should amplify genuine value, not manufacture false value:

1. **Believe in your proposal**: Only use these techniques for positions you genuinely hold
2. **Benefit the organization**: The outcome should serve organizational interests, not just personal ones
3. **Preserve relationships**: Short-term wins that damage long-term trust are losses
4. **Honest application**: Use real data, genuine scarcity, actual credentials
5. **Respect autonomy**: The goal is to help people see clearly, not to override their judgment
