---
name: export-pptx
description: 포트폴리오 PPTX 생성이 필요할 때
---

# 포트폴리오 PPTX 내보내기

> **핵심 원칙**: 8년차 시니어 포트폴리오는 **AWS 아키텍처 발표 자료** 스타일
> 프로페셔널하고 모던한 디자인, 아키텍처 다이어그램 중심

---

## 개요

| 항목 | 내용 |
|------|------|
| **용도** | Tech Lead/CTO 면접, 화면 공유 발표 |
| **분량** | 10-15 슬라이드 |
| **디자인** | AWS 공식 스타일 (다크 + 오렌지 액센트) |
| **기술 스택** | pptxgenjs, sharp, aws-svg-icons |

---

## 슬라이드 구성 (10-15장)

```
┌─────────────────────────────────────────────────────────────────┐
│ Slide 1: Title                                                   │
│   - 이름, 직책, 연락처                                             │
│   - 핵심 태그라인 (기술적 정체성)                                    │
└─────────────────────────────────────────────────────────────────┘
│ Slide 2: Executive Summary (1장)                                 │
│   - Core Competencies (핵심 역량 3-4개)                           │
│   - 판단 기준 문장 (Anchor Statement)                              │
│   - 대표 성과 수치                                                 │
└─────────────────────────────────────────────────────────────────┘
│ Slide 3-8: Key Projects (프로젝트당 2장 × 3개 = 6장)              │
│   - Page A: 아키텍처 다이어그램 (Before/After, AWS 아이콘)          │
│   - Page B: PSR + 기술적 맥락 + 정량적 성과                         │
└─────────────────────────────────────────────────────────────────┘
│ Slide 9-10: Technical Decision Archive (2장)                     │
│   - Decision Log (주요 기술 선택 근거)                              │
│   - 설계 원칙 (일관된 기술 철학)                                    │
└─────────────────────────────────────────────────────────────────┘
│ Slide 11-12: Organization & Leadership (2장)                     │
│   - Bus Factor 최소화                                             │
│   - 협업 사례, 팀 역량 성장                                         │
└─────────────────────────────────────────────────────────────────┘
│ Slide 13: Technical Skills (1장)                                 │
│   - 기술 스택 + 숙련도 시각화 (프로그레스 바)                        │
└─────────────────────────────────────────────────────────────────┘
│ Slide 14-15: Contact & Q&A (1-2장)                               │
│   - 연락처, GitHub, LinkedIn                                      │
│   - Q&A 페이지 (선택)                                              │
└─────────────────────────────────────────────────────────────────┘
```

---

## 디자인 스타일

### AWS 공식 스타일

| 요소 | 색상 | 용도 |
|------|------|------|
| **배경** | #232F3E (다크 네이비) | 슬라이드 배경 |
| **텍스트** | #FFFFFF (화이트) | 본문 텍스트 |
| **악센트** | #FF9900 (오렌지) | 강조, 핵심 수치 |
| **보조** | #1A73E8 (블루) | 링크, 아이콘 배경 |

### 타이포그래피

| 요소 | 폰트 | 크기 |
|------|------|------|
| 제목 | Arial Bold | 36pt |
| 부제목 | Arial Bold | 24pt |
| 본문 | Arial | 14-16pt |
| 메트릭 | Arial Bold | 28pt |

### 슬라이드 치수

- **비율**: 16:9
- **크기**: 10" × 5.625" (pptxgenjs 기본)

---

## 사용법

### Step 1: 스크립트 실행

```bash
# 포트폴리오 PPTX 생성
node scripts/pptx/generate-portfolio.js
```

### Step 2: 출력 확인

```
output/
└── 윤원희_포트폴리오_YYYY-MM.pptx
```

### Step 3: 슬라이드 검증

- [ ] 총 슬라이드 수 10-15장
- [ ] AWS 아이콘 정상 표시
- [ ] 아키텍처 다이어그램 가독성
- [ ] 텍스트 폰트/크기 일관성

---

## 스크립트 구조

```
scripts/pptx/
├── generate-portfolio.js      # 메인 생성 스크립트
├── example-aws-icons.js       # AWS 아이콘 예제
├── example-modern-architecture.js  # 모던 디자인 예제
└── utils/
    └── aws-icons.js           # AWS 아이콘 로더 (선택)
```

---

## 데이터 소스

### 원본 데이터

```
docs/career/
├── my_career_data.md          # 원본 데이터 (SSOT)
├── career_portfolio.md        # 경력기술서
└── portfolio/
    └── portfolio.md           # 포트폴리오 (Markdown)
```

### 슬라이드별 데이터 매핑

| 슬라이드 | 데이터 소스 |
|----------|-------------|
| Title | my_career_data.md > 기본 정보 |
| Executive Summary | my_career_data.md > 핵심 역량 |
| Key Projects | career_portfolio.md > 프로젝트 |
| Technical Decision | portfolio.md > Decision Log |
| Tech Skills | my_career_data.md > 기술 스택 |

---

## AWS 아이콘 사용

### 설치

```bash
npm install aws-svg-icons sharp
```

### 아이콘 로드

```javascript
const sharp = require('sharp');
const path = require('path');

async function loadAwsIcon(category, subfolder, filename) {
  const iconPath = path.join(
    'node_modules/aws-svg-icons/lib/Architecture-Service-Icons_01312024',
    category,
    subfolder,
    filename
  );
  const svgBuffer = await fs.promises.readFile(iconPath);
  const pngBuffer = await sharp(svgBuffer)
    .resize(48, 48)
    .png()
    .toBuffer();
  return `data:image/png;base64,${pngBuffer.toString('base64')}`;
}
```

### 주요 아이콘 경로

| 서비스 | 카테고리 | 서브폴더 | 파일명 |
|--------|----------|----------|--------|
| Lambda | Arch_Compute | 48 | Arch_AWS-Lambda_48.svg |
| EC2 | Arch_Compute | 48 | Arch_Amazon-EC2_48.svg |
| RDS | Arch_Database | 48 | Arch_Amazon-RDS_48.svg |
| DynamoDB | Arch_Database | 48 | Arch_Amazon-DynamoDB_48.svg |
| S3 | Arch_Storage | 48 | Arch_Amazon-Simple-Storage-Service_48.svg |
| API Gateway | Arch_App-Integration | Arch_48 | Arch_ Amazon-API-Gateway_48.svg |
| Elasticsearch | Arch_Analytics | Arch_48 | Arch_Amazon-Elasticsearch-Service_48.svg |
| CloudWatch | Arch_Management-Governance | 48 | Arch_Amazon-CloudWatch_48.svg |

> **주의**: 카테고리마다 서브폴더 이름이 다름 (`48` 또는 `Arch_48`)

---

## 아키텍처 다이어그램 작성

### Before/After 구조

```javascript
// Before 영역 (왼쪽)
slide.addText('Before', { x: 0.3, y: 0.8, fontSize: 16, bold: true, color: 'FF6B6B' });
slide.addShape('rect', { x: 0.3, y: 1.1, w: 4.5, h: 3.8, fill: { color: '3D4F5F' } });

// After 영역 (오른쪽)
slide.addText('After', { x: 5.2, y: 0.8, fontSize: 16, bold: true, color: '4ECDC4' });
slide.addShape('rect', { x: 5.2, y: 1.1, w: 4.5, h: 3.8, fill: { color: '3D4F5F' } });
```

### 컴포넌트 배치

```javascript
// 아이콘 + 라벨
slide.addImage({ data: icons.lambda, x: 1.0, y: 1.5, w: 0.5, h: 0.5 });
slide.addText('Lambda', { x: 0.8, y: 2.0, w: 1, fontSize: 10, color: 'FFFFFF', align: 'center' });

// 화살표
slide.addShape('line', {
  x: 1.5, y: 1.75, w: 0.8, h: 0,
  line: { color: 'FF9900', width: 2, endArrowType: 'triangle' }
});
```

---

## 체크리스트

### PPTX 생성 전

- [ ] `my_career_data.md` 최신 상태 확인
- [ ] 핵심 프로젝트 2-3개 선정
- [ ] 각 프로젝트 아키텍처 다이어그램 구상

### PPTX 생성 후

- [ ] 슬라이드 수 확인 (10-15장)
- [ ] AWS 아이콘 정상 렌더링
- [ ] 텍스트 가독성 (폰트 크기, 색상 대비)
- [ ] 메트릭 수치 정확성
- [ ] 슬라이드 순서 적절성

### 발표 준비

- [ ] 각 슬라이드 발표 시간 배분 (2-3분/슬라이드)
- [ ] 예상 질문 및 답변 준비
- [ ] 백업 자료 (PDF 버전) 준비

---

## 파일명 규칙

```
output/
├── 윤원희_포트폴리오_YYYY-MM.pptx       # 기본 포트폴리오
├── 윤원희_포트폴리오_JD_COMPANY.pptx    # JD 맞춤형 (선택)
└── 윤원희_포트폴리오_COMPANY.pptx       # 회사별 맞춤형 (선택)
```

---

## 관련 스킬

- `/write-portfolio`: Markdown 기반 포트폴리오 (기술 백서)
- `/svg-diagram`: SVG 아키텍처 다이어그램
- `/export`: PDF 내보내기

---

## 문제 해결

| 문제 | 해결 |
|------|------|
| AWS 아이콘 안 보임 | sharp 설치 확인, 아이콘 경로 확인 |
| 한글 깨짐 | fontFace: 'Malgun Gothic' 지정 |
| 슬라이드 비율 이상 | layout: 'LAYOUT_16x9' 확인 |
| 이미지 품질 저하 | sharp resize 크기 조정 (48 → 64) |
