---
name: extension-assessment
description: |
  評估日文詞彙卡片的語用延伸需求。
  分析六個面向：敬語、語氣、語域、褒貶義、暗喻、同義詞對比。
  使用時機：
  - 當想了解某個詞彙需要哪些延伸卡片
  - 當需要評估詞彙的語用複雜度
  - 當探索詞彙的社會語言學特徵
  - 當人工判斷是否需要建立延伸卡片
  關鍵字：延伸需求、敬語延伸、同義詞對比、語域分析、延伸卡片、語用分析
---

# 延伸需求評估

評估日文詞彙卡片的語用延伸需求，提供決策報告。

## 使用方式

讀取指定卡片，分析六個語用面向，輸出評估報告。

```
請評估 zettelkasten/verb-u/030_manabu.md 的延伸需求
```

## 分析面向

### 六個評估維度

| 面向 | 日文 | 評估標準 | 優先級判定 |
|------|------|---------|-----------|
| 敬語 | keigo | 是否有尊敬語/謙讓語變體 | High：影響禮貌度和社交 |
| 語氣 | nuance | 語氣變化是否改變語義 | Medium：提升表達細膩度 |
| 語域 | register | 正式/非正式/粗俗差異 | Medium：理解社會語境 |
| 褒貶義 | connotation | 是否帶有明顯褒貶 | Medium：避免冒犯 |
| 暗喻 | implication | 是否有比喻或隱含意義 | Low：進階理解 |
| 同義詞 | comparison | 是否需要與同義詞對比 | High：避免誤用 |

### 優先級定義

| 優先級 | 說明 | 建議 |
|--------|------|------|
| **Critical** | 核心詞彙，缺少會影響學習 | 立即建立 |
| **High** | 重要延伸，有助避免誤用 | 優先建立 |
| **Medium** | 有益補充，提升表達細膩度 | 考慮建立 |
| **Low** | 進階內容，可後續補充 | 可選建立 |

## 輸出格式

```markdown
## 延伸需求評估報告

**卡片**：{path}
**詞彙**：{japanese}（{reading}）
**分類**：{category}

### 評估結果

| 面向 | 需要延伸 | 優先級 | 建議卡片 |
|------|---------|--------|---------|
| 敬語 | ❌ | - | - |
| 語氣 | ✅ | Medium | {詞彙}的多重語義 |
| 語域 | ❌ | - | - |
| 褒貶義 | ❌ | - | - |
| 暗喻 | ❌ | - | - |
| 同義詞 | ✅ | High | {詞彙A} vs {詞彙B} |

### 決策建議

1. **同義詞對比**（High）
   - 建議建立：{詞彙A} vs {詞彙B} vs {詞彙C}
   - 理由：{說明為何需要對比}

2. **語氣差異**（Medium）
   - 可考慮：{詞彙}的多重語義
   - 理由：{說明語氣差異的重要性}

### 下一步

如需將這些建議加入工作清單：
- 使用 Extension Review 階段的 create-extension-cards Agent
- 或手動使用 `uv run scripts/add_pending_cards.py` 腳本
```

## 與 Agent 的關係

| 角色 | 職責 | 輸出 |
|------|------|------|
| **create-extension-cards**（Agent） | 批次評估 + 寫入 CSV | CSV 記錄，自動狀態轉換 |
| **extension-assessment**（Skill） | 單張評估 + 人工報告 | Markdown 報告，供人工決策 |

**互補而非替代**：
- Agent：版本循環中批次處理 30+ 張卡片，自動寫入 CSV
- Skill：人工查詢單張卡片，提供決策參考

## 注意事項

- 此 Skill 只分析和報告，不修改 CSV 或任何檔案
- 評估結果供人工決策參考，非自動執行
- 若需批次評估，請使用 create-extension-cards Agent
