---
name: Extension Interface
description: This skill should be used when the user asks to "extend knowledge-manager", "create a knowledge management plugin for Notion/Obsidian/Linear", "implement SECI for a specific tool", "build a knowledge adapter", or wants to create a tool-specific plugin that inherits from knowledge-manager's theoretical foundation.
version: 0.1.0
---

# Extending Knowledge Manager

This skill defines how tool-specific plugins can extend the knowledge-manager foundation. Extension plugins implement the theoretical framework for specific tools and platforms.

## Extension Philosophy

Knowledge-manager provides:
- **Theoretical foundation**: SECI/GRAI model, Ba contexts, knowledge assets
- **Conceptual vocabulary**: Shared language for knowledge work
- **Phase identification**: Understanding where you are in the spiral
- **Transition guidance**: How to move between phases

Extension plugins provide:
- **Tool-specific operations**: Actions for a particular platform
- **Integration patterns**: How to use the tool for each SECI phase
- **Concrete workflows**: Step-by-step procedures
- **Automation**: Tool-specific scripts and integrations

## Composition Model

Extensions work through **skill composition**—when both plugins are installed, their skills combine:

```
┌─────────────────────────────────────────────────────┐
│              knowledge-manager                       │
│  ┌───────────┐ ┌───────────┐ ┌────────────────┐    │
│  │ seci-grai │ │ ba-context│ │ knowledge-asset│    │
│  └───────────┘ └───────────┘ └────────────────┘    │
└─────────────────────────────────────────────────────┘
                        +
┌─────────────────────────────────────────────────────┐
│              km-notion (extension)                   │
│  ┌────────────────┐ ┌──────────────────────────┐   │
│  │ notion-patterns│ │ notion-externalization   │   │
│  └────────────────┘ └──────────────────────────┘   │
└─────────────────────────────────────────────────────┘
                        =
┌─────────────────────────────────────────────────────┐
│              Combined Context                        │
│  Theory + Notion-specific implementation            │
└─────────────────────────────────────────────────────┘
```

## Extension Plugin Structure

```
km-[tool-name]/
├── .claude-plugin/
│   └── plugin.json
├── skills/
│   └── [tool]-knowledge/
│       ├── SKILL.md
│       └── references/
├── agents/
│   └── [tool]-externalizer.md  (optional)
├── commands/
│   └── externalize.md  (optional)
└── README.md
```

### Plugin.json Requirements

```json
{
  "name": "km-[tool-name]",
  "version": "0.1.0",
  "description": "Knowledge management for [Tool] - extends knowledge-manager",
  "keywords": [
    "knowledge-management",
    "seci-model",
    "[tool-name]"
  ],
  "dependencies": {
    "knowledge-manager": ">=0.1.0"
  }
}
```

**Note:** The `dependencies` field documents the relationship; actual dependency management is handled by installation order.

## What Extensions Implement

### Required: Tool-Specific SECI Patterns

Map each SECI phase to tool operations:

| SECI Phase | Extension Must Define |
|------------|----------------------|
| Socialization | How to share tacit knowledge using [tool] |
| Externalization | How to capture explicit knowledge in [tool] |
| Combination | How to synthesize/organize in [tool] |
| Internalization | How to learn from [tool] content |

### Required: Tool-Specific Ba Contexts

Describe how to create each Ba type within the tool:

```markdown
## [Tool] as Originating Ba
[How to use tool for shared experience]

## [Tool] as Dialoguing Ba
[How to use tool for articulation]

## [Tool] as Systemizing Ba
[How to use tool for organization]

## [Tool] as Exercising Ba
[How to use tool for practice]
```

### Optional: Tool-Specific Agents

Create agents for common tool operations:

```markdown
---
name: [tool]-externalizer
description: Use this agent when the user wants to capture
knowledge in [Tool], create documentation in [Tool], or
externalize tacit understanding using [Tool] features.
---

[System prompt for tool-specific externalization]
```

### Optional: Tool-Specific Commands

Create commands for common workflows:

```markdown
---
name: externalize
description: Capture tacit knowledge in [Tool]
argument-hint: <topic-to-document>
---

[Instructions for tool-specific externalization workflow]
```

## Naming Conventions

### Plugin Names

```
km-[tool-name]
```

Examples:
- `km-notion`
- `km-obsidian`
- `km-linear`
- `km-confluence`

### Skill Names

```
[tool]-knowledge
[tool]-[phase]  (if phase-specific skills)
```

Examples:
- `notion-knowledge`
- `obsidian-externalization`
- `linear-combination`

### Command Names

Use the tool name as namespace:

```
/notion:externalize
/obsidian:combine
/linear:capture
```

## Extension Skill Template

```markdown
---
name: [Tool] Knowledge Patterns
description: This skill should be used when the user asks about
"[Tool] for knowledge management", "SECI in [Tool]",
"documenting in [Tool]", "organizing knowledge in [Tool]",
or needs to apply knowledge management principles using [Tool].
version: 0.1.0
---

# [Tool] Knowledge Management Patterns

This skill extends knowledge-manager with [Tool]-specific patterns.
It maps SECI phases and Ba contexts to [Tool] features.

## Prerequisites

- knowledge-manager plugin installed (provides theoretical foundation)
- [Tool] access configured
- [Any MCP servers or integrations]

## [Tool] for SECI Phases

### Socialization with [Tool]

**Tool features used:** [List relevant features]

**Patterns:**
1. [Pattern name]: [Description]
2. [Pattern name]: [Description]

**Example workflow:**
[Step-by-step for socialization in tool]

### Externalization with [Tool]

**Tool features used:** [List relevant features]

**Patterns:**
1. [Pattern name]: [Description]
2. [Pattern name]: [Description]

**Example workflow:**
[Step-by-step for externalization in tool]

### Combination with [Tool]

**Tool features used:** [List relevant features]

**Patterns:**
1. [Pattern name]: [Description]
2. [Pattern name]: [Description]

**Example workflow:**
[Step-by-step for combination in tool]

### Internalization with [Tool]

**Tool features used:** [List relevant features]

**Patterns:**
1. [Pattern name]: [Description]
2. [Pattern name]: [Description]

**Example workflow:**
[Step-by-step for internalization in tool]

## [Tool] as Ba

[Description of how tool serves each Ba type]

## Integration with knowledge-manager

This skill complements:
- **seci-grai**: For theoretical foundation
- **ba-contexts**: For context selection
- **knowledge-assets**: For asset type identification

Use knowledge-manager skills for "why" and this skill for "how in [Tool]".
```

## Example: Hypothetical km-notion

See `examples/hypothetical-notion-extension.md` for a complete example of what a Notion extension might look like.

## Extension Quality Checklist

### Structure
- [ ] Plugin named `km-[tool-name]`
- [ ] Dependencies documented in plugin.json
- [ ] README explains relationship to knowledge-manager

### Content
- [ ] All four SECI phases mapped to tool
- [ ] All four Ba types addressed
- [ ] Tool features clearly identified
- [ ] Concrete workflows provided
- [ ] Examples included

### Integration
- [ ] References knowledge-manager concepts
- [ ] Uses consistent terminology
- [ ] Complements rather than duplicates foundation

## Additional Resources

### Reference Files

For detailed extension patterns:

- **`references/extension-patterns.md`** - Complete implementation patterns

### Example Files

Working extension examples:

- **`examples/hypothetical-notion-extension.md`** - Full example extension
