# Hypothetical km-notion Extension

This example shows what a complete Notion extension for knowledge-manager might look like.

## Plugin Structure

```
km-notion/
├── .claude-plugin/
│   └── plugin.json
├── skills/
│   └── notion-knowledge/
│       ├── SKILL.md
│       └── references/
│           ├── page-templates.md
│           ├── database-patterns.md
│           └── workflows.md
├── agents/
│   └── notion-externalizer.md
├── commands/
│   ├── externalize.md
│   └── synthesize.md
├── .mcp.json
└── README.md
```

## plugin.json

```json
{
  "name": "km-notion",
  "version": "0.1.0",
  "description": "Knowledge management patterns for Notion - extends knowledge-manager",
  "author": {
    "name": "Example Author",
    "email": "author@example.com"
  },
  "keywords": [
    "knowledge-management",
    "seci-model",
    "notion"
  ],
  "dependencies": {
    "knowledge-manager": ">=0.1.0"
  }
}
```

## SKILL.md (notion-knowledge)

```markdown
---
name: Notion Knowledge Patterns
description: This skill should be used when the user asks about "Notion for knowledge management", "SECI in Notion", "documenting in Notion", "organizing knowledge in Notion", "Notion knowledge base", or needs to apply knowledge management principles using Notion.
version: 0.1.0
---

# Notion Knowledge Management Patterns

This skill extends knowledge-manager with Notion-specific patterns for implementing SECI phases and creating Ba contexts using Notion's features.

## Prerequisites

- knowledge-manager plugin installed
- Notion workspace access
- Notion MCP server configured (optional, for automation)

## Notion for SECI Phases

### Socialization with Notion

**Tool features:** Comments, mentions, real-time collaboration, shared cursors

**Patterns:**

1. **Collaborative Exploration Pages**: Create temporary pages for joint exploration
   - Real-time editing builds shared understanding
   - Comments capture emerging insights
   - Delete after externalization complete

2. **Team Wikis with Open Editing**: Shared spaces where anyone can contribute
   - Low barrier to adding observations
   - Mentions bring in relevant expertise

**Example workflow:**
1. Create "Exploration: [Topic]" page
2. Invite collaborators
3. Add initial thoughts, questions, observations
4. Use comments for discussion
5. When shared understanding emerges, move to externalization

### Externalization with Notion

**Tool features:** Pages, databases, templates, blocks, callouts

**Patterns:**

1. **Structured Templates**: Pre-defined page structures for concepts
   - Specification template
   - Decision record template
   - Process documentation template

2. **Database-as-Glossary**: Definitions as database entries
   - Properties for relationships, status, owner
   - Multiple views (table, gallery, list)

3. **Progressive Formalization**:
   - Start with bullet points
   - Refine into paragraphs
   - Add structure with headings
   - Extract to templates

**Example workflow:**
1. Create page from template
2. Fill in sections with tacit understanding
3. Use AI to help structure and formalize
4. Review and refine
5. Link to related pages

### Combination with Notion

**Tool features:** Databases, relations, rollups, linked databases, search

**Patterns:**

1. **Knowledge Database**: Central database of all knowledge artifacts
   - Type property (Concept, Process, Decision, Reference)
   - Status property (Draft, Review, Published, Archived)
   - Relations to other entries

2. **Synthesis Pages**: Pages that link and summarize related content
   - Linked database views showing related items
   - Narrative connecting the pieces
   - Gap identification

3. **Search-Driven Discovery**:
   - Full-text search across workspace
   - Filtered views for specific topics
   - Recent additions tracking

**Example workflow:**
1. Identify sources to combine
2. Create synthesis page
3. Add linked database view of sources
4. Write narrative connecting insights
5. Identify gaps and contradictions
6. Update source pages as needed

### Internalization with Notion

**Tool features:** Toggle blocks, callouts, embedded content, synced blocks

**Patterns:**

1. **Progressive Disclosure Pages**: Toggle-based learning
   - Question in toggle heading
   - Answer hidden inside
   - Self-test before revealing

2. **Annotated Examples**: Documented walkthroughs
   - Step-by-step with explanations
   - Callouts highlighting key points
   - Links to reference material

3. **Practice Checklists**: Guided application
   - Task lists for practicing procedures
   - Links to relevant documentation
   - Space for notes and reflections

**Example workflow:**
1. Find relevant documentation
2. Create practice page with exercises
3. Work through exercises
4. Document learnings and questions
5. Update documentation with insights

## Notion as Ba

### Originating Ba
- **Where:** Temporary collaboration pages
- **How:** Real-time editing, comments, mentions
- **Delete:** After insights captured elsewhere

### Dialoguing Ba
- **Where:** Documentation pages with templates
- **How:** Structured templates, AI-assisted drafting
- **Review:** Regular review cycles

### Systemizing Ba
- **Where:** Databases, wikis, linked structures
- **How:** Relations, rollups, views, search
- **Maintain:** Regular curation, archival

### Exercising Ba
- **Where:** Practice pages, embedded exercises
- **How:** Toggle blocks, checklists, examples
- **Track:** Completion, understanding checks

## Knowledge Asset Mapping

| Asset Type | Notion Implementation |
|------------|----------------------|
| Experiential | Shared pages, team wikis, comments |
| Conceptual | Structured pages, specifications, decisions |
| Systemic | Databases, relations, linked views |
| Routine | Checklists, procedures, practice pages |

## Additional Resources

See references/ for:
- **page-templates.md** - Templates for each knowledge type
- **database-patterns.md** - Database structures for KM
- **workflows.md** - Step-by-step workflows
```

## Agent: notion-externalizer.md

```markdown
---
name: notion-externalizer
description: Use this agent when the user wants to capture knowledge in Notion, create documentation in Notion, externalize tacit understanding using Notion features, or structure thoughts for Notion pages. Examples:

<example>
Context: User has tacit understanding to document
user: "I need to document how our auth system works in Notion"
assistant: "I'll help you externalize that knowledge into a Notion page."
<commentary>
Converting tacit understanding to Notion documentation is core externalization.
</commentary>
</example>

<example>
Context: User has informal notes to formalize
user: "Turn these meeting notes into a proper Notion spec"
assistant: "I'll help structure these notes into a Notion specification."
<commentary>
Formalizing notes into structured Notion content is externalization.
</commentary>
</example>

model: inherit
color: blue
tools: ["Read", "Write", "Grep"]
---

You are a knowledge externalization specialist for Notion. Your role is to help convert tacit knowledge and informal notes into well-structured Notion pages.

**Your Core Responsibilities:**
1. Understand the tacit knowledge to be captured
2. Select appropriate Notion page structure/template
3. Guide progressive formalization
4. Ensure proper linking and categorization
5. Review for completeness and clarity

**Externalization Process:**

1. **Understand the Knowledge**:
   - What type of knowledge? (Concept, Process, Decision, Reference)
   - What's the audience?
   - What's the depth needed?

2. **Select Structure**:
   - Concept → Definition, examples, relationships
   - Process → Steps, prerequisites, outcomes
   - Decision → Context, options, choice, rationale
   - Reference → Source, summary, applications

3. **Guide Articulation**:
   - Ask clarifying questions
   - Suggest metaphors and analogies
   - Request examples
   - Probe for edge cases

4. **Structure Output**:
   - Clear heading hierarchy
   - Callouts for key points
   - Links to related pages
   - Properties/metadata

5. **Review**:
   - Completeness check
   - Clarity assessment
   - Linking recommendations
   - Next steps

**Output Format:**

Provide Notion-ready markdown with:
- Clear headings (# ## ###)
- Callout syntax for highlights
- Link placeholders for relations
- Property suggestions for database entry
```

## Command: externalize.md

```markdown
---
name: externalize
description: Capture tacit knowledge into a structured Notion page
argument-hint: <topic-to-document>
allowed-tools: ["Read", "Write", "Grep", "AskUserQuestion"]
---

# Externalize to Notion

Guide the user through capturing tacit knowledge into a Notion page.

## Process

1. **Identify the knowledge type**:
   - Ask: "What type of knowledge is this?"
   - Options: Concept, Process, Decision, Reference

2. **Gather tacit understanding**:
   - Ask clarifying questions about the topic
   - Request examples and edge cases
   - Probe for rationale and context

3. **Select template**:
   Based on type, use appropriate structure from references/page-templates.md

4. **Draft the page**:
   - Fill template with gathered information
   - Add links to related concepts
   - Include examples and illustrations

5. **Review and refine**:
   - Check for completeness
   - Verify clarity for target audience
   - Suggest improvements

6. **Provide output**:
   - Notion-ready markdown
   - Suggestions for database properties
   - Recommended links to add

## Output

Return a complete Notion page draft ready for copy-paste or API creation.
```

## README.md

```markdown
# km-notion

Knowledge management patterns for Notion, extending the knowledge-manager plugin.

## Overview

This plugin implements SECI/GRAI knowledge management patterns specifically for Notion workspaces. It provides:

- Notion-specific SECI phase implementations
- Page and database templates for knowledge assets
- Workflows for knowledge capture and organization
- AI-assisted externalization

## Prerequisites

- [knowledge-manager](link) plugin installed
- Notion workspace
- (Optional) Notion MCP server for automation

## Installation

1. Install knowledge-manager first
2. Install km-notion

## Usage

### Skills

The `notion-knowledge` skill loads when you ask about:
- "Notion knowledge management"
- "SECI in Notion"
- "Organizing knowledge in Notion"

### Commands

- `/notion:externalize <topic>` - Capture tacit knowledge to Notion
- `/notion:synthesize <pages>` - Combine Notion pages

### Agents

- `notion-externalizer` - Specialized agent for Notion documentation

## Integration

This plugin extends knowledge-manager. Both sets of skills work together:
- knowledge-manager provides theoretical foundation
- km-notion provides Notion-specific implementation

## License

MIT
```

---

This example demonstrates the full structure and approach for creating a tool-specific extension to knowledge-manager.
