# Extension Implementation Patterns

## Pattern 1: Documentation Tool Extension

For tools like Notion, Confluence, Google Docs, Obsidian.

### Core Mapping

| SECI Phase | Documentation Tool Pattern |
|------------|---------------------------|
| Socialization | Comments, mentions, real-time collaboration |
| Externalization | Page/document creation, templates |
| Combination | Linking, databases, search, synthesis |
| Internalization | Reading workflows, embedded exercises |

### Implementation Approach

**Externalization-heavy:** Documentation tools excel at Externalization.

Primary skill should cover:
1. Template library for different concept types
2. Structured capture workflows
3. AI-assisted drafting patterns
4. Review and refinement processes

**Combination features:**
- Database views and relations (Notion)
- Link graphs and backlinks (Obsidian)
- Search and filtering
- Tag/category systems

### Example Skill Structure

```
km-notion/
├── skills/
│   └── notion-knowledge/
│       ├── SKILL.md              # Core patterns
│       ├── references/
│       │   ├── templates.md      # Page templates by asset type
│       │   ├── databases.md      # Database patterns for KM
│       │   └── workflows.md      # Step-by-step workflows
│       └── examples/
│           └── knowledge-base-setup.md
└── commands/
    ├── externalize.md            # Capture tacit to Notion
    └── synthesize.md             # Combine Notion pages
```

---

## Pattern 2: Project Management Tool Extension

For tools like Linear, Jira, Asana, Monday.

### Core Mapping

| SECI Phase | PM Tool Pattern |
|------------|-----------------|
| Socialization | Issue comments, team discussions |
| Externalization | Issue creation, specification writing |
| Combination | Epic/project organization, roadmaps |
| Internalization | Task execution, retrospective learnings |

### Implementation Approach

**Process-embedded:** PM tools embed knowledge in workflow.

Primary skill should cover:
1. Issue templates that capture knowledge
2. Epic structures for knowledge domains
3. Label/tag systems for knowledge types
4. Comment conventions for knowledge capture

**Special considerations:**
- Knowledge often implicit in issues
- Need explicit "knowledge capture" workflows
- Link to external documentation

### Example Skill Structure

```
km-linear/
├── skills/
│   └── linear-knowledge/
│       ├── SKILL.md
│       └── references/
│           ├── issue-templates.md
│           ├── project-structure.md
│           └── knowledge-labels.md
└── commands/
    └── capture-learning.md       # Capture from completed work
```

---

## Pattern 3: Communication Tool Extension

For tools like Slack, Discord, Teams.

### Core Mapping

| SECI Phase | Communication Tool Pattern |
|------------|---------------------------|
| Socialization | Channels, threads, huddles |
| Externalization | Pinned messages, canvases |
| Combination | Channel organization, search |
| Internalization | Following experts, reading history |

### Implementation Approach

**Socialization-heavy:** Communication tools excel at real-time sharing.

Primary skill should cover:
1. Channel structure for knowledge flow
2. Conventions for capturing from conversations
3. Integration with documentation tools
4. Search strategies for finding past knowledge

**Challenge:** Ephemeral nature of chat - need capture mechanisms.

### Example Skill Structure

```
km-slack/
├── skills/
│   └── slack-knowledge/
│       ├── SKILL.md
│       └── references/
│           ├── channel-patterns.md
│           ├── capture-workflows.md
│           └── integration-guide.md
└── commands/
    └── capture-thread.md         # Externalize from thread
```

---

## Pattern 4: Note-Taking Tool Extension

For tools like Obsidian, Roam, Logseq.

### Core Mapping

| SECI Phase | Note Tool Pattern |
|------------|------------------|
| Socialization | Shared vaults, collaborative editing |
| Externalization | Daily notes, fleeting to permanent |
| Combination | Links, tags, graph exploration |
| Internalization | Spaced repetition, progressive summarization |

### Implementation Approach

**Personal knowledge focus:** These tools often emphasize individual knowledge.

Primary skill should cover:
1. Note types mapped to knowledge assets
2. Linking strategies for knowledge connection
3. Review workflows for internalization
4. Templates for different knowledge types

**Special features:**
- Graph-based exploration
- Bidirectional linking
- Spaced repetition plugins

### Example Skill Structure

```
km-obsidian/
├── skills/
│   └── obsidian-knowledge/
│       ├── SKILL.md
│       └── references/
│           ├── note-types.md
│           ├── linking-patterns.md
│           └── review-workflows.md
├── commands/
│   └── process-daily.md          # Convert daily to permanent
└── assets/
    └── templates/                # Obsidian template files
```

---

## MCP Integration Patterns

### When to Add MCP Servers

Add MCP servers when the extension needs:
- Direct API access to the tool
- Automated operations
- Read/write capabilities
- Real-time synchronization

### MCP Server Structure

```json
{
  "mcpServers": {
    "[tool]-api": {
      "command": "npx",
      "args": ["-y", "@[org]/[tool]-mcp"],
      "env": {
        "[TOOL]_API_KEY": "${[TOOL]_API_KEY}"
      }
    }
  }
}
```

### Tool Integration Without MCP

If no MCP server available:
- Provide manual workflows
- Use export/import patterns
- Leverage web interfaces
- Document API usage for advanced users

---

## Agent Design Patterns

### Phase-Specific Agents

Create agents for phases where tool excels:

```markdown
---
name: [tool]-externalizer
description: Use this agent when capturing knowledge in [Tool]
---

You specialize in converting tacit understanding into structured
[Tool] content...
```

### Tool-Aware General Agents

Extend knowledge-manager agents with tool context:

```markdown
This agent uses [Tool] for:
- Phase identification: Check existing [Tool] content
- Recommendations: Suggest specific [Tool] operations
- Output: Create or update [Tool] artifacts
```

---

## Command Design Patterns

### Phase Commands

```
/[tool]:externalize <topic>    # Tacit → Tool content
/[tool]:combine <sources>      # Multiple → Synthesis
/[tool]:capture <context>      # Quick knowledge capture
```

### Workflow Commands

```
/[tool]:daily-process          # Process daily captures
/[tool]:review                 # Knowledge review cycle
/[tool]:sync                   # Sync with other tools
```

### Assessment Commands

```
/[tool]:health                 # Check knowledge base health
/[tool]:gaps                   # Identify coverage gaps
```

---

## Testing Extensions

### Skill Testing

1. Install knowledge-manager
2. Install extension
3. Ask questions using trigger phrases
4. Verify both skills load and complement

**Test queries:**
- "[Tool] SECI patterns" → Should trigger both seci-grai and [tool]-knowledge
- "Externalize in [Tool]" → Should load extension skill
- "What phase is this?" → Should load knowledge-manager skill

### Integration Testing

1. Test phase identification with tool context
2. Test recommendations include tool-specific actions
3. Test output formats match tool requirements

---

## Versioning and Compatibility

### Semantic Versioning

```
MAJOR.MINOR.PATCH

MAJOR: Breaking changes to extension interface
MINOR: New features, backward compatible
PATCH: Bug fixes
```

### Dependency Declaration

```json
{
  "dependencies": {
    "knowledge-manager": ">=0.1.0 <1.0.0"
  }
}
```

### Handling Updates

When knowledge-manager updates:
1. Check for interface changes
2. Update terminology if changed
3. Test skill composition still works
4. Update dependency version range
