# Finance Tracking Reference

## Transaction Schema

```yaml
---
type: transaction
date: YYYY-MM-DD           # Transaction date
amount: float              # Positive=income, negative=expense
category: string           # Expense category
vendor: string             # Vendor/payee name
description: string        # Original transaction description
is_recurring: boolean      # True if subscription/recurring
frequency: string          # monthly, annual, weekly (if recurring)
requires_review: boolean   # True if needs human review
tags: list                 # Additional categorization
---
```

## Category Definitions

### Software/SaaS
- **Keywords**: subscription, monthly, annual, pro, premium, enterprise
- **Patterns**: *.com, *.io, *.app domain payments
- **Budget**: Configurable, default $500/month
- **Review triggers**: New subscription, price increase >10%

### Marketing
- **Keywords**: ads, advertising, campaign, social, boost, promotion
- **Vendors**: Facebook, Google Ads, LinkedIn, Twitter
- **Budget**: Configurable, default $1000/month
- **Review triggers**: Single charge >$200, daily spend >$50

### Office Supplies
- **Keywords**: office, supplies, paper, ink, equipment
- **Vendors**: Amazon, Staples, Office Depot
- **Budget**: Configurable, default $200/month
- **Review triggers**: Single item >$100

### Utilities
- **Keywords**: electric, gas, water, internet, phone, mobile
- **Vendors**: Utility companies, ISPs, carriers
- **Budget**: Configurable, default $300/month
- **Review triggers**: Increase >20% from average

### Travel
- **Keywords**: flight, hotel, car, ride, uber, lyft, airbnb
- **Vendors**: Airlines, hotels, rideshare
- **Budget**: Configurable, default $500/month
- **Review triggers**: International travel, >$500 single charge

### Professional Services
- **Keywords**: consulting, legal, accounting, advisory
- **Budget**: Variable (project-based)
- **Review triggers**: Always require review

## Subscription Detection

```python
SUBSCRIPTION_PATTERNS = {
    # Productivity
    'notion.so': {'name': 'Notion', 'typical': 10.00},
    'slack.com': {'name': 'Slack', 'typical': 8.75},
    'github.com': {'name': 'GitHub', 'typical': 4.00},
    'atlassian.com': {'name': 'Atlassian', 'typical': 10.00},

    # Cloud/Infrastructure
    'aws.amazon.com': {'name': 'AWS', 'typical': 'variable'},
    'cloud.google.com': {'name': 'Google Cloud', 'typical': 'variable'},
    'azure.microsoft.com': {'name': 'Azure', 'typical': 'variable'},
    'digitalocean.com': {'name': 'DigitalOcean', 'typical': 'variable'},

    # AI/ML
    'openai.com': {'name': 'OpenAI', 'typical': 20.00},
    'anthropic.com': {'name': 'Anthropic', 'typical': 20.00},

    # Design
    'adobe.com': {'name': 'Adobe CC', 'typical': 54.99},
    'figma.com': {'name': 'Figma', 'typical': 15.00},
    'canva.com': {'name': 'Canva', 'typical': 12.99},

    # Communication
    'zoom.us': {'name': 'Zoom', 'typical': 14.99},

    # Storage
    'dropbox.com': {'name': 'Dropbox', 'typical': 11.99},

    # Entertainment (flag for review)
    'netflix.com': {'name': 'Netflix', 'typical': 15.99, 'review': True},
    'spotify.com': {'name': 'Spotify', 'typical': 10.99, 'review': True},
}
```

## Budget Tracking

### Budget File Structure
```markdown
# Budget Status - [Month Year]

**Last Updated**: [timestamp]

## Summary
- Total Budget: $[total]
- Total Spent: $[spent]
- Remaining: $[remaining]
- Days Left: [days]

## By Category

| Category | Budget | Spent | Remaining | Status |
|----------|--------|-------|-----------|--------|
| [cat] | $[bud] | $[spent] | $[rem] | [🟢🟡🔴] |

## Alerts
- [Any over-budget or near-budget categories]

## Recent Transactions
| Date | Vendor | Amount | Category |
|------|--------|--------|----------|
```

### Status Indicators
- 🟢 Green: < 70% of budget used
- 🟡 Yellow: 70-90% of budget used
- 🔴 Red: > 90% of budget used

## Revenue Tracking

### Invoice Record
```yaml
---
type: invoice
invoice_number: INV-2026-001
client: Client Name
amount: 1500.00
date_issued: 2026-01-01
date_due: 2026-01-31
status: pending|paid|overdue
---
```

### Revenue Summary
```markdown
# Revenue - [Month Year]

## Summary
- Total Invoiced: $[amount]
- Total Received: $[amount]
- Outstanding: $[amount]

## Invoices
| Invoice | Client | Amount | Due | Status |
|---------|--------|--------|-----|--------|
```

## Alert Thresholds

| Condition | Alert Level | Action |
|-----------|-------------|--------|
| Budget > 90% | High | Dashboard alert |
| Budget exceeded | Critical | Human notification |
| Unknown vendor > $100 | Medium | Categorization review |
| Duplicate charge | High | Immediate flag |
| Subscription price up > 10% | Medium | Review suggestion |
| Invoice overdue | High | Collection reminder |

## Xero Integration

For accounting sync with Xero:
- Configure Xero MCP server
- Map categories to Xero accounts
- Sync transactions daily
- Generate reconciliation reports
