---
name: firmographic-analysis
description: Use when interpreting company-level enrichment data to segment accounts, spot buying triggers, and tailor outreach.
---

# Firmographic Analysis Skill

## When to Use
- Prioritizing enriched accounts for GTM plays.
- Building segments for ABM, territory planning, or personalized campaigns.
- Validating enriched firmographic data quality.

## Framework
1. **Normalize Fields** – ensure industry, size, revenue, region, and funding fields use consistent taxonomies.
2. **Scoring Matrix** – apply ICP scoring (industry fit, employee band, revenue, growth rate).
3. **Trigger Detection** – highlight events like funding, IPO prep, hiring spikes, geographic expansion.
4. **Segment Mapping** – assign each company to journey stages or playbooks (e.g., "High-growth SaaS 200-500").
5. **Recommendation Output** – produce persona targets, value props, and urgency level per segment.

## Templates
- Segment summary table (columns: segment, criteria, TAM, coverage owner, next action).
- Trigger event log with timestamps/source, impact rating, and follow-up play.
- Messaging workbook mapping persona × segment × proof points for instant enablement pulls.

## Tips
- Keep taxonomy dictionaries centrally managed so enrichment jobs and analytics share the same lookups.
- Re-score accounts quarterly or after major firmographic events (funding, layoffs) to keep priorities fresh.
- Pair quant scores with qualitative notes from AEs/CSMs to avoid over-rotating on enrichment data alone.

---
