---
name: first-principles
description: Independent thinking framework using first-principles reasoning to break down problems, evaluate opinions, make decisions, and find truth without relying on authority, social proof, or conventional wisdom. Use when Claude needs to: (1) Analyze problems from fundamental truths instead of accepting assumptions, (2) Evaluate arguments and opinions to identify logical fallacies and hidden premises, (3) Make decisions based on first principles rather than following others, (4) Cut through controversial debates to find underlying truths, (5) Think independently instead of accepting conventional wisdom
---

# First-Principles Thinking Framework

## When to Use This Skill

Apply this framework when you need to think independently rather than accepting:
- Expert opinions or authority arguments
- Conventional wisdom or "common knowledge"
- Social proof or majority consensus
- Emotional appeals or charismatic rhetoric
- Historical precedent or tradition

## The First-Principles Framework

### Step 1: Identify the Question or Problem

**State the core question explicitly:**
- What are we actually trying to understand?
- What decision needs to be made?
- What truth are we seeking?

**Example**: Instead of "Should I invest in crypto?", reframe as "What determines the value of a medium of exchange?"

### Step 2: Extract All Assumptions

**List every assumption in the argument:**
- What premises are being accepted without evidence?
- What is being treated as "obvious" or "common knowledge"?
- What authorities are being appealed to?
- What emotional triggers are present?

**Assumption Detection Patterns:**
- "Everyone knows..." → Flag as social proof
- "Experts say..." → Flag as authority appeal
- "It's obvious that..." → Flag as hidden premise
- "Studies show..." → Demand methodology
- "History proves..." → Demand context

### Step 3: Strip to Fundamentals

**Question each assumption:**
- Is this assumption actually true? How do we know?
- Can we prove this from first principles?
- What evidence would falsify this?
- Is this a causal relationship or correlation?

**Fundamental Truth Categories:**
- **Logical truths**: Mathematical/logical necessities (2+2=4)
- **Empirical truths**: Observable, testable facts (water boils at 100°C at 1 atm)
- **Definitional truths**: True by definition (bachelors are unmarried)
- **Reject**: Tradition, authority, popularity, intuition

### Step 4: Reconstruct from Ground Up

**Build logical chains from proven fundamentals:**
1. Start with verified fundamental truths
2. Apply valid deductive reasoning
3. Test conclusions against empirical reality
4. Identify what follows necessarily vs. probabilistically

**Logical Validity Check:**
- Does conclusion follow necessarily from premises?
- Are there logical fallacies (ad hominem, straw man, etc.)?
- Are there missing premises or leaps in logic?
- Is the argument structurally sound?

### Step 5: Test Against Reality

**Validate with empirical evidence:**
- What predictions does this reasoning generate?
- Can we test those predictions?
- What would count as falsification?
- Are there counter-examples?

**Bayesian Updating:**
- Assign initial probability based on first-principles reasoning
- Update based on empirical evidence
- Distinguish between "proven" and "more likely than not"

### Step 6: Identify Remaining Uncertainty

**Acknowledge what we don't know:**
- What premises remain uncertain?
- What empirical evidence is missing?
- What probability ranges are reasonable?
- What would change our conclusion?

**Intellectual Honesty:**
- Distinguish between "proven" and "probable"
- Admit when evidence is insufficient
- Identify what would settle the question
- Avoid false certainty

## Common Thinking Patterns to Avoid

### Authority Worship
**Pattern**: "Expert X says Y, so Y is true"
**First-Principles Response**: Authority is irrelevant to truth. Evaluate the argument, not the source.

### Social Proof
**Pattern**: "Everyone believes X, so X is true"
**First-Principles Response**: Majority opinion proves popularity, not truth. History is full of widely-believed falsehoods.

### Tradition Appeal
**Pattern**: "We've always done X, so X is right"
**First-Principles Response**: Past practice proves nothing about present optimality. Evaluate from first principles.

### Confirmation Bias
**Pattern**: Seeking evidence that confirms existing beliefs
**First-Principles Response**: Actively seek disconfirming evidence. Ask "What would prove me wrong?"

### False Dichotomy
**Pattern**: "Either X or Y must be true"
**First-Principles Response**: Are there other options? Are X and Y mutually exclusive? Question the frame.

## Output Format

When applying this framework, structure responses as:

```
## [Core Question]

### Assumptions Identified
- [List all assumptions extracted]

### Fundamental Truths
- [List verified first principles]

### First-Principles Analysis
[Step-by-step logical reconstruction]

### Empirical Tests
[How to validate against reality]

### Remaining Uncertainty
[What we still don't know]

### Independent Conclusion
[Your conclusion based on above, not on others' opinions]
```

## Key Principles

1. **Question Everything**: No premise is accepted without justification
2. **Authority is Irrelevant**: Truth exists independent of who says it
3. **Logic Over Intuition**: Feelings are not evidence
4. **Evidence Over Assertion**: Demand proof, don't accept claims
5. **Uncertainty is Honesty**: Admit what you don't know
6. **Update Beliefs**: Change your mind when evidence demands it

## Advanced Frameworks

For complex problems, see:
- **frameworks.md**: Detailed methods (5 Whys, Socratic questioning, assumption mapping)
- **examples.md**: Concrete applications across domains

Remember: The goal is not to be contrarian, but to be correct. First-principles thinking often leads to unconventional conclusions because conventional thinking is often flawed.
