# First-Principles Thinking Frameworks

This reference contains detailed methodologies for first-principles reasoning. Use these techniques when the basic framework needs deeper analysis.

## Table of Contents
1. [The 5 Whys](#the-5-whys)
2. [Socratic Questioning](#socratic-questioning)
3. [Assumption Mapping](#assumption-mapping)
4. [Inversion Thinking](#inversion-thinking)
5. [Thought Experiments](#thought-experiments)
6. [Steel-Manning](#steel-manning)

---

## The 5 Whys

### Purpose
Drill down to root causes by repeatedly asking "why?" until reaching fundamental truths.

### Method
1. State the problem/claim
2. Ask "Why is this true?"
3. Take the answer and ask "Why is THAT true?"
4. Repeat 5 times or until reaching bedrock

### Example
**Claim**: "Remote work destroys productivity"

1. Why? "Because people get distracted at home"
2. Why? "Because there's no supervision"
3. Why does supervision matter? "Because people won't work without oversight"
4. Why? "Because work is inherently unpleasant"
5. Why? "Because most jobs are meaningless drudgery"

**First-principles conclusion**: The problem isn't remote work; it's that most jobs are designed so poorly that coercion is required.

### When to Use
- Analyzing causal claims
- Finding root causes of problems
- Exposing hidden premises in arguments

---

## Socratic Questioning

### Purpose
Systematically question beliefs through disciplined questioning to expose contradictions and assumptions.

### Question Types

#### Clarification Questions
- What do you mean by that?
- Can you explain that in simpler terms?
- How would you define [key term]?
- What's the core question we're trying to answer?

#### Assumption-Probing Questions
- What are you taking for granted here?
- What would have to be true for this to hold?
- Is this always true, or just sometimes?
- What's the evidence for that premise?

#### Evidence Questions
- What data supports this?
- How do you know this is true?
- What would convince you this is false?
- Are there alternative explanations?

#### Perspective Questions
- What would someone who disagrees say?
- What if the opposite were true?
- How would this look from a different angle?
- What are we not considering?

#### Implication Questions
- What follows from this?
- If this is true, what else must be true?
- What are the consequences of this belief?
- Where does this logic lead?

#### Consistency Questions
- How does this fit with what you said earlier?
- Does this contradict your other beliefs?
- Are you applying the same standard elsewhere?
- Is this principle universal or situational?

### Example Dialogue
**Claim**: "We need to regulate social media to protect democracy"

**Socratic Response**:
- What threat does social media pose to democracy specifically?
- What evidence shows democracy is being harmed?
- How do you distinguish between "harmful disagreement" and "legitimate dissent"?
- Who decides what counts as harmful?
- What prevents regulators from abusing this power?
- Has government regulation of speech ever harmed democracy?

### When to Use
- Evaluating complex arguments
- Exposing contradictions in thinking
- Finding weak points in claims

---

## Assumption Mapping

### Purpose
Visualize and evaluate all assumptions in an argument to identify weakest links.

### Method

#### Step 1: Map the Argument Chain
```
[Conclusion]
    ↑
[Intermediate Claim]
    ↑
[Supporting Evidence]
    ↑
[Assumptions]
```

#### Step 2: Classify Assumptions by Type
- **Explicit assumptions**: Stated directly
- **Implicit assumptions**: Unstated but necessary
- **Definitional assumptions**: About meaning of terms
- **Causal assumptions**: About cause-effect relationships
- **Normative assumptions**: About what "should" be

#### Step 3: Evaluate Each Assumption
For each assumption, ask:
1. Is this assumption necessary for the argument?
2. Is this assumption actually true?
3. What evidence supports it?
4. What would falsify it?
5. How strong is this link (certain/probable/possible)?

#### Step 4: Identify Weakest Links
- Mark assumptions that are either false or uncertain
- The argument is only as strong as its weakest link

### Example
**Argument**: "We should raise minimum wage because it reduces poverty"

```
[Conclusion: Raise minimum wage]
    ↑
[Intermediate: It reduces poverty]
    ↑
[Assumption 1: Higher wages → More income for poor] ✓ (true)
[Assumption 2: More income → Less poverty] ✓ (mostly true)
[Assumption 3: No job losses from wage increase] ? (uncertain)
[Assumption 4: No price increases that offset gains] ? (uncertain)
[Assumption 5: Government can effectively enforce] ✓ (mostly true)
```

**First-principles analysis**: Argument depends critically on assumptions 3 and 4, which are empirically uncertain.

### When to Use
- Complex policy arguments
- Evaluating predictions
- Analyzing chain-of-reasoning claims

---

## Inversion Thinking

### Purpose
Instead of asking "How do I achieve X?", ask "How do I ensure the opposite of X?" This exposes hidden assumptions and reveals what actually matters.

### Method
1. State the goal
2. Invert: "What would guarantee failure?"
3. Avoid those things

### Examples

**Goal**: "Make a successful product"

**Inversion**: "How do I guarantee a product fails?"
- Build something nobody wants
- Make it hard to use
- Price it irrationally
- Ignore customer feedback
- Enter a saturated market with no differentiation

**First-principles insight**: Success requires avoiding these failures. Focus on:
- Solve real problems
- Optimize user experience
- Price rationally
- Listen to users
- Find unique value proposition

**Goal**: "Have a successful democracy"

**Inversion**: "How do I destroy a democracy?"
- Concentrate power
- Eliminate checks and balances
- Control information
- Discredit independent institutions
- Polarize the population
- Normalize corruption

**First-principles insight**: Democratic health requires:
- Separation of powers
- Free press
- Independent institutions
- Social cohesion
- Rule of law

### When to Use
- Problem-solving
- Strategic planning
- Risk assessment

---

## Thought Experiments

### Purpose
Test reasoning by constructing hypothetical scenarios that isolate variables and test principles.

### Types of Thought Experiments

#### Isolation Experiments
Remove complicating factors to test pure principles.

**Example**: "Is taxation theft?" → Imagine a society with no taxes. What happens? What services disappear? How are they provided?

#### Extreme Cases
Push a principle to its logical extreme to test validity.

**Example**: "Free speech is absolute" → Should we allow someone to shout "fire" in a crowded theater? If not, what's the principle for limiting speech?

#### Perspective Shifts
Change viewpoints to test universality.

**Example**: "Criminals deserve harsh punishment" → Imagine you're wrongly accused. What due process protections would you want?

#### Counterfactuals
Imagine key facts being different to test causality.

**Example**: "WWII ended the Great Depression" → Imagine WWII hadn't happened. Would the depression have continued forever? What else was changing?

### Method
1. Identify the principle being tested
2. Design an experiment that isolates that principle
3. Run the experiment mentally
4. See what the principle implies in that scenario
5. Check if the implication is valid/reasonable

### When to Use
- Testing moral/political principles
- Examining causal claims
- Checking logical consistency

---

## Steel-Manning

### Purpose
Engage with the strongest version of opposing arguments, not straw men. This ensures you're addressing real objections, not weak ones.

### Method
1. Identify the opposing view
2. Research it thoroughly
3. Reconstruct the strongest version of that argument
4. Address THAT version, not a weak caricature

### Why Steel-Man?
- If you can refute the strongest version, your position is robust
- If you can only refute weak versions, you haven't proven anything
- Steel-manning exposes you to best arguments and forces intellectual honesty

### Example
**Weak view (straw man)**: "People oppose immigration because they're racist"

**Strong view (steel man)**: "People oppose immigration because:
- Rapid cultural change creates social friction
- Labor supply increases can depress wages in certain sectors
- Social welfare systems become financially strained
- Social cohesion requires some shared values and identity
- Different immigrant groups have different integration outcomes"

**First-principles response**: Now we can engage with real concerns about social cohesion, economic impacts, and integration capacity—not just dismiss people as racist.

### When to Use
- Before critiquing any argument
- When you disagree with someone
- When testing your own beliefs

---

## Combining Frameworks

The most powerful analysis combines multiple frameworks:

### Example: "Should we ban AI development?"

**5 Whys**:
1. Why ban AI? Fear of existential risk
2. Why existential risk? AI might become uncontrollable
3. Why uncontrollable? It might become smarter than us
4. Why is that bad? It might have goals misaligned with human values
5. Why misaligned? Because we don't know how to specify values perfectly

**Socratic Questions**:
- What does "smarter than us" mean?
- Can intelligence be separated from goals?
- What evidence do we have about future AI behavior?
- Can we ban development globally or just locally?

**Assumption Mapping**:
- Assumption 1: AI will become superintelligent (uncertain)
- Assumption 2: Superintelligence will be uncontrollable (debatable)
- Assumption 3: Misaligned goals are likely (open question)
- Assumption 4: Banning is enforceable (doubtful)
- Assumption 5: Banning reduces risk more than it increases other risks (unclear)

**Inversion**:
- How do we guarantee AI harms us?
- Ban it locally but not globally (adversaries develop it unchecked)
- Make it secret and unregulated
- Don't research safety/alignment

**Steel-Man the opposition**:
- Pro-ban argument: Even small probability of existential risk justifies drastic action
- Anti-ban argument: Banning ensures bad actors get it first; we need defensive capabilities

**Conclusion**: The question isn't "ban or not ban" but "how do we navigate a world where AI development happens regardless?" The first-principles question is about what's actually achievable, not what's ideal.
