---
name: fit-check
description: 채용 공고와 회사 소개 URL로 적합성 분석 리포트 자동 생성. job-posting-analyzer와 about-analyzer 에이전트를 병렬 실행하여 분석 후, result-design 디자인 시스템을 적용한 HTML 리포트 생성.
allowed-tools: Read, Write, WebFetch, WebSearch, Task
user-invocable: true
---

# 적합성 분석 스킬 (Fit Check)

채용 공고와 회사 소개 URL만으로 지원자-회사 적합성 분석 리포트를 자동 생성합니다.

## 사용법

```
/fit-check [채용공고URL] [회사소개URL(선택)]
```

**예시:**

```
/fit-check https://company.com/jobs/frontend https://company.com/about
/fit-check https://wanted.co.kr/wd/123456
```

- 회사 소개 URL은 선택사항 (없으면 채용 공고에서 회사 정보 추출)
- `.claude/skills/fit-check/references/applicant.md`, `.claude/skills/fit-check/references/preference.md` 자동 로드

---

## 워크플로우

### Step 1: URL 파싱

사용자 입력에서 URL 추출:

- 첫 번째 URL → 채용 공고
- 두 번째 URL → 회사 소개 (선택)

URL이 제공되지 않은 경우 사용자에게 입력 요청.

### Step 2: 에이전트 병렬 실행

**반드시 Task 도구를 사용하여 두 에이전트를 병렬로 실행합니다:**

```
Task 1: job-posting-analyzer
- subagent_type: job-posting-analyzer
- prompt: "다음 채용 공고를 분석해주세요: [채용공고URL]"

Task 2: about-analyzer
- subagent_type: about-analyzer
- prompt: "다음 회사 소개를 분석해주세요: [회사소개URL]"
  (URL 없으면: "채용 공고 분석 결과에서 회사 정보를 추출해주세요")
```

두 Task를 **동시에** 호출하여 병렬 처리합니다.

### Step 3: 참조 파일 로드

Read 도구로 다음 파일들을 로드합니다:

1. `.claude/skills/fit-check/references/applicant.md` - 지원자 정보

   - 기술 스택, 경력, 프로젝트, 거주지, 자격증 등

2. `.claude/skills/fit-check/references/preference.md` - 선호 기업 정보
   - 포지션, 도메인, 규모, 연봉, 출퇴근 시간 등

### Step 4: 적합성 분석 수행

수집된 데이터를 바탕으로 분석:

#### 매치율 계산 (가중치)

| 항목           | 가중치 | 설명                      |
| -------------- | ------ | ------------------------- |
| 필수 자격요건  | 30점   | 경력, 학력, 필수 기술     |
| 기술 스택 일치 | 25점   | 기술 스택 매칭 비율       |
| 우대 사항 충족 | 20점   | 우대 조건 충족 비율       |
| 문화 적합성    | 15점   | 팀 분위기, 업무 방식 매칭 |
| 기타 조건      | 10점   | 위치, 연봉 등 (선호 조건) |

```
매치율 = (충족 항목 가중치 합 / 전체 항목 가중치 합) × 100
```

#### 분석 항목

1. **잘 맞는 점 (Strengths)**

   - 요구사항과 지원자 역량이 일치하는 항목
   - 각 항목별 적합도 등급 (5단계)

2. **맞지 않는 점 (Gaps)**

   - 필수 요건 불충족: critical (빨간색)
   - 선호 조건 불일치: prefer (노란색)
   - 우대 사항 미충족: prefer (노란색)
   - 확인 필요: prefer (회색)

3. **보완 포인트 (Improvements)**
   - 중요도: 높음/중간/낮음
   - 충족도: 미충족/부분 충족/확인 필요
   - 근거 및 제안

### Step 5: HTML 결과물 생성

**반드시 result-design 스킬을 호출하여 HTML을 생성합니다:**

```
Skill 도구 호출:
- skill: "result-design"
- args: 분석 결과 데이터 (매치율, 강점, 갭, 보완 포인트 등)
```

result-design 스킬이 다음을 처리합니다:

- Glassmorphism 스타일 적용
- Pretendard 폰트 및 lucide 아이콘
- 5단계 적합도 배지 시스템
- 도넛 차트, 테이블, 카드 그리드 레이아웃

**직접 HTML/CSS를 작성하지 마세요. 반드시 result-design 스킬을 사용하세요.**

### Step 6: 파일 저장

결과물을 `output/` 디렉토리에 저장:

```
output/fit-result-[회사명]-YYYY-MM-DD.html
```

- 회사명: 한글/영문 모두 가능
- 날짜: 오늘 날짜 (YYYY-MM-DD 형식)

---

## 출력 형식 옵션

기본 출력은 HTML입니다. 사용자가 다른 형식을 요청할 경우:

| 형식            | 처리 방법           |
| --------------- | ------------------- |
| **HTML** (기본) | 직접 생성           |
| **PPTX**        | make-pptx 스킬 호출 |
| **Markdown**    | .md 파일로 저장     |

---

## 주의사항

1. **에이전트 병렬 실행 필수**: 성능을 위해 두 에이전트를 동시에 실행
2. **참조 파일 자동 로드**: applicant.md, preference.md는 항상 로드
3. **result-design 스킬 필수 사용**: HTML 생성 시 반드시 `Skill` 도구로 result-design 호출 (직접 CSS 작성 금지)
4. **선호 vs 필수 구분**: preference.md는 참고용, 큰 감점 없음

---

## 에러 처리

| 상황                    | 처리                         |
| ----------------------- | ---------------------------- |
| 채용 공고 URL 접근 불가 | WebSearch로 대체 검색        |
| 회사 소개 URL 없음      | 채용 공고에서 회사 정보 추출 |
| 참조 파일 없음          | 사용자에게 파일 생성 요청    |
