---
name: fixing-srt-subtitles
description: SRT字幕ファイル専用の文字起こし修正スキル。Whisper等で生成されたSRTファイルの誤変換・不自然な改行位置を自動修正。Use PROACTIVELY when editing .srt files, fixing subtitle transcriptions, correcting SRT timing text, or when user mentions 字幕, SRT, 文字起こし修正, subtitle. fixing-transcriptionsスキルと連携して誤変換を修正。
---

# SRT Transcription Fixer（SRT字幕修正スキル）

SRT形式の字幕ファイルに特化した文字起こし修正スキルです。

## 概要

Whisper等の音声認識で生成されたSRTファイルには、以下の問題が発生しやすい：

1. **誤変換** - 専門用語の誤認識（fixing-transcriptionsで対応）
2. **不自然な改行位置** - 単語や助詞が行をまたいで分割される

このスキルは特に **2. 不自然な改行位置** の修正に特化しています。

## 使い方

### 基本的な使用

```
このSRTファイルの誤変換と改行位置を修正してください：
@path/to/subtitle.srt
```

### fixing-transcriptionsとの連携

1. まず `fixing-transcriptions` スキルで誤変換を修正
2. 次に本スキルで改行位置を最適化

## SRT形式の構造

```srt
1
00:00:00,240 --> 00:00:02,380
字幕テキスト1行目

2
00:00:02,760 --> 00:00:05,060
字幕テキスト2行目
```

- **番号行**: 字幕の連番
- **タイムコード行**: 開始時間 --> 終了時間
- **テキスト行**: 表示される字幕テキスト
- **空行**: 各字幕ブロックの区切り

## 重要：タイムコードと区切り位置の扱い

### 原則

1. **タイムコード・字幕番号は変更しない** - 字幕の統合・分割は行わない
2. **テキストの区切り位置は調整してよい** - 数文字程度なら前後の字幕間で移動OK
3. **最重要：1行ごとの字幕が自然に完結すること** - 単語・専門用語が分断されないこと

### やるべきこと
- テキストの誤変換を修正する
- **単語の区切り位置を自然な位置に調整する**（前後の字幕間でテキストを移動）
- **行末の句読点（、。）を削除する**（字幕では不要）

### やってはいけないこと
- 複数の字幕を1つに統合してタイムコードを変更する
- 字幕番号を減らす（152→76などの大幅な統合）

### 長文字幕分割時のみ許可
- 24文字超の字幕を分割する場合に限り、字幕ブロックの追加は許可
- 分割時はタイムコードを文字数比で按分
- 全ての字幕が24文字以下になるまで反復分割する

## 字幕分断への対応

Whisperは音声の区切りで自動分割するため、単語の途中で字幕が分かれることがある。
**タイムコードは維持しつつ、テキストの区切り位置を調整して自然な単語区切りにする。**

### 修正すべき分断パターン

```srt
# Before - 「ファイル」が不自然に分断
2
00:00:02,760 --> 00:00:05,920
Claude CodeではCLAUDE.mdというファイ

3
00:00:05,920 --> 00:00:09,960
ルに開発の共通のルールを設定することができます。

# After - 区切り位置を調整（タイムコードはそのまま）
2
00:00:02,760 --> 00:00:05,920
Claude CodeではCLAUDE.mdという

3
00:00:05,920 --> 00:00:09,960
ファイルに開発の共通のルールを設定することができます。
```

### 誤変換も同時に修正

```srt
# Before - 誤変換+不自然な分断
2
00:00:02,760 --> 00:00:05,920
クロードコードではcloud.mdというファイ

# After - 誤変換修正+区切り位置調整
2
00:00:02,760 --> 00:00:05,920
Claude CodeではCLAUDE.mdという
```

## 改行位置の修正ルール

### 絶対に区切ってはいけないパターン

#### 1. 複合語・固有名詞

| NG | OK |
|----|-----|
| `フロントエ` + `ンド` | `フロントエンド` |
| `バックエ` + `ンド` | `バックエンド` |
| `タイプスクリ` + `プト` | `TypeScript` |
| `クロードコ` + `ード` | `Claude Code` |
| `Claude Co` + `de` | `Claude Code` |
| `コンテキ` + `スト` | `コンテキスト` |
| `コンポーネ` + `ント` | `コンポーネント` |

#### 2. 動詞・形容詞の活用形

| NG | OK |
|----|-----|
| `読み込` + `まれている` | `読み込まれている` |
| `混在さ` + `せることも` | `混在させることも` |
| `実装して` + `いる時にも` | `実装している時にも` |
| `適用さ` + `れた` | `適用された` |
| `応じ` + `て` | `応じて` |

#### 3. ファイル名・拡張子・パス

| NG | OK |
|----|-----|
| `CLAUDE.m` + `d` | `CLAUDE.md` |
| `typescript.` + `md` | `typescript.md` |
| `general.` + `md` | `general.md` |
| `index.` + `ts` | `index.ts` |
| `pa` + `ths` | `paths` |

#### 4. スラッシュコマンド

| NG | OK |
|----|-----|
| `/me` + `mory` | `/memory` |
| `/con` + `text` | `/context` |
| `スラッシュコンテ` + `キスト` | `/context` |
| `スラッシュメモリー` | `/memory` |

#### 5. 助詞の分断・不自然な区切り

| NG | OK |
|----|-----|
| `APIの開` + `発ルール` | `APIの` + `開発ルール` |
| `フロントエンドの実装して` + `いる時` | `フロントエンドの` + `実装している時` |
| `ど` + `んどん` | `どんどん` |
| `AP` + `I` | `API` |
| `ルールと` + `して` | `ルール` + `として` |
| `必要に` + `応じ` + `て` | `必要に` + `応じて` |

#### 6. 助詞が行頭に来るパターン（重要）

**助詞（の、が、を、に、で、は、と、も、へ、や）が行頭に来るのは絶対NG。**
前の行末に含めるか、区切り位置を調整して回避する。

| NG | OK |
|----|-----|
| `5倍程度トークン` + `の消費量が` | `5倍程度` + `トークンの消費量が` |
| `コマンドを使いますとタスク` + `の途中でも` | `コマンドを使いますと` + `タスクの途中でも` |
| `計画を立てたい` + `時なんかには` | `もしくは` + `計画を立てたい時なんかには` |
| `Claude Proプランのようなトークン` + `消費量を` | `Claude Proプランのような` + `トークン消費量を` |
| `これはデフォルトですので特にこのモデル` + `の設定が` | `これはデフォルトですので特にこの` + `モデルの設定が` |

#### 7. 接続助詞が行頭に残るパターン

接続助詞（ので、から、けど、が、て等）だけが次の行の頭に残るのはNG。前の行に含める。

| NG | OK |
|----|-----|
| `指定していない` + `ので、これは〜` | `指定していないので、` + `これは〜` |
| `思うんですけれども` + `、厄介なことに` | `思うんですけれども、` + `厄介なことに` |
| `できるんですが` + `、例えば〜` | `できるんですが、` + `例えば〜` |
| `なってきますけれども` + `、フロント〜` | `なってきますけれども、` + `フロント〜` |

### 推奨される区切り位置

1. **助詞の後** - 「は」「が」「を」「に」「で」「と」「や」「の」
2. **句読点の後** - 「、」「。」
3. **接続詞の前** - 「そして」「また」「さらに」「つまり」
4. **文節の切れ目** - 意味のまとまりを保つ

### 修正例

**Before:**
```srt
16
00:00:35,880 --> 00:00:38,520
この中にはフロントエンドのルールやバ

17
00:00:38,520 --> 00:00:40,700
ックエンドのルールなどいろいろと混在さ

18
00:00:40,700 --> 00:00:42,400
せることもあるかと思うんですけれども
```

**After:**
```srt
16
00:00:35,880 --> 00:00:38,520
この中にはフロントエンドのルールや

17
00:00:38,520 --> 00:00:40,700
バックエンドのルールなどいろいろと

18
00:00:40,700 --> 00:00:42,400
混在させることもあるかと思うんですけれども
```

## チェックリスト

修正時に確認すべき項目：

### 誤変換チェック（fixing-transcriptionsと連携）
- [ ] Claude Code関連用語（CLAUDE.md, /context, /memory, /model等）
- [ ] プログラミング用語（TypeScript, API, フロントエンド等）
- [ ] 固有名詞（とまだ ※ひらがな、Claude, Opus, Sonnet, Haiku等）
- [ ] モデル名（Opus, Sonnet, Haiku ※英語表記）

### 改行位置チェック
- [ ] 複合語が分断されていないか
- [ ] 動詞の活用形が分断されていないか
- [ ] ファイル名・拡張子が分断されていないか
- [ ] **助詞（の、が、を、に、で、は、と、も）が行頭に来ていないか** ← 重要
- [ ] 接続助詞（ので、から、けど）が行頭に来ていないか

## AI Assistant Instructions

このスキルが起動されたら：

### 修正手順

1. **ファイル読み込み**
   - SRTファイルを読み込む
   - 全体の構造を把握

2. **誤変換修正（fixing-transcriptionsと連携）**
   - Claude Code関連用語を正しい表記に
   - プログラミング用語を統一
   - 固有名詞を正確に

3. **改行位置最適化**
   - 単語の途中で区切られている箇所を特定
   - 助詞・句読点の位置を確認
   - 文節単位で自然な区切りに調整

4. **確認**
   - 全体を通して読み、不自然な箇所がないか確認

### 重要な注意点

- **タイムコードは変更しない** - テキストのみ修正（長文分割時は按分）
- **番号は変更しない** - 字幕の連番はそのまま（分割後は再採番）
- **空行は保持** - SRT形式の構造を維持
- **1行あたり24文字以内は必須** - 24文字超は絶対に許容しない（ゼロ許容ルール）
- **文字数バランス** - 極端に長い/短い行を避ける

### 修正パターンの優先順位

1. 固有名詞・ファイル名の分断 → 最優先で修正
2. 動詞活用形の分断 → 必ず修正
3. 助詞の位置 → 文末に移動
4. 句読点の追加 → 自然な位置に補完

## スクリプト

### 行末句読点の一括削除

`scripts/remove_trailing_punctuation.py` - SRTファイル全体の行末句読点を一括削除

```bash
python scripts/remove_trailing_punctuation.py input.srt [output.srt]
```

- `output.srt`を省略すると`input.srt`を上書き
- 削除対象: 行末の「、」「。」
- 修正箇所を表示して確認可能

### 長文字幕の検出

`scripts/detect_long_subtitles.py` - 指定文字数を超える字幕を検出してJSON出力

```bash
python scripts/detect_long_subtitles.py input.srt --max-chars 24
```

- 24文字超の字幕を検出（デフォルト）
- JSON形式で番号・タイムコード・テキスト・文字数を出力
- 長文字幕分割ワークフローの第1ステップとして使用

### タイムコード異常の検出・修正

`scripts/validate_timecodes.py` - タイムコードの異常を検出・自動修正

```bash
# 検証のみ（ドライラン）
python scripts/validate_timecodes.py input.srt --check

# 検証＋自動修正（デフォルトは上書き）
python scripts/validate_timecodes.py input.srt

# 別ファイルに出力
python scripts/validate_timecodes.py input.srt --output output.srt
```

**検出・修正するパターン:**
1. **分フィールド異常（同一分内）**: `00:02:38,714 --> 00:00:40,190` → `00:02:38,714 --> 00:02:40,190`
   - 終了時間の分が開始時間より小さい（Whisperの分キャリー失敗）
2. **分フィールド異常（分境界またぎ）**: `00:05:58,500 --> 00:04:02,300` → `00:05:58,500 --> 00:06:02,300`
   - 分境界をまたぐ際に分が正しく更新されていない

**出力例:**
```json
{
  "file": "input.srt",
  "total": 155,
  "valid": false,
  "fixed": true,
  "fixed_count": 2,
  "error_count": 2,
  "errors": [
    {
      "type": "minute_field_error",
      "number": 83,
      "start": "00:02:38,714",
      "end_before": "00:00:40,190",
      "end_after": "00:02:40,190",
      "message": "分フィールドを00→02に修正しました"
    }
  ]
}
```

**使用タイミング:**
- SRTファイル修正後の最終チェックとして実行
- 長文字幕分割後のタイムコード検証

## 長文字幕分割ワークフロー

24文字を超える長い字幕を自然な位置で分割する3段階のワークフロー。

### 処理フロー（反復処理）

全ての字幕が24文字以下になるまで反復分割する（最大5回）。
**最終ステップでタイムコード検証を実行。**

```
iteration = 1
┌─────────────────────────────────────────┐
│ 1. 検出（detect_long_subtitles.py）      │
│    ↓                                     │
│ 2. 長文字幕あり?                          │
│    ├─ NO → Step 6へ                      │
│    └─ YES ↓                              │
│ 3. 提案（srt-splitterサブエージェント）   │
│    ↓                                     │
│ 4. 修正（メインエージェント）             │
│    - タイムコード按分                     │
│    - 字幕番号再採番                       │
│    ↓                                     │
│ 5. iteration++ (max 5回)                 │
│    ↓                                     │
│ 1に戻る                                  │
└─────────────────────────────────────────┘
      ↓
┌─────────────────────────────────────────┐
│ 6. タイムコード検証                       │
│    （validate_timecodes.py）              │
│    - 分フィールド異常を検出・修正          │
│    - 時系列逆転エラーを報告               │
│    ↓                                     │
│ 7. 完了                                   │
└─────────────────────────────────────────┘
```

### Step 1: 検出

```bash
python ~/.claude/skills/fixing-srt-subtitles/scripts/detect_long_subtitles.py input.srt --max-chars 24
```

出力例:
```json
{
  "total": 155,
  "max_chars": 24,
  "count": 25,
  "long_subtitles": [
    {
      "number": 130,
      "start": "00:10:56,000",
      "end": "00:11:01,000",
      "text": "そちらに書いてある指示というのは確率論的に読み込まれて指示として解釈されます",
      "length": 38
    }
  ]
}
```

### Step 2: 分割提案

Taskツールで`srt-splitter`サブエージェントを呼び出し、検出された長文字幕の分割を提案させる。

サブエージェントは国語的観点で分割位置を判断:
- 助詞（の、が、を、に、で、は、と、も）から始めない
- 単語を途中で切らない
- 意味のまとまりを保つ

### Step 3: 修正

メインエージェントがサブエージェントの提案をもとに:
1. SRTファイルを修正
2. タイムコードを文字数比で按分
3. 字幕番号を再採番

**タイムコード按分の計算:**
```
例: 00:10:56,000 --> 00:11:01,000 (5秒)
    17文字 + 11文字 + 11文字 = 39文字

    1つ目: 17/39 × 5秒 = 2.18秒 → 00:10:56,000 --> 00:10:58,179
    2つ目: 11/39 × 5秒 = 1.41秒 → 00:10:58,179 --> 00:10:59,589
    3つ目: 11/39 × 5秒 = 1.41秒 → 00:10:59,589 --> 00:11:01,000
```

## 連携スキル

- **fixing-transcriptions** - 誤変換修正の辞書・ルールを参照
- **tomada-writing** - 日本語表現のスタイルガイド参照

## 関連カスタムコマンド

- `/fixing-srt-subtitles:fix-srt` - SRTファイルの誤変換・改行位置を修正（参照ファイル対応）
- `/fixing-srt-subtitles:split-long-subtitles` - 長文字幕の検出・分割に特化

## 絶対ルール（ゼロ許容）

### 24文字超は絶対に許容しない

**重要**: 24文字を超える字幕は1つも残してはいけない。

- 検出された全ての長文字幕を分割する
- 分割後も24文字超が残る場合は反復分割する（最大5回）
- 最終的に24文字超が1つでも残っている場合はエラーとして報告

### 完了条件

```
✅ 完了: 全ての字幕が24文字以下
❌ エラー: 24文字超の字幕が残存（手動確認を促す）
```

### 反復分割の例

```
1回目: 126個 → 2個（分割で解消されない長文）
2回目: 2個 → 0個
完了: 全て24文字以下
```

## Version

**Current Version:** 1.8.0

### 更新履歴

- **1.8.0** (2026-01-06): タイムコード検証・修正機能を追加
  - `scripts/validate_timecodes.py` スクリプトを追加
  - 分フィールド異常（Whisperの分キャリー失敗）を検出・自動修正
  - 分境界をまたぐ異常パターンにも対応
  - ワークフローの最終ステップとしてタイムコード検証を組み込み
- **1.7.0** (2026-01-05): ゼロ許容ルールを明確化
  - **重要な学び**: 24文字超は絶対に許容しない
  - `/srt-transcription-fixer:split-long-subtitles` カスタムコマンドを追加
  - 反復分割フローを追加（全て24文字以下になるまで）
  - 完了条件を明記（24文字超が1つでも残ればエラー）
- **1.6.0** (2026-01-05): 長文字幕分割ワークフローを追加
  - `scripts/detect_long_subtitles.py` 検出スクリプトを追加
  - `srt-splitter` サブエージェントと連携した3段階ワークフロー
  - タイムコード按分による字幕ブロック分割機能
- **1.5.0** (2026-01-02): 助詞行頭NGルールと固有名詞表記を追加
  - **重要な学び**: 助詞（の、が、を、に、で、は、と、も）が行頭に来るのは絶対NG
  - 区切り位置を調整して助詞が行頭に来ないようにする
  - 「とまだ」はひらがな表記（トマダ、戸田等は誤変換）
- **1.4.0** (2025-12-11): 行末句読点削除ルールとスクリプトを追加
  - 字幕の行末に句読点（、。）は不要なため削除するルールを追加
  - `scripts/remove_trailing_punctuation.py` スクリプトを追加（一括削除用）
- **1.3.1** (2025-12-11): 接続助詞の行頭残りパターンを追加
  - 「ので」「から」「けど」等が行頭に残るのはNG、前の行に含めるルールを追加
- **1.3.0** (2025-12-11): テキスト区切り位置の調整方針を明確化
  - **重要な学び**: タイムコードは維持しつつ、テキストの区切り位置は調整してよい
  - 最重要原則を明記：「1行ごとの字幕が自然に単語・専門用語として完結すること」
  - 分断NGパターンを大幅追加（`Claude Co`+`de`、`ど`+`んどん`、`/me`+`mory`、`コンテキ`+`スト`等）
  - 修正例を実際の作業経験に基づいて更新
- **1.2.0** (2025-12-11): タイムコード維持の原則を追加
  - タイムコードは変更しない原則を明記
  - 字幕統合は行わず、テキストの誤変換のみ修正する方針に変更
- **1.1.0** (2025-12-11): 実際のSRT修正経験をもとに改善
  - キーワード分断パターンの例を追加
- **1.0.0**: 初版リリース
