# SRT修正パターン リファレンス

## 不自然な区切りパターン一覧

### プログラミング用語

| 誤った区切り | 正しい形 |
|-------------|---------|
| `フロントエ` + `ンド` | フロントエンド |
| `バックエ` + `ンド` | バックエンド |
| `タイプスクリ` + `プト` | TypeScript |
| `コンポーネ` + `ント` | コンポーネント |
| `データベ` + `ース` | データベース |
| `フレームワ` + `ーク` | フレームワーク |
| `インターフェ` + `ース` | インターフェース |
| `アプリケーシ` + `ョン` | アプリケーション |

### Claude Code関連

| 誤った区切り | 正しい形 |
|-------------|---------|
| `クロードコ` + `ード` | Claude Code |
| `CLAUDE.` + `md` | CLAUDE.md |
| `クロード` + `ルール` | Claudeルール |
| `サブエージェ` + `ント` | サブエージェント |
| `コンテキ` + `スト` | コンテキスト |

### 固有名詞（人名・チャンネル名）

| 誤変換 | 正しい表記 |
|-------|---------|
| トマダ | とまだ |
| 戸田 | とまだ |
| 苫田 | とまだ |
| 友田 | とまだ |

**注意**: 「とまだ」はひらがな表記が正式。カタカナや漢字に誤変換されやすい。

### ファイル名・拡張子

| 誤った区切り | 正しい形 |
|-------------|---------|
| `index.` + `ts` | index.ts |
| `general.` + `md` | general.md |
| `typescript.` + `md` | typescript.md |
| `package.` + `json` | package.json |

### 動詞活用形

| 誤った区切り | 正しい形 |
|-------------|---------|
| `読み込` + `まれている` | 読み込まれている |
| `混在さ` + `せることも` | 混在させることも |
| `実装して` + `いる時` | 実装している時 |
| `適用され` + `ていなかった` | 適用されていなかった |
| `分け` + `ていくと` | 分けていくと |

### 助詞・接続詞の分断

| 誤った区切り | 正しい形 |
|-------------|---------|
| `APIの開` + `発ルール` | APIの + 開発ルール |
| `パ` + `スを使って` | パスを使って |
| `フォル` + `ダ分け` | フォルダ分け |
| `メンテナ` + `ンス` | メンテナンス |

### 助詞が行頭に来るパターン（絶対NG）

**助詞（の、が、を、に、で、は、と、も、へ、や）が行頭に来てはいけない。**

| NG（助詞が行頭） | OK（助詞を前行に含める/区切り位置を調整） |
|-----------------|----------------------------------------|
| `5倍程度トークン` + `の消費量` | `5倍程度` + `トークンの消費量` |
| `タスク` + `の途中でも` | `タスクの途中でも` |
| `モデル` + `の設定が` | `モデルの設定が` |
| `Claude Code` + `を使いたい` | `Claude Codeを使いたい` |
| `トークン` + `が大きい` | `トークンが大きい` |

**対処法**: 助詞が行頭に来る場合は、前の行の末尾を短くして助詞を含めるか、区切り位置を調整して回避する。

## 良い区切り位置の例

### 助詞の後で区切る

```
✅ この中にはフロントエンドのルールや
   バックエンドのルールなども

❌ この中にはフロントエンドのルールやバ
   ックエンドのルールなども
```

### 句読点の後で区切る

```
✅ 状況に応じてルールを分けていくことで、
   コンテキストを効率的に使うことができます。

❌ 状況に応じてルールを分けていくことでコ
   ンテキストを効率的に使うことができます。
```

### 接続詞の前で区切る

```
✅ ルールが読み込まれたかと思うんですけれども、
   今回はすでにルールがコンテキストに

❌ ルールが読み込まれたかと思うんですけれど
   も今回はすでにルールがコンテキストに
```

## スラッシュコマンドの正式名称

| 誤変換 | 正式名称 |
|-------|---------|
| スラッシュコンテキスト | /context |
| スラッシュコンテクスト | /context |
| スラッシュメモリー | /memory |
| スラッシュメモリ | /memory |
| スラッシュコスト | /cost |
| スラッシュヘルプ | /help |
| スラッシュイニット | /init |
| スラッシュクリア | /clear |
| スラモデル | /model |
| スラッシュモデル | /model |

## モデル名の正式表記

| 誤変換 | 正式名称 |
|-------|---------|
| オーパス | Opus |
| OBAS | Opus |
| オパス | Opus |
| ソネット | Sonnet |
| SONET | Sonnet |
| ハイク | Haiku |
| 俳句 | Haiku |
| 配偶 | Haiku |
| 早く | Haiku（文脈による）|

**注意**: モデル名は英語表記（Opus, Sonnet, Haiku）が正式。カタカナや日本語に誤変換されやすい。

## ツール名の正式表記

| 誤変換 | 正式名称 |
|-------|---------|
| リードツール | Readツール |
| ライトツール | Writeツール |
| エディットツール | Editツール |
| グレップツール | Grepツール |
| グロブツール | Globツール |
| バッシュツール | Bashツール |
| タスクツール | Taskツール |

## 数字・単位の表記

| 誤変換 | 正式表記 |
|-------|---------|
| 三つ | 3つ |
| 四つ | 4つ |
| 一つ目 | 1つ目 |
| 二つ目 | 2つ目 |
| 六千 | 6000 |
| 七百 | 700 |
