---
name: flashcards-generator
description: Generate neat, clean flashcards in markdown table format from a topic title or reference file. Use when you need to create study materials, review cards, or learning aids for any subject.
allowed-tools: Read, Write, Glob, WebSearch
---

# Flashcards Generator

Generate clean, well-organized flashcards for studying and learning.

## Instructions

### When Given a Topic Title:

1. Research or use knowledge about the topic to identify key concepts
2. Create 10-15 flashcards covering the most important points
3. Ensure questions are clear and answers are concise
4. Generate a markdown file with a clean table format

### When Given a Reference File:

1. Read the provided file using the Read tool
2. Extract key concepts, definitions, facts, and important points
3. Transform each concept into a question-answer pair
4. Generate flashcards covering the main content

### Output Format:

Always generate flashcards in this clean markdown table format:

```markdown
# Flashcards: [Topic Name]

| # | Front (Question) | Back (Answer) |
|---|------------------|---------------|
| 1 | Question here... | Answer here... |
| 2 | Question here... | Answer here... |
```

### File Naming:

- Save as `flashcards-[topic-name].md` in the current directory
- Use lowercase and hyphens for the topic name (e.g., `flashcards-python-basics.md`)

## Guidelines for Quality Flashcards

1. **One concept per card** - Keep each flashcard focused on a single idea
2. **Clear questions** - Make questions specific and unambiguous
3. **Concise answers** - Keep answers brief but complete
4. **Avoid yes/no questions** - Use "What", "How", "Why", "Define" instead
5. **Include variety** - Mix definitions, concepts, examples, and applications
6. **Progressive difficulty** - Order cards from basic to advanced concepts

## Examples

### Example 1: Topic-based Generation

**User Request:** Generate flashcards on photosynthesis

**Output:** `flashcards-photosynthesis.md`

```markdown
# Flashcards: Photosynthesis

| # | Front (Question) | Back (Answer) |
|---|------------------|---------------|
| 1 | What is photosynthesis? | The process by which plants convert light energy into chemical energy (glucose) using carbon dioxide and water |
| 2 | What is the chemical equation for photosynthesis? | 6CO2 + 6H2O + light energy → C6H12O6 + 6O2 |
| 3 | Where does photosynthesis occur in plant cells? | In the chloroplasts |
| 4 | What pigment captures light energy? | Chlorophyll |
| 5 | What are the two main stages of photosynthesis? | Light-dependent reactions and the Calvin cycle (light-independent reactions) |
```

### Example 2: File-based Generation

**User Request:** Generate flashcards from notes.txt

**Process:**
1. Read the contents of notes.txt
2. Identify key points and concepts
3. Convert each into a Q/A pair
4. Save as `flashcards-notes.md`

## Best Practices

- Generate between 10-20 flashcards for optimal study sessions
- If the topic is broad, focus on foundational concepts first
- For reference files, prioritize definitions, key terms, and main ideas
- Always number the flashcards for easy reference
- Keep the table formatting clean and consistent
