---
name: flatten-section
description: Flatten a documentation section to remove nested directories. Use when you need to simplify a docs section like power/, navigation/, or appliances/ to have a flat structure with equipment pages at the root level.
allowed-tools: Bash(rm:*), Bash(mv:*), Bash(mkdir:*), Bash(ls:*), Bash(find:*), Read, Edit, Write, Glob, Grep
---

# Flatten Documentation Section

Restructure a nested documentation section into a flat structure following these conventions:

## Target Structure

Each section folder should contain:
- `_overview.md` - Section overview with heading "# Overview" (underscore prefix ensures it sorts first in nav)
- `<equipment-name>.md` - Equipment pages with kebab-case names matching the product
- `<equipment-name>-*.pdf` - Associated PDF manuals in same directory
- `<equipment-name>-*.jpg/png` - Associated images in same directory

## Steps

1. **Identify the section** to flatten (e.g., `docs/power/`, `docs/navigation/`)

2. **Delete index.md** if it exists (causes duplicate nav entries)

3. **Rename systems.md to _overview.md** if it exists

4. **Flatten equipment pages**:
   - Move `equipment/<model>.md` → `<model>.md`
   - Move `equipment/<model>/manuals/*.pdf` → keep original PDF names in same directory
   - Move `<subfolder>/<model>.md` → `<model>.md`
   - Rename equipment files to match product name in kebab-case

5. **Update links** in markdown files to reflect new paths (PDFs now in same directory)

6. **Update _overview.md** to provide actual content:
   - Heading must be `# Overview` (not section-specific like "# Power Systems")
   - Brief description of the section
   - Equipment table linking to all equipment pages in the section
   - Summary of each major system with key specs from equipment pages
   - Maintenance schedule table

7. **Cleanup** empty directories

## Overview Template

```markdown
# Overview

Brief description of this section's systems.

## Equipment

| Equipment | Description |
|-----------|-------------|
| [Product Name](product-name.md) | Brief description |

## System Name

Summary with key specs and link to [equipment page](equipment.md).

## Maintenance Schedule

| Task | Frequency |
|------|-----------|
| Task name | Weekly/Monthly/Annually |
```

## Naming Convention

- Equipment markdown: `<manufacturer>-<model>.md` (e.g., `whale-supersub-smart-1100.md`)
- PDF manuals: `<year>-<manufacturer>-<model>-<description>-<lang>.pdf` or descriptive name
- Images: `<equipment-name>-<description>.jpg`

## Example

Before:
```
docs/power/
├── index.md
├── systems.md
├── equipment/
│   ├── battery-monitor.md
│   └── battery-monitor/
│       └── manuals/
│           └── manual.pdf
```

After:
```
docs/power/
├── _overview.md
├── battery-monitor.md
└── battery-monitor-manual.pdf
```
