---
name: follow-up-emails
description: Creates professional follow-up emails after sales calls that capture key points and drive next steps. Use this skill when sending post-call summaries, confirming action items, or maintaining deal momentum between conversations.
---

# Follow-Up Emails

This skill creates professional, well-structured follow-up emails that capture key discussion points, confirm action items, and maintain deal momentum after sales conversations.

## Objective

Transform sales call insights into clear, compelling follow-up emails that reinforce value, confirm next steps, and keep deals moving forward.

## Email Structure

### 1. Personalized Opening
Brief greeting that acknowledges the conversation.

**Good Examples:**
- "Thanks for making time to chat today."
- "Great connecting with you this afternoon."
- "Appreciated the candid conversation earlier."

**Avoid:**
- Generic "Hope this email finds you well"
- Overly effusive thanks
- Restating obvious facts ("As we discussed...")

### 2. Next Steps Section
The most important part-clear action items.

**Format:**
```
## Next Steps

**Your action items:**
- [Action 1] - by [date]
- [Action 2] - by [date]

**My action items:**
- [Action 1] - by [date]
- [Action 2] - by [date]
```

**Guidelines:**
- Lead with their action items (creates accountability)
- Be specific about what and when
- Keep it to 2-4 items total
- Make deadlines clear but reasonable

### 3. Discussion Summary
Organized recap of what was covered.

**Sections to Include:**

**Challenges Discussed:**
- Key pain points they mentioned
- Impact of those challenges
- Urgency or timeline drivers

**Goals Identified:**
- Desired outcomes they expressed
- Success criteria mentioned
- Priority areas

**Solutions Discussed:**
- How your solution addresses their needs
- Features or capabilities most relevant
- Differentiation from alternatives

### 4. Professional Closing
Brief sign-off with clear call to action.

**Good Closings:**
- "Looking forward to our follow-up on [date]."
- "Let me know if anything changes or if you have questions."
- "Happy to chat before then if anything comes up."

## Customization Options

### Tone Settings

**Formal:**
- Full sentences, proper grammar
- Professional language
- Structured format
- Appropriate for executives or first interactions

**Casual:**
- Conversational language
- Contractions allowed
- Lighter touch
- Good for established relationships

**Persuasive:**
- Emphasizes value and urgency
- Stronger calls to action
- More selling language
- Use when deal needs momentum

### Length Settings

**Brief (150-200 words):**
- Next steps only
- One-line summary of discussion
- Best for busy executives or quick check-ins

**Standard (200-350 words):**
- Full structure with all sections
- Balanced detail
- Best for most follow-ups

**Detailed (350-500 words):**
- Comprehensive summary
- Additional context and value
- Best for complex deals or multiple stakeholders

### Emphasis Options

Focus the email on specific areas:
- **Challenges**: Emphasize pain points discussed
- **Solutions**: Highlight how you address their needs
- **Next Steps**: Focus on action and momentum
- **Value**: Reinforce ROI and business impact

## Email Templates by Scenario

### Post-Discovery Call
```
Subject: Follow-up: [Company] Discovery Call

Hi [Name],

Thanks for the great conversation today. I learned a lot about
[key challenge] and how it's impacting [business outcome].

## Next Steps
- [Their action] - by [date]
- [Your action] - by [date]

## Key Takeaways
- [Challenge 1 and its impact]
- [Challenge 2 and its impact]
- [Goal they mentioned]

Based on what you shared, I think [your solution] could help by
[specific benefit]. I'll have [deliverable] ready for our next call.

Talk soon,
[Your name]
```

### Post-Demo Follow-Up
```
Subject: [Company] Demo Follow-up + Resources

Hi [Name],

Great walking through [product] with you and [other attendees] today.

## What We Covered
- [Feature 1] and how it addresses [their need]
- [Feature 2] and the impact on [their goal]
- [Feature 3] for [specific use case]

## Next Steps
- [Their action] - by [date]
- [Your action] - by [date]

## Resources
- [Link to recording/deck/materials]
- [Link to relevant case study]

Let me know if questions come up as you think things through.

Best,
[Your name]
```

### Proposal Follow-Up
```
Subject: [Company] Proposal + Next Steps

Hi [Name],

As promised, attached is the proposal we discussed. Here's a quick summary:

## Investment
- [Pricing summary]
- [Payment terms if relevant]

## Timeline
- [Implementation timeline]
- [Key milestones]

## Next Steps
- [Their action] - Review and share feedback by [date]
- [Your action] - [Any follow-up you're doing]

Happy to walk through any questions-just let me know.

Best,
[Your name]
```

## Quality Guidelines

### Make It Scannable
- Use headers and bullet points
- Bold key information
- Keep paragraphs short
- Front-load important content

### Be Accurate
- Capture what was actually discussed
- Use their language and terminology
- Double-check names and details
- Don't embellish or oversell

### Create Accountability
- Be specific about who does what
- Include concrete dates
- Make next steps clear
- Set expectations appropriately

### Add Value
- Include relevant resources
- Anticipate questions
- Provide helpful context
- Make their job easier

## Output Format

When creating a follow-up email, produce:

1. **Subject Line**: Clear, specific subject
2. **Full Email**: Properly formatted with all sections
3. **Personalization Notes**: What was customized and why
4. **Suggested Attachments**: What to include with the email
5. **Send Timing**: When to send for best response

## Cross-References

- Use `call-analysis` output as input for email content
- Apply `powerful-framework` insights for targeted messaging
- Feed into `multithread-outreach` for stakeholder variants
- Reference `prospect-research` for personalization
