---
name: fpf-skill:design-audit-name
description: Generated skill for design/audit-name.
version: 0.1.0
allowed_tools: []
---

# design/audit-name Kernel

## Instructions
## Instructions
This skill provides a procedure to audit an existing name against FPF naming standards.

### Step 1: Extract Name Card Data
Locate the Name Card or implicit definition for the artifact. Identify:
- **Twin Labels**
- **MDS** (Minimal Definitional Statement)
- **Original Context of Meaning**

### Step 2: Verify Provenance (S4)
- Can you trace the name back to an FPF pattern?
- Does the name imply a "Bridge" where none exists? (Alignment Note check).

### Step 3: Re-Run P2 Matrix
Assess the name against the 7 Sense-Seeds (S1-S7) in the *current* context.
- **S1 Add**: Does adding items still make sense?
- **S2 Retrieve**: Is retrieval still clear?
- **S3 Teach**: Is it teachable?
- **S4 Provenance**: Is origin clear?
- **S5 Relations**: Do links hold?
- **S6 Rep-Change**: If format changed, does name break?
- **S7 Non-Native**: Does it allow non-FPF content if originally intended?

### Step 4: Check for Drift
- **Too Wide (TW)?** Has the artifact grown beyond its name?
- **Too Narrow (TN)?** Is the name stricter than the usage?
- **Wrong Prototype (WP)?** Does the name suggest a different kind of object?

### Step 5: Verdict
Output one of:
- **PASS**: Name is healthy.
- **WARN**: Minor drift; update MDS or consider rename.
- **FAIL**: Breaking change or confusion; Trigger `design/deprecate-name` and `design/mint-name`.
