---
name: fpf-skill:design-mint-name
description: Generated skill for design/mint-name.
version: 0.1.0
allowed_tools: []
---

# design/mint-name Kernel

## Context
This skill enacts the **F.18 Name Card** process from the First Principles Framework (FPF). It is used to "mint" new names for concepts, artifacts, or repositories ensuring high semantic fidelity and cognitive ergonomics.

## Metadata
- **ID**: `fpf-skill:design-mint-name`
- **Pattern Ref**: F.18 (Name Card)
- **Role**: `Namer`
- **Version**: 0.1.0

## Instructions

### Step 1: Define the Context
1. **Identify the Bounded Context**: Where does this name live? (e.g., "Skill Repo", "Runtime Kernel").
2. **State the Purpose**: What is the strict function of the thing being named?

### Step 2: Generate Candidates
Propose 3-5 candidates. For each, define:
- **Twin Labels**: Technical ID (kebab-case) and Plain English.
- **Minimal Definitional Statement (MDS)**: A strict definition of what the thing IS.

### Step 3: Run P2 Semantic Read-Through
For each candidate, test it against the 7 standard FPF sense-seeds (S1–S7):
- **S1 Add**: "Add a new `<Thing>`..."
- **S2 Retrieve**: "Get a `<Thing>` from..."
- **S3 Teach**: "Teach the concept of `<Thing>`..."
- **S4 Provenance**: "Trace the `<Thing>` back to..."
- **S5 Relations**: "Link `<Thing>` to..."
- **S6 Rep-Change**: "Change format of `<Thing>`..."
- **S7 Non-Native**: "Add a foreign `<Thing>`..."

### Step 4: Tally the Matrix
Mark each test as:
- **TN**: Too Narrow
- **OT**: On Target
- **TW**: Too Wide
- **WP**: Wrong Prototype

### Step 5: Mint the Card
Select the candidate with the highest OT count (and 0 WP). Output the final Name Card in Markdown format.

## F.18 Name Card Template
A minted name card must include:
- **CardMode**: (e.g. MintNew)
- **Row ID**: (e.g. RN.FPF.SKILLREPO.001)
- **Context of Meaning**
- **Kind**
- **Purpose / use-domain**
- **Minimal Definitional Statement (MDS)**
- **Didactic subtitle**
- **Sense reference**
- **Archetypal situations (sense-seeds)**
- **P2 Matrix Tally**
