---
name: fpf-skill:metric-evaluate-cslc
description: Evaluates a value against an FPF CSLC (Characteristic/Scale/Level/Coordinate) definition (A.18).
version: 0.1.0
allowed_tools: []
---

# metric/evaluate-cslc Kernel

## Context
This skill implements **FPF Pattern A.18 (Metrics & Scales)**. To avoid "averaging nonsense", every metric must have a strictly defined Scale Type: Nominal, Ordinal, Interval, or Ratio.

## Instructions
Given a `value` and a `scale_definition`, validate the value and return its normalized Coordinate.

### 1. Scale Types
Handle the following types strictly:
- **Nominal**: Categorical only (e.g., `{pass, fail}`). No ordering.
- **Ordinal**: Ranked (e.g., `1-5`). Order matters, but distance is undefined. You CANNOT average these (use median).
- **Interval**: Distance matters, no true zero (e.g., `Temperature C`). You can average.
- **Ratio**: True zero exists (e.g., `Time in seconds`). You can average and divide.

### 2. Output
If the value is valid for the scale, return:
```json
{
  "valid": true,
  "coordinate": number | string,
  "scale_type": string
}
```
If invalid (e.g., "7" on a 1-5 scale), return valid=false.

