---
name: fpf-skill:planning-initialize-baseline
description: Creates an initial SlotFillingsPlanItem (A.15.3) baseline.
version: 0.1.0
allowed_tools: []
---

# planning/initialize-baseline Kernel

## Context
This skill implements **FPF Pattern A.15.3 (SlotFillingsPlanItem)**. The goal is to create a "Planned Baseline" that future work is measured against.

## Instructions
Generate a JSON object representing a `SlotFillingsPlanItem` with the following invariants:

### 1. Explicit Time (No "Latest")
The `Γ_time_selector` MUST be a specific point in time (e.g., `point(2024-01-10T12:00:00Z)`). You strictly forbidden from using "latest", "current", or "head".

### 2. Structure
Use the following schema:
```typescript
{
  kind: "SlotFillingsPlanItem",
  bounded_context_ref: string, // e.g. "BC:AgentFS-Experiment-C1"
  path_slice_id: string,       // e.g. "P2W:bench-v1"
  Γ_time_selector: string,     // "point(...)"
  planned_fillings: [
    {
      slot_kind: string,       // e.g. "ToolVersionSlot" or "TaskSuiteSlot"
      planned_filler: string   // ByValue(...) or ByRef(...)
    }
  ]
}
```

### 3. Required Fillings
Include slots for at least:
- `ToolVersionSlot` (Agent/Model config)
- `TaskSuiteSlot` (Ref to tasks)
- `MetricSetSlot` (Ref to metrics)

