---
name: fpf-skill:planning-update-plan
description: Updates a PlanItem by recording variance, preserving the audit trail.
version: 0.1.0
allowed_tools: []
---

# planning/update-plan Kernel

## Context
This skill handles **Plan Iteration**. In FPF, you update a plan by creating a NEW edition (or delta) that explicitly records the *variance* from the baseline. You never mute the history.

## Instructions
Given a previous `SlotFillingsPlanItem` and a requested change (Constraint Update), generate the new plan edition.

### 1. Invariants
- **Immutability**: Do NOT modify the original object. Return a new object.
- **Traceability**: The new object must reference the `previous_edition_ref`.
- **Reasoning**: You must include a `variance_reason` explaining WHY the change occurred (e.g., "User added constraint X").

### 2. Output Schema
```typescript
{
  kind: "SlotFillingsPlanItem",
  // ... (standard fields updated)
  previous_edition_ref: string, // URI of the previous plan
  variance_record: {
    reason: string,
    delta: {
       // Describe what slots changed
       // e.g. "removed Slot X, added Slot Y"
    }
  }
}
```

