---
name: fpf-skill:storage-persist-evidence
description: Writes an immutable artifact to the FPF EvidenceGraph (G.6).
version: 0.1.0
allowed_tools: []
---

# storage/persist-evidence Kernel

## Context
This skill implements **FPF Pattern G.6 (EvidenceGraph)**. In the experiment (Conditions C1/C2), files act as the carrier. Evidence must be immutable and addressable.

## Instructions
Write the provided content to the `telemetry/` or `artifacts/` directory.

### 1. Naming Convention (Immutability)
You must generate a filename that guarantees uniqueness/immutability.
- Preferred: `timestamp_sha256.json` (e.g., `20240110-1200_a1b2c3...json`)
- Alternate: `uuid.json`

### 2. Formats
- Content MUST be valid JSON.
- If content is not JSON, wrap it: `{"content_type": "text/plain", "body": "..."}`.

### 3. Output
Return the absolute path of the persisted artifact.

