---
name: Frontend Accessibility
description: Build accessible user interfaces using semantic HTML, proper ARIA attributes, keyboard navigation support, sufficient color contrast, and screen reader compatibility. Use this skill when creating or modifying UI components, forms, navigation elements, modals, or any interactive frontend elements. Use when working with React components, Vue components, Angular templates, or vanilla HTML/JSX files (.tsx, .jsx, .vue, .html). Use when implementing keyboard navigation, focus management, form labels and inputs, image alt text, heading hierarchies, or ARIA roles and properties. Use when ensuring WCAG compliance, testing with screen readers, or creating accessible dynamic content and single-page applications. Use when adding color contrast requirements or visible focus indicators to interactive elements.
---

# Frontend Accessibility

This Skill provides Claude Code with specific guidance on how to adhere to coding standards for web accessibility (a11y) and WCAG compliance.

## When to use this skill

- When creating or modifying UI components and interactive elements
- When working with frontend component files (.tsx, .jsx, .vue, .html, .svelte)
- When implementing semantic HTML structure with proper elements (nav, main, button, header, etc.)
- When adding keyboard navigation and focus management to components
- When creating forms with proper labels, inputs, and error messages
- When adding images and ensuring they have descriptive alt text
- When implementing modals, dialogs, or dynamic content that requires focus management
- When setting up ARIA attributes (aria-label, aria-describedby, role, etc.)
- When ensuring proper color contrast ratios (4.5:1 for text)
- When creating logical heading hierarchies (h1-h6)
- When testing with screen readers or accessibility testing tools
- When building accessible navigation menus and interactive widgets

## Instructions

For details, refer to the information provided in this file:
[frontend accessibility](../../../agent-os/standards/frontend/accessibility.md)
