---
name: Frontend CSS
description: Write and structure CSS using consistent methodology (Tailwind, BEM, CSS Modules, styled-components), maintain design system tokens, minimize custom CSS, and optimize performance. Use this skill when writing or modifying stylesheets, CSS files, or styled components. Use when working with .css, .scss, .sass, .module.css files, Tailwind utility classes, CSS-in-JS libraries (styled-components, emotion, JSS), or component styling. Use when establishing design tokens for colors, spacing, and typography, when avoiding framework style overrides, when implementing CSS purging or tree-shaking for production, or when maintaining consistent styling methodology across the project. Use when working with global styles, component-scoped styles, or utility class systems.
---

# Frontend CSS

This Skill provides Claude Code with specific guidance on how to adhere to coding standards for CSS styling and visual design implementation.

## When to use this skill

- When writing or modifying CSS, SCSS, or Sass stylesheets
- When working with CSS files (.css, .scss, .sass, .module.css)
- When using Tailwind CSS utility classes in components
- When implementing CSS-in-JS with styled-components, emotion, or similar libraries
- When establishing or using design system tokens (colors, spacing, typography)
- When following project CSS methodology (BEM, SMACSS, CSS Modules, utility-first)
- When avoiding or removing framework style overrides
- When minimizing custom CSS by leveraging framework utilities
- When optimizing CSS for production with purging or tree-shaking
- When maintaining consistent styling patterns across components
- When working with global styles, theme configuration, or CSS variables
- When implementing responsive styles or media queries

## Instructions

For details, refer to the information provided in this file:
[frontend CSS](../../../agent-os/standards/frontend/css.md)
