---
name: frontend-design
description: Create distinctive, production-grade frontend interfaces with high design quality. Use this skill when the user asks to build web components, pages, or applications. Generates creative, polished code that avoids generic AI aesthetics.
license: Complete terms in LICENSE.txt
---

This skill guides creation of distinctive, production-grade frontend interfaces that avoid generic "AI slop" aesthetics. Implement real working code with exceptional attention to aesthetic details and creative choices.

The user provides frontend requirements: a component, page, application, or interface to build. They may include context about the purpose, audience, or technical constraints.

## Design Thinking

Before coding, understand the context and commit to a BOLD aesthetic direction:
- **Purpose**: What problem does this interface solve? Who uses it?
- **Tone**: Pick an extreme: brutally minimal, maximalist chaos, retro-futuristic, organic/natural, luxury/refined, playful/toy-like, editorial/magazine, brutalist/raw, art deco/geometric, soft/pastel, industrial/utilitarian, etc. There are so many flavors to choose from. Use these for inspiration but design one that is true to the aesthetic direction.
- **Constraints**: Technical requirements (framework, performance, accessibility).
- **Differentiation**: What makes this UNFORGETTABLE? What's the one thing someone will remember?

**CRITICAL**: Choose a clear conceptual direction and execute it with precision. Bold maximalism and refined minimalism both work - the key is intentionality, not intensity.

Then implement working code (HTML/CSS/JS, React, Vue, etc.) that is:
- Production-grade and functional
- Visually striking and memorable
- Cohesive with a clear aesthetic point-of-view
- Meticulously refined in every detail

## Frontend Aesthetics Guidelines

Focus on:
- **Typography**: Choose fonts that are beautiful, unique, and interesting. Avoid generic fonts like Arial and Inter; opt instead for distinctive choices that elevate the frontend's aesthetics; unexpected, characterful font choices. Pair a distinctive display font with a refined body font.
- **Color & Theme**: Commit to a cohesive aesthetic. Use CSS variables for consistency. Dominant colors with sharp accents outperform timid, evenly-distributed palettes.
- **Motion**: Use animations for effects and micro-interactions. Prioritize CSS-only solutions for HTML. Use Motion library for React when available. Focus on high-impact moments: one well-orchestrated page load with staggered reveals (animation-delay) creates more delight than scattered micro-interactions. Use scroll-triggering and hover states that surprise.
- **Spatial Composition**: Unexpected layouts. Asymmetry. Overlap. Diagonal flow. Grid-breaking elements. Generous negative space OR controlled density.
- **Backgrounds & Visual Details**: Create atmosphere and depth rather than defaulting to solid colors. Add contextual effects and textures that match the overall aesthetic. Apply creative forms like gradient meshes, noise textures, geometric patterns, layered transparencies, dramatic shadows, decorative borders, custom cursors, and grain overlays.

NEVER use generic AI-generated aesthetics like overused font families (Inter, Roboto, Arial, system fonts), cliched color schemes (particularly purple gradients on white backgrounds), predictable layouts and component patterns, and cookie-cutter design that lacks context-specific character.

Interpret creatively and make unexpected choices that feel genuinely designed for the context. No design should be the same. Vary between light and dark themes, different fonts, different aesthetics. NEVER converge on common choices (Space Grotesk, for example) across generations.

**IMPORTANT**: Match implementation complexity to the aesthetic vision. Maximalist designs need elaborate code with extensive animations and effects. Minimalist or refined designs need restraint, precision, and careful attention to spacing, typography, and subtle details. Elegance comes from executing the vision well.

Remember: Claude is capable of extraordinary creative work. Don't hold back, show what can truly be created when thinking outside the box and committing fully to a distinctive vision.

---

## LeadFraud.org Visual Specifications

When working on LeadFraud.org specifically, apply these design tokens based on the approved **"Investigative Broadsheet"** aesthetic:

### Theme
- **Light theme** with warm off-white background (`#FAF9F7`)
- Premium editorial feel inspired by investigative journalism (Hindenburg Research, ProPublica)
- "Investigative Broadsheet" aesthetic: bold, distinctive, meticulous
- Ink blob decorations, paper textures, asymmetric layouts
- Floating animations and entrance effects

### Color System

| Token | Hex | Usage |
|-------|-----|-------|
| `paper` | `#FAF9F7` | Page background |
| `surface` | `#FFFFFF` | Cards, modals |
| `ink` | `#1A1A1A` | Primary text, headlines |
| `ink-light` | `#3D3D3D` | Body text |
| `muted` | `#6B6B6B` | Captions, meta |
| `border` | `#E8E4DF` | Dividers, borders |
| `cardinal` | `#F97316` | **Primary accent (Vibrant Orange)** - CTAs, highlights, key text |
| `cardinal-dark` | `#EA580C` | Hover states for primary accent |
| `gold` | `#C2410C` | Secondary accent |
| `evidence` | `#0D9488` | Evidence callouts, verified badges |

### Typography

| Element | Font | Weight | Usage |
|---------|------|--------|-------|
| Display/Headlines | **Playfair Display** | 400-600 | Hero text, section headers, dramatic headlines |
| Body | **Nunito** | 400/600 | Paragraphs, UI text, navigation |
| Monospace | **IBM Plex Mono** | 400 | Data, evidence, timestamps, sources |

Load fonts via Google Fonts:
```html
<link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Mono:wght@400;500&family=Nunito:wght@400;600;700&family=Playfair+Display:ital,wght@0,400;0,600;1,400&display=swap" rel="stylesheet">
```

### Signature Design Elements

1. **Ink Blob Decorations**: Organic shapes with `border-radius: 60% 40% 70% 30%`, subtle opacity, floating animation
2. **Paper Cards**: White cards with soft shadows, hover lift effect, orange border glow on hover
3. **Pull Quotes**: Rotated (`rotate(-1deg)`), large decorative quotation marks, grid-breaking margins
4. **Drop Caps**: Serif display font, oversized first letter in cardinal color
5. **Evidence Callouts**: Left border accent, "EVIDENCE" label badge
6. **Redaction Bars**: Black bars that reveal text on hover

### Animation System

| Animation | Effect | Usage |
|-----------|--------|-------|
| `fadeUp` | Opacity 0→1, translateY(40px)→0 | Hero content, section entrances |
| `float` | Gentle vertical bob | Ink blob decorations |
| `pulse` | Subtle opacity pulse | Giant statistics |
| `scaleIn` | Scale 0.9→1 with fade | Success states |
| `lift` | translateY(-8px) + shadow glow | Card hover effects |

Use staggered delays (`delay-100` through `delay-600`) for cascading entrance effects.

### Button Styles

- **Primary CTA**: Orange background (`bg-cardinal`), white text, lifts on hover with orange glow
- **Secondary CTA**: Transparent with ink border, fills to ink on hover

### Component Classes (CSS)

```css
.paper-card      /* Cards with shadow and hover lift */
.btn-primary     /* Orange CTA buttons */
.btn-secondary   /* Outlined buttons */
.pull-quote      /* Rotated blockquotes */
.evidence-callout /* Blue-bordered evidence blocks */
.stat-giant      /* Large pulsing statistics */
.drop-cap        /* First letter styling */
.nav-link        /* Animated underline links */
```

### Key Visual: The Pipeline Fog Funnel

Create an iconic visual showing:
- Marketing funnel at top
- "Leads" entering funnel as dots
- **Fog/mist effect** obscuring the middle (CSS animation)
- Few real prospects emerging at bottom
- Tagline: "What's really in your pipeline?"

### Design Principles

1. **Asymmetry over symmetry** - Offset layouts, grid-breaking elements
2. **Editorial density** - Rich with information, but meticulously composed
3. **Warm paper aesthetic** - Cream backgrounds, subtle textures
4. **Investigative authority** - Bold headlines, evidence-focused
5. **Vibrant orange accents** - Draws attention without being aggressive