---
name: Frontend Responsive
description: Implement mobile-first responsive layouts using fluid containers, media queries, standard breakpoints, relative units (rem/em), and touch-friendly design patterns. Use this skill when creating layouts that adapt across mobile, tablet, and desktop screens. Use when writing media queries or breakpoint-specific styles, implementing fluid grid systems, designing touch targets for mobile devices, or optimizing images and assets for different screen sizes. Use when working with responsive CSS frameworks (Tailwind responsive utilities, Bootstrap grid, CSS Grid, Flexbox), when testing layouts across multiple viewports, or when ensuring readable typography and content priority on smaller screens. Use when implementing mobile navigation patterns or adaptive UI components.
---

# Frontend Responsive

This Skill provides Claude Code with specific guidance on how to adhere to coding standards for responsive web design and mobile-first development.

## When to use this skill

- When creating or modifying layouts that need to work across different screen sizes
- When writing media queries or breakpoint-specific styles (@media queries, Tailwind sm:/md:/lg: prefixes)
- When implementing mobile-first development starting with mobile layouts
- When using fluid layouts with percentage-based widths or flexible containers
- When choosing between fixed pixels and relative units (rem, em, %, vw, vh)
- When testing UI across mobile, tablet, and desktop screen sizes
- When designing touch-friendly interfaces with appropriate tap target sizes (44x44px minimum)
- When optimizing images and assets for mobile network conditions
- When ensuring readable typography without requiring zoom on mobile
- When prioritizing content display on smaller screens
- When implementing responsive navigation patterns (hamburger menus, drawer navigation)
- When using responsive frameworks (Tailwind, Bootstrap grid, CSS Grid, Flexbox)

## Instructions

For details, refer to the information provided in this file:
[frontend responsive](../../../agent-os/standards/frontend/responsive.md)
