# Fun Advisor

Multidisciplinary council of experts focused on creating genuinely fun game experiences.

## Expertise

This skill assembles a virtual council covering:

- **Behavioral Psychology**: Player motivation, reward loops, habit formation
- **Game Theory**: Strategic depth, decision-making, emergent gameplay
- **Neuroscience of Play**: Dopamine systems, flow states, engagement
- **Player Motivation Research**: Bartle types, self-determination theory
- **Age-Appropriate Design**: Accessibility across demographics
- **Cultural Considerations**: Global appeal, localization of fun
- **Game Feel**: Juice, feedback, responsiveness
- **Systems Thinking**: Interconnected mechanics, emergent fun
- **Narrative Integration**: Story-gameplay harmony
- **Audio Design**: Sound's role in enjoyment
- **UX of Delight**: Micro-interactions, polish
- **Ethical Engagement**: Fun without manipulation

## When to Use

Invoke this skill when you need to:

- Evaluate if a feature will be fun
- Understand player motivations
- Design for engagement without addiction
- Validate game direction
- Ensure components create a satisfying whole
- Answer "will players enjoy this?"

## The Fun Framework

### Core Fun Pillars

```
┌─────────────────────────────────────────┐
│              PLAYER FUN                 │
├─────────────┬─────────────┬─────────────┤
│   AGENCY    │   MASTERY   │   PURPOSE   │
│  "I decide" │ "I improve" │ "It matters"│
├─────────────┼─────────────┼─────────────┤
│  DISCOVERY  │   SOCIAL    │  EXPRESSION │
│ "I explore" │"I connect"  │  "I create" │
└─────────────┴─────────────┴─────────────┘
```

### Fun Killers to Avoid

| Anti-Pattern | Why It Hurts Fun |
|--------------|------------------|
| Wait timers | Removes agency |
| Pay-to-win | Invalidates mastery |
| Unclear goals | No sense of purpose |
| Repetitive grind | Discovery dies |
| Forced social | Pressure, not connection |
| No customization | Can't express self |

## Evaluation Questions

When reviewing a feature, consider:

1. **Immediate**: Is the core loop satisfying second-to-second?
2. **Short-term**: Does a 15-minute session feel complete?
3. **Long-term**: Is there meaningful progression over weeks?
4. **Social**: Can players share experiences?
5. **Personal**: Can players make it "theirs"?

## Fun Metrics

| Metric | What It Indicates |
|--------|-------------------|
| Session length | Engagement depth |
| Return rate | Long-term fun |
| Feature usage | What's actually fun |
| Rage quits | Frustration points |
| Social shares | Delight moments |

## Integration

This skill works alongside:

- `game-concept-advisor` - Ideas that are fun
- `casino-math-balancer` - Math that doesn't ruin fun
- `testing-team` - Playtesting for fun validation

## Usage in Claude Code

```
/fun-advisor

"Is this meta-pot mechanic fun or just addictive?"
"How do I make farming feel rewarding?"
"Will players enjoy this progression system?"
```
