# Player Profiles

## Player Type Taxonomies

### Bartle's Player Types (Classic)

```
                    ACTING ON
                        ▲
                        │
           KILLERS      │      ACHIEVERS
           (Impose)     │      (Achieve)
                        │
   PLAYERS ◄────────────┼────────────► WORLD
                        │
           SOCIALIZERS  │      EXPLORERS
           (Interact)   │      (Discover)
                        │
                        ▼
                   INTERACTING WITH
```

| Type | Motivation | Fun From | % of Players |
|------|------------|----------|--------------|
| Achievers | Points, status | Accumulation, completion | 10% |
| Explorers | Discovery | Finding secrets, understanding systems | 10% |
| Socializers | Relationships | Interaction, community | 80% |
| Killers | Domination | Competition, power over others | <1% |

### Quantic Foundry Model (Research-Based)

More nuanced 12-motivation model:

```
┌───────────────────────────────────────────────────────────────┐
│ ACTION                │ SOCIAL               │ MASTERY        │
│ • Destruction         │ • Competition        │ • Challenge    │
│ • Excitement          │ • Community          │ • Strategy     │
├───────────────────────┼──────────────────────┼────────────────┤
│ ACHIEVEMENT           │ IMMERSION            │ CREATIVITY     │
│ • Completion          │ • Fantasy            │ • Design       │
│ • Power               │ • Story              │ • Discovery    │
└───────────────────────┴──────────────────────┴────────────────┘
```

### The Farming in Purria Player Cluster

Based on game characteristics, likely player motivations:

```
PRIMARY MOTIVATIONS (Strong fit):
┌─────────────────────────────────────────────────────────────────┐
│ Strategy    ████████████████████████ 85%  │ Core loop is         │
│ Completion  ██████████████████████   80%  │ strategic betting    │
│ Fantasy     █████████████████████    75%  │ and collection       │
│ Design      ████████████████         60%  │                      │
└─────────────────────────────────────────────────────────────────┘

SECONDARY MOTIVATIONS (Moderate fit):
┌─────────────────────────────────────────────────────────────────┐
│ Challenge   ██████████████           55%  │ Present but          │
│ Discovery   █████████████            50%  │ not dominant         │
│ Community   ████████                 30%  │                      │
│ Competition ████████                 30%  │                      │
└─────────────────────────────────────────────────────────────────┘
```

## Age-Based Design

### Generation Profiles

#### Gen Z (18-26)

```
CHARACTERISTICS:
• Digital natives
• Short attention spans (or efficient filtering)
• Value authenticity
• Socially conscious
• FOMO-aware (resistant to obvious manipulation)

PLAY PATTERNS:
• Sessions: 5-20 minutes, frequent
• Platform: Mobile-first
• Social: Sharing moments, memes
• Spending: Cosmetic > power

DESIGN FOR GEN Z:
✓ Quick to fun (no long tutorials)
✓ Shareable moments
✓ Authentic aesthetic (not corporate)
✓ Optional depth
✓ Transparent mechanics

✗ Avoid:
✗ Mandatory social features
✗ Obvious monetization pressure
✗ "Hello fellow kids" energy
✗ Information overload upfront
```

#### Millennials (27-42)

```
CHARACTERISTICS:
• Grew up with games
• Nostalgia-responsive
• Time-constrained (careers, families)
• Value efficiency
• Quality over quantity mindset

PLAY PATTERNS:
• Sessions: 10-30 minutes, scheduled
• Platform: Cross-platform preference
• Social: Comparison more than cooperation
• Spending: Value-based, patient

DESIGN FOR MILLENNIALS:
✓ Respect their time
✓ Clear progress visibility
✓ Save anywhere
✓ Strategic depth available
✓ Nostalgic callbacks (done well)

✗ Avoid:
✗ Daily login requirements
✗ FOMO mechanics
✗ Pay-to-win
✗ Complexity without purpose
✗ Forced tutorials for experienced gamers
```

#### Gen X (43-58)

```
CHARACTERISTICS:
• Gaming's first generation
• Less influenced by trends
• Value substance
• Patience for depth
• Skeptical of hype

PLAY PATTERNS:
• Sessions: Longer when possible (30-60 min)
• Platform: PC/tablet preference
• Social: Private, selective
• Spending: Premium games, less F2P tolerant

DESIGN FOR GEN X:
✓ Depth and substance
✓ Clear, readable UI
✓ No pressure tactics
✓ Complexity as option
✓ Single-player focus okay

✗ Avoid:
✗ Trendy aesthetics
✗ Mandatory social
✗ Small touch targets
✗ Rapid-fire mechanics
✗ Disrespecting gaming knowledge
```

#### Boomers (59+)

```
CHARACTERISTICS:
• Growing gaming segment
• Cognitive engagement seeking
• Social connection valued
• Patience for learning
• Quality time perspective

PLAY PATTERNS:
• Sessions: Variable, often longer
• Platform: Tablet/PC (larger screens)
• Social: Family connection, communities
• Spending: Fair price for fair product

DESIGN FOR BOOMERS:
✓ Large, clear UI elements
✓ Adjustable text size
✓ Forgiving timing
✓ Comprehensive help available
✓ Dignified tone (not condescending)

✗ Avoid:
✗ Tiny touch targets
✗ Reflex-based mechanics
✗ Assumed gaming literacy
✗ Inaccessible color schemes
✗ Patronizing tutorials
```

### Cross-Generational Appeal

**Universal Fun Principles:**

```
WORKS FOR EVERYONE:
• Meaningful choices
• Clear feedback
• Visible progress
• Respectful pacing
• Aesthetic pleasure
• Sense of accomplishment

VARIES BY AGE:
• Optimal session length
• Complexity preference
• Social integration
• Visual style tolerance
• Mechanical familiarity
```

## Gender Considerations

### Research-Based Insights

**Note:** Individual variation exceeds group averages. Design for broad appeal.

```
SOME PATTERNS (with high variance):

More common in female players:
• Completion motivation
• Fantasy/narrative engagement
• Social features importance
• Aesthetic sensitivity
• Match-3/puzzle affinity

More common in male players:
• Competition motivation
• Destruction/action appeal
• Min-max optimization
• Mechanical fascination
• Difficulty as badge of honor

UNIVERSAL:
• Fun is fun
• Respect is expected
• Quality matters
• Time is valuable
```

### Inclusive Design Principles

```
DO:
✓ Offer customization (not gendered defaults)
✓ Multiple difficulty options
✓ Social features as option, not requirement
✓ Diverse representation in characters
✓ Competition AND cooperation available

DON'T:
✗ "Pink it and shrink it" for female audience
✗ Assume gender from play patterns
✗ Gate content behind stereotypical preferences
✗ Sexualize characters unnecessarily
✗ Limit expression options
```

## Context-Based Personas

### The Commuter

```
CONTEXT: Playing during transit
TIME: 10-20 minutes
ENVIRONMENT: Public, distracting

NEEDS:
• Quick start/stop
• Auto-save
• One-handed possible
• Sound optional
• Low cognitive load moments available

DESIGN FOR:
✓ Session length flexibility
✓ Pause-anywhere
✓ Visual feedback (audio optional)
✓ Simple AND complex modes
```

### The Wind-Downer

```
CONTEXT: Playing before sleep
TIME: 15-45 minutes
ENVIRONMENT: Private, relaxed

NEEDS:
• Calming experience
• No stress mechanics
• Natural stopping points
• Dark mode
• Volume control

DESIGN FOR:
✓ Relaxing aesthetic option
✓ No penalty for drifting off
✓ Gentle audio
✓ Low blue light option
```

### The Lunch Breaker

```
CONTEXT: Playing during work break
TIME: 10-30 minutes
ENVIRONMENT: Semi-private, time-bounded

NEEDS:
• Predictable session length
• Satisfying in short time
• Professional appearance
• Quick alt-tab
• Sense of accomplishment

DESIGN FOR:
✓ Visible progress per session
✓ Clean aesthetic
✓ "Day complete" as natural endpoint
```

### The Weekend Warrior

```
CONTEXT: Dedicated gaming time
TIME: 1-3 hours
ENVIRONMENT: Home, focused

NEEDS:
• Depth to explore
• Strategic complexity
• Long-term goals
• Immersive experience
• Worth the dedicated time

DESIGN FOR:
✓ Advanced strategies
✓ Collection/completionism
✓ Seasonal goals
✓ Rich world details
```

## Building Player Empathy

### Player Journey Mapping

```
STAGE 1: DISCOVERY
─────────────────
Question: "What is this?"
Need: Clear value proposition
Risk: Confusion, bounce

STAGE 2: ONBOARDING
───────────────────
Question: "How do I play?"
Need: Low-friction learning
Risk: Overwhelm, give up

STAGE 3: SCAFFOLDING
────────────────────
Question: "Am I doing it right?"
Need: Positive reinforcement
Risk: Self-doubt, abandonment

STAGE 4: HABIT
──────────────
Question: "Do I want to return?"
Need: Intrinsic motivation
Risk: Boredom, churn

STAGE 5: MASTERY
────────────────
Question: "What else is there?"
Need: Depth, new challenges
Risk: Content exhaustion

STAGE 6: ADVOCACY
─────────────────
Question: "Should I tell others?"
Need: Shareable moments
Risk: Privacy concerns
```

### Empathy Interview Questions

For player research sessions:

```
ABOUT THEIR LIFE:
• What does a typical day look like?
• When do you usually play games?
• What were you doing right before this session?

ABOUT THEIR EXPECTATIONS:
• What did you think this game was about?
• What kind of experience were you hoping for?
• What would success look like to you?

ABOUT THEIR EXPERIENCE:
• What moment stood out to you?
• When did you feel most/least engaged?
• What would you tell a friend about this?

ABOUT THEIR FEELINGS:
• How do you feel right now?
• Was there anything frustrating?
• Was there anything delightful?
```
