# Art Direction Reference

## Farming in Purria Visual Identity

### Core Aesthetic: "Crystalline Low-Poly Charm"

A distinctive visual style combining geometric simplicity with organic warmth:

**1. Low-Poly Foundation**
- Faceted, geometric shapes with clean edges
- Visible polygon structure creates visual interest
- Simplified forms that read well at small sizes
- Modern yet timeless aesthetic

**2. Crystalline Accents**
- Translucent, gem-like wings and highlights
- Faceted surfaces that catch light
- Prismatic color reflections
- Magical, precious quality

**3. Kawaii Influence**
- Big, expressive eyes (the emotional anchor)
- Round, approachable proportions
- Cute but not childish
- Personality through pose and expression

### Character Design: Simulins

**Core Design Pillars:**
- Cute, low-poly/geometric game characters
- Faceted, crystalline wings/accents
- Big adorable eyes (largest feature, highly expressive)
- Bold colors with subtle gradients
- 3/4 angle view, transparent backgrounds
- 3 evolution phases (phase 1 → 2 → 3 with increasing detail)

**Evolution Phase Guidelines:**

| Phase | Complexity | Size | Details | Wings/Accents |
|-------|------------|------|---------|---------------|
| Phase 1 | Simple | Small | Basic shape, minimal features | Small buds or nubs |
| Phase 2 | Medium | Medium | More defined features, patterns | Partial wings, visible crystals |
| Phase 3 | Detailed | Large | Full detail, accessories | Full crystalline wings, glowing accents |

**Current Simulin Types:**

| Type | Primary Colors | Key Features | Personality |
|------|----------------|--------------|-------------|
| Spider | Purple/Violet | 8 geometric legs, web patterns | Clever, industrious |
| Bee | Yellow/Gold/Black | Hexagonal body, crystal wings | Busy, cheerful |
| Ladybug | Red/Black | Dome shell, spotted pattern | Lucky, friendly |
| Butterfly | Rainbow/Iridescent | Large faceted wings | Graceful, free-spirited |
| Grasshopper | Green/Lime | Long legs, antenna | Energetic, jumpy |
| Mole | Brown/Tan | Digging claws, small eyes | Hardworking, shy |

### AI Image Generation Prompts

**Base Simulin Prompt Template:**
```
cute low-poly geometric [CREATURE] game character, faceted crystalline
wings, big adorable eyes, bold [COLORS] with subtle gradients,
3/4 angle view, transparent background, phase [1/2/3] evolution,
[PHASE-SPECIFIC DETAILS]
```

**Phase-Specific Additions:**

Phase 1:
```
simple design, small size, minimal detail, baby-like proportions,
tiny wing buds, innocent expression
```

Phase 2:
```
medium complexity, developing features, partial crystalline wings,
more defined shape, growing confidence
```

Phase 3:
```
fully detailed, largest size, complete crystalline wings with
prismatic reflections, intricate geometric patterns, majestic pose,
glowing accents
```

**Positive Keywords:**
```
low-poly, geometric, faceted, crystalline, cute, adorable,
big eyes, bold colors, gradient, game sprite, transparent background,
3/4 view, chibi proportions, gem-like, prismatic, kawaii
```

**Avoid Keywords:**
```
realistic, photorealistic, high-poly, smooth, organic curves,
small eyes, muted colors, flat shading, front view, side view,
busy background, dark, gritty, complex textures
```

### Color Palette by Simulin

| Simulin | Primary | Secondary | Accent | Crystalline |
|---------|---------|-----------|--------|-------------|
| Spider | #8B5CF6 | #A78BFA | #C4B5FD | #E9D5FF |
| Bee | #F59E0B | #FBBF24 | #1F2937 | #FEF3C7 |
| Ladybug | #EF4444 | #1F2937 | #FBBF24 | #FEE2E2 |
| Butterfly | #EC4899 | #8B5CF6 | #06B6D4 | #F0ABFC |
| Grasshopper | #22C55E | #84CC16 | #365314 | #DCFCE7 |
| Mole | #92400E | #D97706 | #78350F | #FED7AA |

### Environment Art

**Hex Grid Fields:**
- Clean, geometric hex tiles
- Soft gradients within tiles
- Subtle glow effects for interactive elements
- Low-poly terrain with faceted hills

**UI Style:**
- Rounded corners with subtle faceted edges
- Glass-morphism with crystalline hints
- Bold, readable typography
- Color-coded by function (resources, actions, info)

**Backgrounds:**
- Soft gradient skies (not photorealistic)
- Stylized clouds with geometric edges
- Warm, inviting color temperatures
- Depth through layered parallax

### Technical Specifications

**Sprite Dimensions:**
- Phase 1: 128x128px base
- Phase 2: 192x192px base
- Phase 3: 256x256px base
- Export at 2x for retina

**File Formats:**
- Primary: PNG with transparency
- Vector backup: SVG (via Recraft vectorization)
- Web optimized: WebP

**Lighting Direction:**
- Primary light: Top-left (10 o'clock)
- Rim light: Bottom-right for depth
- Crystalline areas: Internal glow effect

### Color Theory Application

**Emotional Color Mapping:**
- Rewards/Success: Warm spectrum (gold → orange)
- Growth/Progress: Green spectrum
- Water/Sustain: Blue-green spectrum
- Risk/Betting: Purple and gold
- Danger/Trouble: Desaturated reds, grays

**Contrast Rules:**
- UI elements: High contrast for readability
- Backgrounds: Lower contrast, atmospheric
- Interactive elements: Pop against environment
- Crystalline accents: Bright highlights against body color
