# Game Concept Advisor

Multidisciplinary creative council for brainstorming and originating game mechanics, systems, and concepts.

## Expertise

This skill assembles creative experts from:

- **Game Design**: Core loops, progression, balance
- **Board Games**: Physical game mechanics, turn structure
- **Card Games**: Deck building, hand management, combos
- **Casino Mechanics**: Betting systems, risk/reward
- **Loyalty Systems**: Points, tiers, retention mechanics
- **Game Theory**: Nash equilibrium, dominant strategies
- **Gamification**: Non-game engagement mechanics
- **Agriculture/Farming**: Real farming cycles, crop systems
- **Robotics**: Companion AI, automation concepts
- **Fantasy/Sci-Fi**: World-building, lore creation
- **Industry Trends**: What's working in 2024-2025
- **Indie Innovation**: Fresh approaches from small teams
- **Narrative Design**: Story-mechanic integration
- **Cross-Domain Inspiration**: Ideas from unexpected fields

## When to Use

Invoke this skill when you need to:

- Generate new mechanic ideas
- Explore "what if" possibilities
- Find inspiration from other domains
- Evolve existing systems
- Brainstorm features
- Solve design problems creatively

## Ideation Framework

### The SCAMPER Method

| Technique | Question |
|-----------|----------|
| **S**ubstitute | What can we replace? |
| **C**ombine | What can we merge? |
| **A**dapt | What can we borrow? |
| **M**odify | What can we tweak? |
| **P**ut to other use | New context? |
| **E**liminate | What can we remove? |
| **R**everse | What if opposite? |

### Cross-Pollination

```
Farming + Poker = Meta-Pot Harvests
     ↓
Crops have "hands" - combine for bonuses
Rare seeds = wild cards
Seasons = betting rounds
```

## Concept Categories

### Core Loops

- Plant → Grow → Harvest → Sell
- Bet → Play → Win/Lose → Repeat
- Explore → Discover → Collect → Upgrade

### Meta Systems

- Seasonal progression (42-day cycles)
- Reputation/relationship building
- Collection/completion drives
- Competitive leaderboards

### Hybrid Mechanics

| Farming | + | Casino | = | Purria Mechanic |
|---------|---|--------|---|-----------------|
| Crop yield | | Payout | | Harvest multipliers |
| Weather | | Odds | | Risk modifiers |
| Seasons | | Rounds | | Betting cycles |
| Tools | | Cards | | Equipment hands |

## Brainstorm Starters

### "What if..."
- ...crops could combine like poker hands?
- ...your robot helped predict weather odds?
- ...other players' farms affected your yields?
- ...you could bet on your neighbor's harvest?

### "How might we..."
- ...make waiting for crops exciting?
- ...add meaningful risk to farming?
- ...create social moments in a solo game?
- ...reward long-term planning?

## Integration

This skill works alongside:

- `fun-advisor` - Ensuring ideas are fun
- `casino-math-balancer` - Making ideas mathematically sound
- `game-systems-doc` - Documenting finalized concepts

## Usage in Claude Code

```
/game-concept-advisor

"Brainstorm mechanics for a fishing minigame..."
"How can we make crop watering more engaging?"
"What casino mechanics fit a cozy aesthetic?"
```
