---
name: game-concept-advisor
description: Multidisciplinary creative council for brainstorming and originating game mechanics, systems, and concepts. Use when generating new ideas, exploring mechanic possibilities, seeking inspiration from other domains, evolving existing systems, or when creative ideation is needed. Covers game design, board games, card games, casino mechanics, loyalty systems, game theory, gamification, tulip farming, robotic agriculture, fantasy/sci-fi world-building, industry trends, indie innovation, narrative design, and cross-domain inspiration. Triggers on requests for new ideas, mechanic brainstorming, "what if" exploration, feature ideation, or creative problem-solving.
---

# Game Concept Advisor

A creative council dedicated to generating, refining, and evolving innovative game concepts for Farming in Purria.

## The Creative Council

### Core Game Experts

| Expert | Domain | Creative Lens |
|--------|--------|---------------|
| **Game Designer** | Core mechanics, systems | "What makes this playable?" |
| **Board Game Scholar** | Tabletop mechanics | "What works without computers?" |
| **Card Game Architect** | Hand management, deck building | "How do cards create decisions?" |
| **Casino Mathematician** | Betting, odds, risk systems | "Where's the thrill in uncertainty?" |
| **Game Theorist** | Strategy, Nash equilibrium, decisions | "What's the optimal play—and why break it?" |

### Domain Specialists

| Expert | Domain | Creative Lens |
|--------|--------|---------------|
| **Tulip Horticulturist** | Flower cultivation, varieties | "What's true about tulips we can use?" |
| **Agricultural Roboticist** | Automation, farm AI | "How would robots actually farm?" |
| **Fantasy World-Builder** | Magic systems, races, lore | "What makes Purria feel alive?" |
| **Sci-Fi Futurist** | Technology, speculation | "What tech is possible here?" |
| **Narrative Designer** | Story, character, theme | "What story are we telling?" |

### Industry & Trend Experts

| Expert | Domain | Creative Lens |
|--------|--------|---------------|
| **Industry Analyst** | Market trends, successful games | "What's working right now?" |
| **Indie Innovator** | Constraint-driven creativity | "How do we do more with less?" |
| **Cozy Game Specialist** | Relaxation, comfort, warmth | "How does this feel like a hug?" |
| **Live Service Architect** | Seasons, events, evolution | "How does this stay fresh?" |
| **Monetization Ethicist** | Sustainable revenue, respect | "How do we profit without exploiting?" |

### Cross-Domain Innovators

| Expert | Domain | Creative Lens |
|--------|--------|---------------|
| **Gamification Expert** | Non-game applications | "What works outside games?" |
| **Loyalty Program Designer** | Retention, rewards, tiers | "Why do people keep coming back?" |
| **Behavioral Economist** | Decision-making, biases | "How do people actually choose?" |
| **Cross-Media Pollinator** | Film, TV, books, other games | "What can we steal brilliantly?" |
| **Systems Thinker** | Emergence, interaction | "How do pieces create surprise?" |

### Accessibility & Inclusion

| Expert | Domain | Creative Lens |
|--------|--------|---------------|
| **Accessibility Innovator** | Inclusive mechanics | "Can everyone experience this?" |
| **Cultural Bridge** | Global appeal, localization | "Does this translate worldwide?" |
| **Intergenerational Designer** | All ages, family play | "Can grandma and grandson both enjoy this?" |

---

## Part I: Ideation Frameworks

### The SCAMPER Method

Apply to any existing mechanic:

```
S - SUBSTITUTE
    What can we swap out?
    "What if instead of coins, we bet with time?"
    
C - COMBINE  
    What can we merge?
    "What if the hex grid AND the cards were the same thing?"
    
A - ADAPT
    What can we borrow from elsewhere?
    "What if pot filling worked like Tetris?"
    
M - MODIFY/MAGNIFY/MINIMIZE
    What if we changed the scale?
    "What if there were 100 tiny bets instead of 4 big ones?"
    
P - PUT TO OTHER USES
    What else could this do?
    "What if trouble also created opportunities?"
    
E - ELIMINATE
    What if we removed this entirely?
    "What if there was no losing—only degrees of winning?"
    
R - REVERSE/REARRANGE
    What if we flipped it?
    "What if players set the pot thresholds, not the game?"
```

### The "What If" Engine

Structured speculation for new mechanics:

```
FORMULA: "What if [DOMAIN A] worked like [DOMAIN B]?"

Examples:
• "What if betting worked like gardening?" (plant bets, watch them grow)
• "What if tulips worked like poker hands?" (tulip combinations = hands)
• "What if Simulins worked like Tamagotchi?" (care affects performance)
• "What if seasons worked like roguelike runs?" (permadeath, fresh starts)
• "What if trouble worked like tower defense?" (waves, placement)
• "What if the farm worked like a slot machine?" (spin to plant)
• "What if progression worked like frequent flyer miles?" (tiers, perks)
```

### The Constraint Canvas

Creativity thrives under constraints:

```
┌─────────────────────────────────────────────────────────────────┐
│                    CONSTRAINT CANVAS                            │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  MUST HAVE              │  MUST NOT HAVE                       │
│  ───────────            │  ──────────────                      │
│  • Meaningful choice    │  • Real money gambling               │
│  • Session <20 min      │  • Pay-to-win                        │
│  • Mobile-friendly      │  • Mandatory daily login             │
│  • Tulip theming        │  • Complexity overload               │
│                         │  • Anxiety-inducing timers           │
│                                                                 │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  COULD HAVE             │  COULD EXPERIMENT WITH               │
│  ──────────             │  ────────────────────                 │
│  • Multiplayer          │  • AR features                       │
│  • Narrative campaign   │  • Voice control                     │
│  • Collection systems   │  • AI companions                     │
│  • Seasonal events      │  • User-generated content            │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘

Generate ideas that satisfy MUST HAVE, avoid MUST NOT HAVE,
and optionally explore COULD HAVE and EXPERIMENT areas.
```

### The Mashup Matrix

Cross-pollinate mechanics from different sources:

```
                    FARMING IN PURRIA ELEMENTS
                    ┌─────┬─────┬─────┬─────┬─────┐
                    │ Hex │ Bet │ Pot │Trbl │Simln│
         ┌──────────┼─────┼─────┼─────┼─────┼─────┤
         │ Poker    │  ?  │  ?  │  ?  │  ?  │  ?  │
         ├──────────┼─────┼─────┼─────┼─────┼─────┤
  FROM   │ Farming  │  ?  │  ?  │  ?  │  ?  │  ?  │
  OTHER  ├──────────┼─────┼─────┼─────┼─────┼─────┤
  GAMES  │ Roguelike│  ?  │  ?  │  ?  │  ?  │  ?  │
         ├──────────┼─────┼─────┼─────┼─────┼─────┤
         │ Puzzle   │  ?  │  ?  │  ?  │  ?  │  ?  │
         ├──────────┼─────┼─────┼─────┼─────┼─────┤
         │ RPG      │  ?  │  ?  │  ?  │  ?  │  ?  │
         └──────────┴─────┴─────┴─────┴─────┴─────┘

Each ? is a potential new mechanic to explore.
Example: Roguelike × Trouble = "Trouble mutations each run"
Example: RPG × Simulin = "Simulins level up and learn abilities"
```

### The Problem-Solution Flip

Turn challenges into features:

```
PROBLEM                          SOLUTION AS FEATURE
───────                          ───────────────────
"Mid-season is boring"       →   Introduce mid-season events/crises
"Too much to track"          →   Simulins as advisors who highlight important info
"Losses feel bad"            →   Losses unlock "learning bonuses" for next attempt
"Waiting for resolution"     →   Mini-games during resolution phase
"Same strategy every time"   →   Daily modifiers that change optimal play
```

---

## Part II: Mechanic Libraries

### Card Game Mechanics

```
HAND MANAGEMENT
───────────────
• Draw and play (hand limit creates decisions)
• Card cycling (discard to draw)
• Hand building over time
• Reveal vs hidden information

FOR FARMING IN PURRIA:
→ Daily "hand" of action cards
→ Choose which to play each phase
→ Unused cards carry over or convert to bonus

DECK BUILDING
─────────────
• Start with basic deck
• Add cards through play
• Thin deck of weak cards
• Combos and synergies

FOR FARMING IN PURRIA:
→ Build a "strategy deck" over seasons
→ Cards represent farming techniques
→ Powerful combos = tulip varieties

SET COLLECTION
──────────────
• Gather matching items
• Complete sets for bonuses
• Trade-offs (specialize vs diversify)

FOR FARMING IN PURRIA:
→ Tulip variety collections
→ Complete color sets for multipliers
→ Rare varieties worth more but harder to grow

TRICK-TAKING
────────────
• Play cards to win "tricks"
• Follow suit requirements
• Trump mechanics

FOR FARMING IN PURRIA:
→ "Bid" on weather outcomes
→ Highest appropriate card wins the pot
→ Wild "joker" weather events
```

### Board Game Mechanics

```
WORKER PLACEMENT
────────────────
• Limited action spaces
• First-come, first-served
• Blocking opponents

FOR FARMING IN PURRIA:
→ Place Simulins on hexes for bonuses
→ Limited Simulin actions per day
→ Strategic positioning matters

AREA CONTROL
────────────
• Majority in regions = rewards
• Spreading influence
• Defensive and offensive positioning

FOR FARMING IN PURRIA:
→ Control hex regions for bonuses
→ Trouble competes for territory
→ "Liberate" hexes from trouble

RESOURCE CONVERSION
───────────────────
• Turn A into B into C
• Efficiency chains
• Multiple paths to goals

FOR FARMING IN PURRIA:
→ Coins → Seeds → Tulips → Bulbs → Better Seeds
→ Multiple conversion rates
→ Timing conversions for maximum value

TILE PLACEMENT
──────────────
• Build a shared or personal space
• Adjacency bonuses
• Spatial puzzles

FOR FARMING IN PURRIA:
→ Unlock new hex tiles
→ Choose where to place them
→ Adjacency affects growth/trouble spread

ENGINE BUILDING
───────────────
• Small advantages compound
• Build toward powerful late game
• Satisfying acceleration

FOR FARMING IN PURRIA:
→ Early seasons build farm infrastructure
→ Later seasons: infrastructure pays off
→ Multiple engine paths (water focus, sun focus, etc.)
```

### Casino Mechanics

```
BETTING SYSTEMS
───────────────
• Ante (mandatory small bet)
• Blinds (rotating forced bets)
• Raise/call/fold decisions
• Side bets and insurance

FOR FARMING IN PURRIA:
→ Daily "ante" commits resources
→ Optional "side bets" on specific outcomes
→ Insurance against total loss

MULTIPLIERS
───────────
• Bet multipliers based on risk
• Combo multipliers
• Progressive multipliers

FOR FARMING IN PURRIA:
→ Streak multipliers (consecutive wins)
→ All-in bonus multipliers
→ Seasonal cumulative multipliers

PROGRESSIVE JACKPOTS
────────────────────
• Small contributions build big prize
• Rare but life-changing wins
• Anticipation and excitement

FOR FARMING IN PURRIA:
→ "Golden Harvest" jackpot builds over days
→ Specific rare events trigger jackpot
→ Shared jackpot across all players?

NEAR MISSES
───────────
• Almost winning feels close to winning
• Encourages continued play
• Must be used ethically

FOR FARMING IN PURRIA:
→ "So close!" moments with partial rewards
→ Near-miss on pot threshold gives small bonus
→ Visual celebration even for near-wins

ODDS DISPLAY
────────────
• Transparent probability
• Informed decision-making
• Trust building

FOR FARMING IN PURRIA:
→ Show pot fill projections
→ Display win probability estimates
→ "Smart bet" suggestions (optional)
```

### Loyalty & Progression Mechanics

```
TIER SYSTEMS
────────────
• Bronze → Silver → Gold → Platinum
• Tier benefits unlock at thresholds
• Status maintenance requirements

FOR FARMING IN PURRIA:
→ Farmer ranks with titles
→ Higher ranks = better daily bonuses
→ Seasonal rank reset with carryover perks

POINTS CURRENCIES
─────────────────
• Earn points for activities
• Spend points on rewards
• Multiple point types

FOR FARMING IN PURRIA:
→ "Growth Points" for progression
→ "Style Points" for cosmetics
→ "Prestige Points" for leaderboards

STREAK REWARDS
──────────────
• Consecutive day bonuses
• Building momentum
• Soft encouragement (not punishment for missing)

FOR FARMING IN PURRIA:
→ Playing streak bonuses (gentle)
→ Win streak multipliers
→ "Comeback bonus" after absence (not punishment)

MILESTONE UNLOCKS
─────────────────
• Permanent rewards at thresholds
• Sense of permanent progress
• Goals to work toward

FOR FARMING IN PURRIA:
→ Total tulips grown → new varieties
→ Seasons completed → new Simulins
→ Achievements → cosmetic rewards
```

---

## Part III: Domain Deep Dives

### Tulip Farming Reality

**Actual tulip cultivation facts we can use:**

```
GROWTH CYCLE
────────────
• Bulbs planted in fall, bloom in spring
• 3-4 months from planting to bloom
• Cold period required (vernalization)
• Different varieties bloom at different times

GAME APPLICATION:
→ "Cold snap" events boost certain tulips
→ Variety timing creates strategic planting
→ Bulb quality affects bloom quality

TULIP VARIETIES
───────────────
• Single Early, Double Early, Triumph, Darwin Hybrid
• Lily-flowered, Fringed, Viridiflora, Parrot
• Colors: Every color except true blue
• Patterns: Solid, flamed, feathered

GAME APPLICATION:
→ Variety collection system
→ Breeding for rare patterns
→ Color-matching bonuses

TULIP TROUBLES (REAL)
─────────────────────
• Tulip fire (fungal disease)
• Aphids and other pests
• Botrytis blight
• Bulb rot from overwatering

GAME APPLICATION:
→ Real disease names add authenticity
→ Different troubles have different spreads
→ Prevention vs treatment strategies

TULIP MANIA (HISTORICAL)
────────────────────────
• 1630s Dutch speculation bubble
• Single bulbs worth more than houses
• "Broken" tulips most valuable (actually virus-caused)
• Crash and lessons about speculation

GAME APPLICATION:
→ Market fluctuation mechanics
→ Rare "broken" tulips as special rewards
→ Speculation mini-game?
→ Historical nods in flavor text
```

### Robotic Farming Reality

**Agricultural robotics we can adapt:**

```
REAL FARM ROBOTS
────────────────
• Autonomous tractors (GPS-guided)
• Harvesting robots (computer vision)
• Weeding robots (precision targeting)
• Drone monitoring (aerial surveillance)
• Soil sampling robots

SIMULIN APPLICATIONS:
→ Different Simulin types for different tasks
→ Vision systems = trouble detection
→ Precision = targeted interventions
→ Drones = map awareness

ROBOT LIMITATIONS
─────────────────
• Battery/energy constraints
• Weather sensitivity
• Maintenance needs
• Learning curves

SIMULIN APPLICATIONS:
→ Energy management mechanic
→ Weather affects Simulin efficiency
→ Repair/upgrade systems
→ Simulin skill progression

ROBOT PERSONALITIES (AI)
────────────────────────
• Some robots develop "quirks"
• Farmers anthropomorphize equipment
• Predictable but individually distinct

SIMULIN APPLICATIONS:
→ Each Simulin has personality traits
→ Traits affect behavior and bonuses
→ Players bond with specific Simulins
```

### Fantasy World-Building

**Elements that make Purria feel magical:**

```
MAGIC SYSTEMS
─────────────
• Hard magic: Clear rules, costs, limits
• Soft magic: Mysterious, wonder-inducing
• Hybrid: Rules where needed, mystery elsewhere

FOR PURRIA:
→ "Growth magic" powers the pots (hard rules)
→ Ancient Purrian mysteries (soft, unexplained)
→ Players learn rules through play

WORLD DETAILS
─────────────
• Climate and geography
• Flora and fauna
• History and culture
• Technology level

FOR PURRIA:
→ Mild climate, rolling hills, crystal streams
→ Bio-luminescent plants, gentle creatures
→ Ancient tulip-worshipping civilization
→ Steampunk-botanical hybrid tech

CREATURE DESIGN
───────────────
• Mix familiar with unfamiliar
• Form follows function
• Personality through design

FOR SIMULINS:
→ Brass + vines + clockwork + warmth
→ Each type built for its role
→ Charming imperfections
```

---

## Part IV: Idea Generation Sessions

### The Rapid Fire Protocol

Generate many ideas quickly, filter later:

```
PHASE 1: DIVERGE (10 minutes)
────────────────────────────
• No judgment, no filtering
• Quantity over quality
• Build on others' ideas ("Yes, and...")
• Write everything down

PHASE 2: CLUSTER (5 minutes)
────────────────────────────
• Group similar ideas
• Name each cluster
• Note overlaps

PHASE 3: SELECT (5 minutes)
───────────────────────────
• Vote on most promising clusters
• Pick top 3-5 for exploration
• Note "parking lot" ideas for later

PHASE 4: DEVELOP (15 minutes each)
──────────────────────────────────
• Flesh out selected ideas
• Consider implementation
• Identify challenges
• Score on feasibility × excitement
```

### The Expert Consultation

Deep dive with specific council members:

```
FORMAT:
1. State the challenge or opportunity
2. Invite relevant experts to respond
3. Seek connections between perspectives
4. Synthesize into actionable concepts

EXAMPLE:

CHALLENGE: "Mid-season gameplay feels repetitive"

BOARD GAME SCHOLAR:
"Introduce event cards that change rules temporarily"

CASINO MATHEMATICIAN:
"Add progressive jackpot that builds mid-season tension"

NARRATIVE DESIGNER:
"Mid-season crisis storyline with Simulin dialogue"

LIVE SERVICE ARCHITECT:
"Weekly challenges with unique modifiers"

SYNTHESIS:
→ Mid-season "Crisis Week" with:
  - Special event cards changing rules
  - Crisis jackpot building each day
  - Simulin commentary and story beats
  - Unique rewards for crisis completion
```

### The Reverse Brief

Work backward from desired experience:

```
TEMPLATE:

DESIRED PLAYER FEELING:
"I want players to feel ____________"

Example: "I want players to feel like master gardeners who read their farm like poker players read opponents"

QUESTIONS:
• What would create this feeling?
• What mechanics support this?
• What would undermine this?
• How do we know we've achieved it?

MECHANIC IMPLICATIONS:
• Readable patterns (tells)
• Skill expression through reading
• Rewards for correct reads
• Information to analyze
```

---

## Part V: Concept Validation

### The Quick Filter

Before developing any idea, check:

```
□ FANTASY FIT
  Does this fit "charming robot tulip farmer who gambles wisely"?
  
□ FUN POTENTIAL
  Is there a clear source of fun here?
  
□ FEASIBILITY
  Can we actually build this with our tech?
  
□ UNIQUENESS
  Does this differentiate us?
  
□ SCOPE
  Is this appropriately sized?

SCORING:
5/5 = Definitely explore
4/5 = Worth investigating  
3/5 = Maybe, needs work
2/5 = Probably not
1/5 = Doesn't fit
```

### The Depth Test

For ideas that pass the quick filter:

```
QUESTIONS TO ANSWER:

1. CORE LOOP INTEGRATION
   How does this connect to betting/pots/hexes/time?
   
2. PLAYER DECISIONS
   What meaningful choices does this create?
   
3. SKILL EXPRESSION
   How do experienced players play this differently?
   
4. FAILURE STATES
   What happens when this goes wrong?
   
5. EDGE CASES
   What weird situations might arise?
   
6. IMPLEMENTATION SCOPE
   Roughly how much work is this?
   
7. DEPENDENCIES
   What else needs to exist for this to work?
```

### The Paper Prototype Test

Test concepts before coding:

```
MATERIALS:
• Index cards
• Dice (for randomness)
• Paper hex grid
• Tokens (coins, etc.)

PROCESS:
1. Write mechanic rules simply
2. Play through scenarios manually
3. Note friction points
4. Adjust rules and replay
5. If fun on paper, consider digital

IF IT'S NOT FUN ON PAPER, IT WON'T BE FUN DIGITALLY.
```

---

## Part VI: Living Inspiration Sources

### Games to Study

```
FARMING + COZY:
• Stardew Valley (loop, charm, depth)
• Ooblets (personality, collection)
• Garden Story (combat + farming hybrid)
• Bear and Breakfast (business management)

CARD + STRATEGY:
• Slay the Spire (deck building + roguelike)
• Balatro (poker + scoring combos)
• Inscryption (cards + meta narrative)
• Luck Be a Landlord (slot machine + deck builder)

CASINO + CASUAL:
• Poker Night at the Inventory (personality)
• Super Auto Pets (simple, deep)
• Dicey Dungeons (dice + abilities)

HEX + TERRITORY:
• Catan (resource, trading, area)
• Terraforming Mars (engine building)
• Dorfromantik (tile placement, cozy)

MOBILE SUCCESS:
• Clash Royale (quick sessions)
• Candy Crush (satisfaction design)
• Pokémon GO (collection + real world)
```

### Mechanics to Explore

```
UNDERUSED IN FARMING GAMES:
• Auction mechanics
• Push-your-luck
• Hidden role/information
• Asymmetric player powers
• Legacy/permanent consequences
• Time manipulation
• Negotiation/trading

TRENDING IN 2024-2025:
• AI companions with personality
• Cozy aesthetics + mechanical depth
• Roguelike elements in unexpected genres
• Social features that respect introverts
• Accessibility-first design
• "Anti-grind" respect for player time
```

---

## Reference Documents

- [Card Game Mechanics](references/card-mechanics.md) - Comprehensive card game patterns
- [Board Game Mechanics](references/board-mechanics.md) - Tabletop mechanics library
- [Casino & Gambling Systems](references/casino-systems.md) - Betting, odds, psychological design
- [Farming & Agriculture](references/farming-domain.md) - Real tulip cultivation, robotic farming
- [Inspiration Gallery](references/inspiration-gallery.md) - Games, mechanics, cross-media ideas
