# Card Game Mechanics

## Core Card Mechanics

### Hand Management

The fundamental tension of what to keep and what to use.

```
CLASSIC HAND MANAGEMENT
───────────────────────
• Draw cards into hand (usually limited)
• Choose which to play
• Discard or retain unplayed cards
• Timing of plays matters

VARIATIONS:
• Forced discard (must discard to draw)
• Hand cycling (discard any, draw equal)
• Hand passing (give cards to opponent/neighbor)
• Hand revealing (show for benefit)

FARMING IN PURRIA APPLICATIONS:

"Daily Action Hand"
├─ Draw 3 action cards each morning
├─ Play 1-2 during action phase
├─ Unplayed cards: discard or carry (limit 5)
└─ Cards: Water Boost, Sun Focus, Pest Shield, Wild Growth, etc.

"Betting Hand"
├─ Draw betting modifier cards
├─ Play to enhance or hedge bets
├─ Rare cards provide big swings
└─ Example: "Double Down" - 2x bet, 2x reward OR loss
```

### Deck Building

Start weak, grow strong through card acquisition.

```
DECK BUILDING FUNDAMENTALS
──────────────────────────
• Begin with basic starter deck
• Add cards through purchase/reward
• Remove weak cards (deck thinning)
• Build toward combos and synergies

KEY CONCEPTS:
• Deck consistency (fewer cards = more predictable)
• Power curves (early game vs late game cards)
• Archetype definition (aggressive, defensive, combo)
• Card economy (cost vs benefit)

FARMING IN PURRIA APPLICATIONS:

"Seasonal Strategy Deck"
├─ Start each season with basic 10-card deck
├─ Win rewards: add specialty cards
├─ Visit Shop: buy/remove cards
├─ Deck represents farming expertise
└─ Different decks = different playstyles

"Simulin Ability Deck"
├─ Each Simulin has ability cards
├─ Level up Simulins to add abilities
├─ Mix Simulins for deck variety
└─ Synergies between Simulin types
```

### Drafting

Choose cards from limited pools, creating unique combinations.

```
DRAFTING METHODS
────────────────
• Open draft (all cards visible, take turns)
• Closed draft (pick and pass hands)
• Grid draft (rows/columns, take whole row OR column)
• Cube draft (large pool, each player builds from it)

FARMING IN PURRIA APPLICATIONS:

"Morning Market Draft"
├─ Each morning, 5 cards revealed
├─ Draft order based on previous day performance
├─ Undrafted cards discount next day
└─ Creates daily variety and decisions

"Seed Packet Draft"
├─ At season start, draft seed packets
├─ Each packet has tulip varieties + bonuses
├─ Specialize or diversify
└─ Snake draft (worst picks first next round)
```

### Trick-Taking

Play cards to win "tricks," with rules about what can be played.

```
TRICK-TAKING ELEMENTS
─────────────────────
• Lead player sets suit
• Follow suit if possible
• Highest card in suit wins (usually)
• Trump suit beats all
• Bidding on tricks won

FARMING IN PURRIA APPLICATIONS:

"Weather Prediction"
├─ Each player bids on weather outcome
├─ Play weather cards to influence
├─ Highest relevant card wins the "weather trick"
├─ Winner's prediction more likely
└─ Affects pot filling for everyone

"Trouble Combat"
├─ Trouble spawns with strength value
├─ Players play combat cards
├─ Must "follow suit" (match trouble type)
├─ Highest card defeats trouble
└─ Team-based trick-taking?
```

### Set Collection

Gather matching items for bonuses.

```
SET COLLECTION PATTERNS
───────────────────────
• Matching sets (3 of same)
• Runs (sequential values)
• Color matching
• Category completion
• Unique sets (all different)

SCORING VARIANTS:
• Linear (each card worth X)
• Exponential (set of 3 worth more than 3× single)
• Threshold (need minimum for any points)
• Majority (most of type wins)

FARMING IN PURRIA APPLICATIONS:

"Tulip Collection"
├─ Collect tulip variety cards
├─ Complete sets for permanent bonuses
├─ Rare varieties: harder but more valuable
├─ Album display: show off collections
└─ Sets unlock cosmetics/Simulins

"Resource Conversion Sets"
├─ Trade resource cards for better resources
├─ 3 Water cards → 1 Rain card
├─ Complete seasonal sets for jackpot
└─ Set completion = gambling payoff
```

## Poker Adaptations

### Texas Hold'em Elements

```
ADAPTABLE ELEMENTS:
• Community cards (shared information)
• Betting rounds (escalating commitment)
• Position advantage (information from others' actions)
• Bluffing possibility
• Hand rankings and odds

FARMING IN PURRIA APPLICATIONS:

"Pot Prediction Poker"
├─ Community "condition cards" revealed over phases
├─ Morning: 2 cards (weather, soil)
├─ Action: 1 card (growth modifier)
├─ Resolution: Final 2 cards (outcome modifiers)
├─ Players bet on pot outcomes like poker hands
└─ Fold/call/raise on likelihood of pot success
```

### Blackjack Elements

```
ADAPTABLE ELEMENTS:
• Target value (21)
• Hit or stand decisions
• Bust penalty
• Card counting advantage
• Split and double down options

FARMING IN PURRIA APPLICATIONS:

"Growth Target"
├─ Target: Grow tulip to exactly 21 points
├─ Each action card adds growth points
├─ Hit: draw another action
├─ Stand: lock in current growth
├─ Bust: Over 21, tulip is "burned" (stress)
└─ Blackjack (exactly 21 on first two): bonus reward
```

### Baccarat Elements

```
ADAPTABLE ELEMENTS:
• Bet on outcomes (player/banker/tie)
• No player decisions after bet
• Dramatic reveal
• Simple rules, elegant tension

FARMING IN PURRIA APPLICATIONS:

"Harvest Prediction"
├─ Bet on which field section wins
├─ North field vs South field
├─ Or bet on tie (highest payout)
├─ Watch resolution unfold
└─ Pure prediction gambling
```

## Advanced Card Patterns

### Card Combos

```
COMBO TYPES
───────────
• Pairs (two cards create bonus)
• Chains (play cards in sequence for escalating effect)
• Triggers (playing one activates another)
• Engines (permanent card enhances all plays)

FARMING IN PURRIA APPLICATIONS:

"Simulin Synergy"
├─ Water Simulin + Rain Card = 3× effect
├─ Chain: Play 3+ growth cards = bonus card draw
├─ Engine: "Greenhouse" card boosts all growth by 20%
└─ Discovery of combos is part of the fun
```

### Card Transformation

```
TRANSFORMATION PATTERNS
───────────────────────
• Upgrade (card becomes stronger version)
• Split (one card becomes multiple)
• Merge (multiple cards combine)
• Flip (card has two sides/modes)
• Evolve (card changes based on conditions)

FARMING IN PURRIA APPLICATIONS:

"Seed to Bloom"
├─ Seed cards start weak
├─ Plant in hex: becomes Growing card
├─ Tend for 3 days: becomes Bloom card
├─ Harvest: becomes Bulb card
└─ Cards transform through gameplay
```

### Resource Cards

```
RESOURCE CARD PATTERNS
──────────────────────
• Currency cards (spend for effects)
• Energy cards (required to play other cards)
• Material cards (combine for crafting)
• Time cards (determine turn order/actions)

FARMING IN PURRIA APPLICATIONS:

"Multi-Use Resource Cards"
├─ Water card: Spend for growth OR save for drought protection
├─ Sun card: Spend for bloom OR convert to energy
├─ Resource decisions every turn
└─ Same card, different strategic uses
```

## Probability & Card Counting

### Informed Gambling

```
CARD COUNTING PRINCIPLES
────────────────────────
• Track what's been played
• Calculate remaining probabilities
• Adjust strategy based on deck state
• Skill rewards attention and memory

ETHICAL IMPLEMENTATION:
• Encourage but don't require counting
• Provide optional tracking UI
• Reward skill without punishing casual play
• Make counting satisfying, not tedious

FARMING IN PURRIA APPLICATIONS:

"Weather Deck Tracking"
├─ Weather deck has 30 cards
├─ Each day, weather cards revealed and discarded
├─ Tracking remaining cards = better prediction
├─ Optional UI: "Card tracker" helper
└─ Skill: Know when drought card is likely
```

### Deck Manipulation

```
MANIPULATION MECHANICS
──────────────────────
• Scry (look at top X cards, reorder)
• Tutor (search deck for specific card)
• Mill (discard from deck)
• Shuffle (randomize deck)
• Stack (put card on top/bottom)

FARMING IN PURRIA APPLICATIONS:

"Simulin Scouting"
├─ Scout Simulin: Look at next 3 weather cards
├─ Choose to reorder or shuffle
├─ Costs: Stamina or coins
└─ Risk: Sometimes shuffling is worse

"Seed Sorting"
├─ Visit Seed Sorter building
├─ Look at your deck, reorder top 5
├─ Premium: Remove a card permanently
└─ Deck management as strategic choice
```
