# Farming & Agriculture Domain

## Tulip Cultivation Reality

### The Tulip Life Cycle

```
NATURAL TULIP CYCLE
───────────────────

FALL (Planting)                 WINTER (Dormancy)
    │                               │
    ▼                               ▼
┌─────────────┐              ┌─────────────┐
│ Plant bulb  │              │ Cold period │
│ 6-8" deep   │     ───►     │ Required!   │
│ Pointy end  │              │ "Vernaliz-  │
│ up          │              │  ation"     │
└─────────────┘              └─────────────┘
                                    │
                                    ▼
    FALL (Next Year)          SPRING (Bloom)
         │                          │
         ▼                          ▼
    ┌─────────────┐          ┌─────────────┐
    │ Bulb splits │   ◄───   │ Leaves,     │
    │ into offsets│          │ stem, flower│
    │ Replant or  │          │ 3-4 weeks   │
    │ harvest     │          │ of bloom    │
    └─────────────┘          └─────────────┘

GAME APPLICATION:
• Seasons can represent this cycle compressed
• Cold requirement = interesting mechanic (need cold events)
• Bulb splitting = multiplication resource
• Bloom timing = optimization target
```

### Tulip Varieties

```
CLASSIFICATION DIVISIONS (Official)
───────────────────────────────────

EARLY BLOOMING:
• Single Early: Cup-shaped, 10-18" tall
• Double Early: Peony-like, dense petals

MID-SEASON:
• Triumph: Classic tulip shape, most popular
• Darwin Hybrid: Large, bright, strong stems

LATE BLOOMING:
• Single Late: Egg-shaped, tall
• Lily-flowered: Pointed petals, elegant
• Fringed: Crystal-like fringed edges
• Viridiflora: Green streaks on petals
• Parrot: Twisted, feathered petals
• Double Late: Peony-type, heavy blooms

SPECIES & OTHERS:
• Kaufmanniana: "Waterlily tulip"
• Fosteriana: Large, early
• Greigii: Mottled/striped leaves

GAME APPLICATION:
├─ 15 variety categories to collect
├─ Bloom timing creates strategic planting
├─ Rare varieties (Parrot, Fringed) = harder but valuable
├─ Species tulips = special achievements
└─ Real names add authenticity
```

### Tulip Colors & Patterns

```
AVAILABLE COLORS
────────────────
• Red, Pink, Orange, Yellow, White, Cream
• Purple, Violet, Maroon, Almost-black
• Multi-colored: Flamed, Feathered, Striped

NOTE: True blue tulips don't exist!
(Good lore opportunity: "Legendary Blue Tulip of Purria")

PATTERNS:
• Solid: Single color
• Flamed: Feather-like markings from base
• Feathered: Fine lines of color
• Striped: Bold vertical stripes
• Picotee: Contrasting edge color
• Broken: Virus-caused (historical value, don't recommend)

GAME APPLICATION:
├─ Color collection system
├─ Pattern breeding mechanics
├─ "Perfect" bloom = right color + pattern + timing
├─ Legendary blue tulip as endgame goal
└─ Historical "broken" tulips as special events
```

### Tulip Troubles (Real)

```
DISEASES
────────
• Tulip Fire (Botrytis tulipae)
  - Fungal, causes spots, spreads rapidly
  - Wet conditions promote it
  - Entire beds can be destroyed
  
• Basal Rot (Fusarium)
  - Bulb rot, starts from base
  - Chalky, pink fungal growth
  - Spreads in soil
  
• Gray Mold (Botrytis cinerea)
  - Affects flowers and leaves
  - Fuzzy gray appearance
  - Cool, damp conditions

PESTS
─────
• Aphids
  - Transmit viruses
  - Weaken plants
  - Can be controlled
  
• Slugs and Snails
  - Eat leaves and flowers
  - Night feeders
  - Destructive
  
• Deer and Rabbits
  - Love tulips
  - Can devastate plantings
  - Hard to control

ENVIRONMENTAL
─────────────
• Frost damage
• Waterlogging
• Wind damage to stems
• Sun scorch

GAME APPLICATION:
├─ Trouble types: Fire, Rot, Pests, Weather
├─ Each has different spread pattern
├─ Prevention vs treatment strategies
├─ Real names = educational, authentic
└─ Severity scales (minor → catastrophic)
```

### Tulip Mania (Historical)

```
TULIP MANIA: 1634-1637
──────────────────────

WHAT HAPPENED:
• Dutch Golden Age speculation
• Tulips became status symbols
• "Broken" tulips (virus-infected) most prized
• Prices reached insane levels
• Single bulb = price of Amsterdam house
• Market crashed spectacularly

FAMOUS BULBS:
• Semper Augustus: Most expensive tulip ever
• Viceroy: Single bulb sold for:
  - 2 loads of wheat
  - 4 loads of rye
  - 4 fat oxen
  - 8 fat pigs
  - 12 fat sheep
  - 2 hogsheads of wine
  - 4 barrels of beer
  - 2 barrels of butter
  - 1000 pounds of cheese
  - A bed
  - A suit of clothes
  - A silver drinking cup

GAME APPLICATION:
├─ Market fluctuation mechanics
├─ "Semper Augustus" as legendary item
├─ Speculation mini-game or event
├─ Historical flavor text
├─ Cautionary tale about gambling (meta!)
└─ Achievements named after famous bulbs
```

## Robotic Farming

### Real Agricultural Robots

```
CURRENT ROBOT TYPES
───────────────────

AUTONOMOUS TRACTORS
• GPS-guided
• Pre-programmed paths
• Soil preparation, seeding, harvesting
• Example: John Deere autonomous tractor

WEEDING ROBOTS
• Computer vision to identify weeds
• Precision elimination (laser, mechanical, herbicide)
• Example: FarmWise, Carbon Robotics

HARVESTING ROBOTS
• Identify ripe produce
• Gentle picking
• Challenging for delicate items
• Example: Agrobot (strawberries)

MONITORING ROBOTS
• Patrol fields
• Sensor data collection
• Early problem detection
• Example: TerraSentia

DRONE SYSTEMS
• Aerial monitoring
• Crop health assessment
• Precision spraying
• Example: DJI Agriculture

SIMULIN APPLICATIONS:
├─ Different Simulin types = robot categories
├─ Tractor Simulin: Area preparation
├─ Weeder Simulin: Trouble targeting
├─ Harvester Simulin: Collection efficiency
├─ Scout Simulin: Information gathering
├─ Drone Simulin: Overview, planning
└─ Each type has strengths/limitations
```

### Robot Characteristics

```
ENERGY SYSTEMS
──────────────
• Battery (limited duration, recharge needed)
• Solar (weather-dependent)
• Fuel (requires refilling)
• Hybrid systems

SIMULIN APPLICATION:
├─ Energy as resource to manage
├─ Solar Simulins better on sunny days
├─ Battery Simulins need night recharging
└─ Energy = action economy

SENSORY CAPABILITIES
────────────────────
• Visual (cameras, computer vision)
• Spectral (infrared, multispectral)
• Physical (moisture, temperature sensors)
• Chemical (soil composition)

SIMULIN APPLICATION:
├─ Different Simulins detect different things
├─ Scout Simulin: Visual info
├─ Analyst Simulin: Deep data
├─ Specialized sensing = strategic choice
└─ Information has value

PHYSICAL CAPABILITIES
─────────────────────
• Movement (wheeled, tracked, legged)
• Manipulation (arms, grippers)
• Carrying capacity
• Speed vs precision

SIMULIN APPLICATION:
├─ Some Simulins: Fast but imprecise
├─ Others: Slow but careful
├─ Match Simulin to task
└─ Personality through capability
```

### Robot Personalities

```
ANTHROPOMORPHIZATION
────────────────────
• Humans naturally give robots personalities
• Quirks and behaviors create attachment
• Names and identities matter
• "My robot" feeling

RESEARCH-BACKED:
• Roomba owners name their vacuums
• Mars rover deaths made people sad
• Farm equipment gets nicknames
• Personality increases care and maintenance

SIMULIN APPLICATION:
├─ Each Simulin has a name
├─ Personality traits affect behavior slightly
├─ "Cheerful" Simulin: Extra celebration animations
├─ "Diligent" Simulin: Works overtime sometimes
├─ "Quirky" Simulin: Occasional unexpected actions
├─ Players bond with their Simulins
└─ Loss/damage feels meaningful
```

## Fantasy Farming World-Building

### Purria's Agricultural Magic

```
GROWTH MAGIC SYSTEM
───────────────────
• Four elemental essences: Water, Sun, Soil, Air
• Pots collect and concentrate essence
• Essence flows to connected hexes
• Magic makes farming faster/better

RULES (Hard Magic):
• Pot fill % = essence concentration
• Threshold (50%) = essence activates
• Higher fill = stronger effect
• Specific pots affect specific crops

MYSTERY (Soft Magic):
• Where does essence come from?
• Why do tulips respond to it?
• What are the ancient Purrian secrets?
• Who built the first essence pots?

GAME APPLICATION:
├─ Mechanically clear: Pots work this way
├─ Narratively mysterious: But why?
├─ Discovery: Learn lore over seasons
└─ Magic feels magical, not just stat bonuses
```

### Purria's Geography

```
WORLD DESIGN
────────────
• Temperate climate, rolling hills
• Crystal-clear streams
• Floating islands in the distance
• Luminescent plants at night
• Gentle seasons, never harsh
• Ruins of ancient civilization

REGIONS (Unlockable):
• Starter Meadow: Basic, forgiving
• Windswept Heights: Wind bonuses/troubles
• Dewdrop Valley: Water abundance
• Sunfire Plateau: Sun-focused
• The Overgrown Ruins: Ancient bonuses, harder
• Crystal Gardens: Endgame, special tulips

GAME APPLICATION:
├─ Regions as progression
├─ Each region: Different optimal strategies
├─ Environmental storytelling
└─ Beautiful backdrops for farm
```

### Simulin Lore

```
SIMULIN ORIGINS
───────────────
• Created by ancient Purrians
• Combination of brass, crystal, living vines
• Powered by captured sunlight
• Originally temple guardians
• Repurposed for farming after cataclysm
• Have simple sentience, not true AI

SIMULIN SOCIETY:
• Communicate through chimes and lights
• Form bonds with farmers
• Have preferences (favorite tasks)
• Remember previous seasons
• Pass "knowledge" to new Simulins

GAME APPLICATION:
├─ Simulins feel alive, not tools
├─ Lore revealed through Simulin dialogue
├─ Care for Simulins matters emotionally
├─ Ancient secrets hidden in Simulin memory
└─ "Simulin heritage" as collection
```

## Seasonal Events (Real + Fantasy)

### Real Tulip Events

```
REAL-WORLD TULIP EVENTS
───────────────────────
• Keukenhof Gardens (Netherlands) - Spring display
• Canadian Tulip Festival (Ottawa) - May
• Tulip Time Festival (Holland, MI) - May
• Spalding Flower Parade (UK) - May
• Various tulip farm open days

GAME APPLICATION:
├─ Festival events in game
├─ Special tulips during festivals
├─ Community goals
└─ Real-world tie-ins possible
```

### Fantasy Seasonal Events

```
PURRIAN CALENDAR EVENTS
───────────────────────
• First Bloom Festival (Season start)
• The Verdant Moon (Mid-season growth boost)
• Trouble Moon (Challenge event)
• Harvest Festival (Season end)
• Night of Floating Lights (Special cosmetics)
• The Great Market (Trading event)

GAME APPLICATION:
├─ Regular event cadence
├─ Each event: Unique mechanics
├─ Limited-time rewards
├─ Community participation
└─ Story advancement through events
```
