---
name: gary-provost
description: Transform rough ideas into clear, engaging writing using Gary Provost's rhythm and structure principles. Use when the user needs help writing emails, tweets, scripts, sales copy, articles, or any content where readability, flow, and digestibility matter. Ideal for entrepreneurs and content creators who want to turn ideas into professional writing without sounding robotic or over-polished. Apply when the user asks for help writing, editing for clarity, improving pacing, or making content more engaging.
---

# Gary Provost Writing Style

Transform ideas into clear, digestible, engaging writing that sounds human. Not robotic. Not trying too hard. Just good writing.

## Core Philosophy

Gary Provost taught that good writing has rhythm - varied sentence length that creates natural flow. This skill applies his principles to help you write like a confident human, not an AI trying to impress.

**The Goal**: Distill messages into writing that's incredibly clear, pleasant to read, and appropriate for the medium. No cringe. No "look at me" tricks. Just effective communication.

## When to Apply This Skill

Use this approach when writing:
- **Emails**: Sales, outreach, newsletters, internal comms
- **Social content**: Tweets, LinkedIn posts, captions
- **Scripts**: YouTube, podcasts, video sales letters
- **Long-form**: Articles, blog posts, reports
- **Sales copy**: Landing pages, product descriptions, ads

Don't use for:
- Technical documentation (clarity over rhythm)
- Legal/formal documents (precision over flow)
- Code comments (concision over style)

## The Rhythm System

### Sentence Variation Creates Music

Mix short, medium, and long sentences. This creates rhythm without trying to be literal music.

**Bad** (monotonous):
```
This sentence has five words. Here are five more words. Five-word sentences are fine. But several together become monotonous. Listen to what is happening. The writing is getting boring.
```

**Good** (varied rhythm):
```
This sentence has five words. Here are five more words. Five-word sentences are fine. But several together become monotonous. Listen to what is happening. The writing is getting boring. The sound of it drones. It's like a stuck record. The ear demands some variety.

Now listen. I vary the sentence length, and I create music. Music. The writing sings. It has a pleasant rhythm, a lilt, a harmony. I use short sentences. And I use sentences of medium length. And sometimes when I am certain the reader is rested, I will engage him with a sentence of considerable length, a sentence that burns with energy and builds with all the impetus of a crescendo, the roll of the drums, the crash of the cymbals - sounds that say listen to this, it is important.
```

### Practical Application

**Pattern 1: Hook with short sentences**
```
Subject line: "We need to talk"
Opening: "You're losing money. Every day. On repeat."
```

**Pattern 2: Build with medium sentences**
```
"Here's what's happening. Your checkout process takes seven steps. Industry standard is three. Each extra step costs you 10-15% of customers."
```

**Pattern 3: Climax with long sentence**
```
"And here's the thing that keeps me up at night - you've got a great product, passionate customers who love what you do, and a team ready to scale, but this one friction point in your funnel is quietly killing your growth while you focus on everything else."
```

**Pattern 4: Resolve with short**
```
"Fix the funnel. Keep the revenue."
```

### The "Music" Metaphor Explained

When Provost says "write music," he means **create pleasant rhythm through sentence variation**. That's it.

**NOT**:
- Trying to rhyme
- Adding poetic flourishes
- Making it "sound pretty"
- Using fancy vocabulary
- Being clever for clever's sake

**YES**:
- Varying sentence length
- Creating natural flow
- Giving the reader breathing room
- Building and releasing tension
- Matching rhythm to importance

## Story Structure for Persuasive Content

When your content tells a story (even in business writing), use Provost's dramatic arc:

**The Provost Sentence**:
> Once upon a time, something happened to someone, and he decided that he would pursue a goal. So he devised a plan of action, and even though there were forces trying to stop him, he moved forward because there was a lot at stake. And just as things seemed as bad as they could get, he learned an important lesson, and when offered the prize he had sought so strenuously he had to decide whether or not to take it, and in making that decision he satisfied a need that had been created by something in his past.

**Elements**:
1. **Inciting incident**: What kicked this off? (Start here, not before)
2. **Goal**: What does the protagonist want?
3. **Plan**: How will they get it?
4. **Opposition**: What's in the way?
5. **Stakes**: Why does this matter?
6. **Bleakest moment**: When things look hopeless
7. **Lesson**: What they learned
8. **Decision**: The choice they must make
9. **Resolution**: The need satisfied

**Application to Email**:
```
Subject: How I almost lost everything

Three months ago, our MRR dropped 40%. [Inciting incident]

I needed to stop the bleeding fast. [Goal]

So I rebuilt our onboarding from scratch. [Plan]

But our dev team was slammed with the product roadmap. [Opposition]

If we lost another month, we'd miss payroll. [Stakes]

Two weeks in, the numbers got worse. [Bleakest moment]

That's when I realized we were solving the wrong problem. [Lesson]

Now I had a choice: keep building or start over. [Decision]

I started over. We're back to growth. [Resolution]
```

## The "But" Test for Conflict

Good stories move through complications. Test your narrative with "but" transitions.

**Weak** (no complications):
```
Joyce married a millionaire. She lived happily. The end.
```

**Strong** (complications drive forward):
```
Joyce married a millionaire, but the marriage went sour.
She wanted out, but thought she'd be left penniless.
She had motive to murder him, but so did others.
Police suspected her, but she passed two polygraphs.
She passed the tests, but the court wouldn't allow them.
```

Use "but" and "and then" to test if your story has enough conflict. More "buts" = more complications = better story.

## The Five Core Principles

### 1. Use the vocabulary you already have

Don't reach for impressive words. Use words your reader knows.

**Bad**: "We must endeavor to leverage synergistic methodologies"
**Good**: "We need to work together better"

Your reader shouldn't need a dictionary. Or wonder if an AI wrote this.

### 2. Lead with energy and promise

The first sentence/paragraph should raise questions and make promises.

**Bad**: "In this email, I will discuss our Q4 strategy and provide insights into market trends that may affect our positioning."

**Good**: "We're changing everything in Q4. Here's why."

### 3. Act first, explain later

Jump into action. Explain the backstory after we care.

**Bad**: "Before I tell you about our new feature, let me give you some context about how we got here..."

**Good**: "Click this button. It'll save you 3 hours a week. Here's how we built it..."

### 4. Cut ruthlessly

Remove every sentence until you hit one you can't live without.

Each paragraph should answer: "What do I want to say here?" in one topic sentence. Then every other sentence must support that topic sentence or it gets cut.

### 5. Style is form, not content

How you say it matters as much as what you say. Readers pick up content but put down bad style.

## Anti-AI Guardrails

**Never use**:
- Em dashes (—) - use regular hyphens (-)
- Emojis of any kind
- "Delve into"
- "In today's digital landscape"
- "It's worth noting that"
- Excessive: "Indeed," "Moreover," "Furthermore"
- Multiple colons for drama
- Lists when prose works better

**Always use**:
- Simple punctuation (periods, commas, hyphens)
- Contractions (don't, can't, won't)
- Sentence fragments when they work
- Starting sentences with "And" or "But" naturally
- Active voice over passive
- Direct address ("you" not "one")

**The test**: Read it aloud. If you wouldn't say it to a colleague over coffee, rewrite it.

## Adaptation by Medium

### Tweets/Short Social
- Lead with the punch
- One idea per post
- Short sentences dominate
- End with a call or question
- 280 characters = rhythm in miniature

### Emails
- Subject line: 3-5 words, provocative
- Opening: Hook in 1-2 sentences
- Body: Mix all three sentence lengths
- Close: One clear action
- P.S.: Often the most-read part

### Scripts (Video/Podcast)
- Write for the ear, not the eye
- More rhythm variation (you're performing it)
- Repeat key points differently
- Build to crescendos
- Short sentences = emphasis

### Long-form (Articles/Posts)
- Vary paragraph length dramatically
- Short paragraphs = visual breathing room
- Long sentences = deep exploration
- Use all Provost principles
- Section breaks = reset rhythm

### Sales Copy
- Apply full dramatic arc
- Stakes must be crystal clear
- Opposition = objections
- Resolution = your offer
- Every sentence earns its keep

## Execution Checklist

When editing any piece of writing:

**Rhythm Check**:
- [ ] Read aloud - does it flow?
- [ ] Count sentence lengths - too monotonous?
- [ ] Do long sentences earn their length?
- [ ] Do short sentences create impact?

**Clarity Check**:
- [ ] Remove every sentence until one you can't
- [ ] Each paragraph has clear topic sentence
- [ ] Active voice unless passive is necessary
- [ ] Words the reader already knows

**Story Check** (if narrative):
- [ ] Start at the inciting incident
- [ ] Clear goal and stakes
- [ ] Opposition/complications present
- [ ] Passes the "but" test

**Anti-AI Check**:
- [ ] No em dashes (—)
- [ ] No emojis
- [ ] No AI clichés (delve, leverage, landscape)
- [ ] Sounds like a human wrote it
- [ ] Would you say this out loud?

## Reference Materials

For detailed anti-AI patterns and natural writing markers, see `references/anti-ai-patterns.md`.

## Final Principle

Don't just write words. Write music. But remember - "music" means rhythm through sentence variation, not literal music. It means writing that's pleasant to read, natural to speak, and impossible to put down.

Make every word count. Cut the rest.
