# tasklist.md テンプレート

このファイルには、タスクリストのテンプレートを記載します。
`{要件名}` の部分は実際の要件名に置き換えてください。

---

```markdown
# タスクリスト - {要件名}

## 進捗サマリー

| 状態 | 件数 |
|------|------|
| 完了 | 0 |
| 進行中 | 0 |
| 未着手 | 0 |

## タスク一覧

### T-1: 要件定義・設計

- [ ] 要件定義書の作成
- [ ] 設計書の作成
- [ ] レビュー完了

### T-2: {タスク名}

- [ ] 実装
- [ ] テスト作成
- [ ] 動作確認

### T-3: {タスク名}

- [ ] 実装
- [ ] テスト作成
- [ ] 動作確認

### T-4: テスト・ドキュメント

- [ ] 統合テスト
- [ ] 永続化ドキュメント更新
- [ ] コードレビュー

## 完了条件

- [ ] 全タスクが完了
- [ ] テストがすべてパス
- [ ] 永続化ドキュメントが更新済み
```

---

## task_{タスクID}.md テンプレート

タスクの詳細を記載する必要がある場合、以下のテンプレートを使用してください。
初期生成では作成せず、開発中に必要に応じて作成します。

```markdown
# タスク詳細 - T-{タスクID}: {タスク名}

## 概要

このタスクで実現することを簡潔に記載します。

## 関連要件

- F-{要件ID}: {要件名}

## 実装内容

### 対象ファイル

| ファイル | 変更内容 |
|---------|---------|
| `app/...` | |
| `src-tauri/...` | |

### 実装詳細

#### 1. {実装項目1}

```typescript
// コード例
```

#### 2. {実装項目2}

```rust
// コード例
```

## 技術的な検討事項

### 検討事項1

- **問題**:
- **解決策**:
- **理由**:

### 検討事項2

- **問題**:
- **解決策**:
- **理由**:

## テスト観点

- [ ] {テスト観点1}
- [ ] {テスト観点2}
- [ ] {テスト観点3}

## 進捗

| 項目 | 状態 | 備考 |
|------|------|------|
| 設計 | 完了 / 進行中 / 未着手 | |
| 実装 | 完了 / 進行中 / 未着手 | |
| テスト | 完了 / 進行中 / 未着手 | |
| レビュー | 完了 / 進行中 / 未着手 | |

## メモ・備考

-
```
