# testing.md テンプレート（パフォーマンス改善）

このファイルには、パフォーマンス改善作業の検証手順書テンプレートを記載します。
`{要件名}` の部分は実際の要件名に置き換えてください。

---

```markdown
# テスト手順書 - {要件名}（パフォーマンス改善）

**作成日**: YYYY-MM-DD
**最終更新**: YYYY-MM-DD

---

## 1. テスト環境

### 測定環境

| 項目 | 内容 |
|-----|------|
| OS | macOS 14.0 / Windows 11 / Ubuntu 22.04 |
| CPU | Apple M1 / Intel Core i7-12700K / AMD Ryzen 9 5900X |
| メモリ | 16GB |
| ブラウザ | Chrome 120 / Safari 17 / Firefox 121 |
| 測定ツール | Chrome DevTools Performance |

### テストデータ

- **データベース**: サンプルDB（1,000レコード）
- **ファイル**: 10MBのサンプルファイル

---

## 2. ベンチマーク測定手順

### TC-B-001: Before測定（改善前）

**目的**: 現在のパフォーマンスを測定する

**手順**:

1. アプリケーションを起動
2. Chrome DevTools を開く（F12）
3. Performance タブを選択
4. 🔴 Record ボタンをクリック
5. 対象機能を実行（例: データ読み込み）
6. ⏹ Stop ボタンをクリック
7. 以下の値を記録：
   - Total Time: `______` ms
   - Scripting: `______` ms
   - Rendering: `______` ms
   - Painting: `______` ms

**期待値**: N/A（現状測定）

**結果**:

| 測定項目 | 測定値 | 備考 |
|---------|--------|------|
| Total Time | _______ ms | |
| Scripting | _______ ms | |
| Rendering | _______ ms | |
| Painting | _______ ms | |

---

## 3. 最適化実装後の検証

### TC-P-001: After測定（改善後）

**目的**: 最適化後のパフォーマンスを測定する

**前提条件**: すべての最適化タスクが完了していること

**手順**:

1. アプリケーションを起動
2. Chrome DevTools を開く（F12）
3. Performance タブを選択
4. 🔴 Record ボタンをクリック
5. 対象機能を実行（例: データ読み込み）
6. ⏹ Stop ボタンをクリック
7. 以下の値を記録：
   - Total Time: `______` ms
   - Scripting: `______` ms
   - Rendering: `______` ms
   - Painting: `______` ms

**期待値**:
- Total Time: ≤ 1000ms（目標値）
- Before測定値から50%以上の改善

**結果**:

| 測定項目 | 測定値 | Before | 改善率 | 達成状況 |
|---------|--------|--------|--------|---------|
| Total Time | _______ ms | _______ ms | _______ % | ☐ 達成 / ☐ 未達成 |
| Scripting | _______ ms | _______ ms | _______ % | |
| Rendering | _______ ms | _______ ms | _______ % | |
| Painting | _______ ms | _______ ms | _______ % | |

---

## 4. メモリ使用量測定

### TC-M-001: メモリ使用量比較

**目的**: メモリ使用量が改善されたことを確認する

**手順**:

1. アプリケーションを起動
2. Chrome DevTools を開く（F12）
3. Memory タブを選択
4. Take snapshot をクリック（Before）
5. 10分間操作を実施（データ読み込み、画面遷移など）
6. Take snapshot をクリック（After）
7. Heap size を記録

**期待値**: メモリ使用量が目標値（256MB）以下

**結果**:

| 測定項目 | Before（改善前） | After（改善後） | 目標値 | 達成状況 |
|---------|----------------|----------------|--------|---------|
| Heap Size | _______ MB | _______ MB | ≤ 256MB | ☐ 達成 / ☐ 未達成 |
| Memory Leak | - | ☐ なし / ☐ あり | なし | |

---

## 5. 負荷テスト

### TC-L-001: 大量データ処理

**目的**: 大量データでもパフォーマンスが維持されることを確認する

**前提条件**: 10,000レコードのテストデータが準備されていること

**手順**:

1. テストDBに10,000レコードを投入
2. アプリケーションを起動
3. データ読み込み機能を実行
4. 読み込み時間を測定

**期待値**: 読み込み時間が5秒以内

**結果**:

| データ量 | 読み込み時間 | 目標値 | 達成状況 |
|---------|------------|--------|---------|
| 10,000レコード | _______ ms | ≤ 5000ms | ☐ 達成 / ☐ 未達成 |

---

## 6. 機能回帰テスト

### TC-R-001: 既存機能の動作確認

**目的**: 最適化により既存機能が壊れていないことを確認する

**手順**:

1. ☐ データ読み込み機能が正常に動作する
2. ☐ データ表示が正しい
3. ☐ フィルター機能が正常に動作する
4. ☐ ソート機能が正常に動作する
5. ☐ エクスポート機能が正常に動作する

**期待値**: すべての機能が正常に動作する

**結果**: ☐ 合格 / ☐ 不合格

---

## 7. クロスブラウザテスト

### TC-CB-001: Chrome

| 測定項目 | 測定値 | 目標値 | 達成状況 |
|---------|--------|--------|---------|
| Total Time | _______ ms | ≤ 1000ms | ☐ 達成 / ☐ 未達成 |

### TC-CB-002: Safari

| 測定項目 | 測定値 | 目標値 | 達成状況 |
|---------|--------|--------|---------|
| Total Time | _______ ms | ≤ 1000ms | ☐ 達成 / ☐ 未達成 |

### TC-CB-003: Firefox

| 測定項目 | 測定値 | 目標値 | 達成状況 |
|---------|--------|--------|---------|
| Total Time | _______ ms | ≤ 1000ms | ☐ 達成 / ☐ 未達成 |

---

## 8. 自動ベンチマークテスト

### ユニットテスト: パフォーマンス基準

```typescript
import { describe, it, expect } from 'vitest';

describe('Performance Benchmarks', () => {
  it('should load data within 1 second', async () => {
    const start = performance.now();
    await loadData();
    const duration = performance.now() - start;

    expect(duration).toBeLessThan(1000);
  });

  it('should render table within 500ms', async () => {
    const start = performance.now();
    await renderTable();
    const duration = performance.now() - start;

    expect(duration).toBeLessThan(500);
  });
});
```

**実行コマンド**: `npm run test:performance`

**結果**: ☐ 合格 / ☐ 不合格

---

## 9. 総合評価

### 目標達成状況

| 測定項目 | Before | After | 目標値 | 達成状況 |
|---------|--------|-------|--------|---------|
| ページ読み込み時間 | _______ ms | _______ ms | ≤ 1000ms | ☐ 達成 / ☐ 未達成 |
| メモリ使用量 | _______ MB | _______ MB | ≤ 256MB | ☐ 達成 / ☐ 未達成 |
| 大量データ処理 | _______ ms | _______ ms | ≤ 5000ms | ☐ 達成 / ☐ 未達成 |

### 総合判定

- ☐ すべての目標を達成（合格）
- ☐ 一部の目標を達成（条件付き合格）
- ☐ 目標未達成（不合格）

### 備考

-

---

## 10. 課題・改善点

| 課題ID | 内容 | 対応方針 | 優先度 |
|-------|------|---------|--------|
| I-001 | | | |

---

## 11. 参考資料

- Chrome DevTools Performance ドキュメント: https://developer.chrome.com/docs/devtools/performance/
- Vitest Performance Testing: https://vitest.dev/
```
