# testing.md テンプレート

このファイルには、テスト手順書のテンプレートを記載します。
`{要件名}` の部分は実際の要件名に置き換えてください。

---

```markdown
# テスト手順書 - {要件名}

## 概要

このドキュメントでは、{要件名}機能のテスト手順を記載します。
可能な限り手動操作で確認し、操作で確認できない項目のみ自動テストを記載します。

## 前提条件

- `npm run tauri:dev` でアプリが起動していること
- 必要なテストデータが準備されていること

## 手動テスト

### ケース 1: {テストケース名}

**手順:**

1. アプリを起動する
2. {画面}を開く
3. {操作}を実行する

**期待結果:**

- {期待される動作}

**確認結果:**

- [ ] OK / NG

---

### ケース 2: {テストケース名}

**手順:**

1.
2.
3.

**期待結果:**

-

**確認結果:**

- [ ] OK / NG

---

## 自動テスト

### ユニットテスト

```bash
npm run test:run
```

### 型チェック

```bash
npm run typecheck
```

### Rustテスト

```bash
cd src-tauri && cargo test
```

## エッジケース

| ケース | 期待動作 | 確認結果 |
|--------|---------|---------|
| | | |

## 回帰テスト

既存機能への影響がないことを確認します。

- [ ] 既存の接続機能が正常に動作する
- [ ] 既存のクエリビルダーが正常に動作する
- [ ] 設定画面が正常に動作する
```
