# GEO/AEO Content Templates

## Table of Contents
1. [Definitional Content Template](#definitional-content-template)
2. [How-To Content Template](#how-to-content-template)
3. [Comparison Content Template](#comparison-content-template)
4. [FAQ-Optimized Template](#faq-optimized-template)
5. [Product/Service Template](#productservice-template)
6. [Writing Guidelines](#writing-guidelines)

---

## Definitional Content Template

**Best for:** "What is X?" queries, concept explanations

```markdown
# What is [Topic]? [Subtitle with Context]

**TL;DR:** [Topic] is [concise 1-sentence definition]. [1-2 sentences on why it matters or key application].

## Definition

[Topic] is [expanded definition in 2-3 sentences]. [Include key characteristics].

> **Quick Definition:** [15-word definition suitable for snippet extraction]

## How [Topic] Works

[Explanation paragraph - use simple, clear language]

### Key Components

| Component | Purpose | Example |
|-----------|---------|---------|
| [Item 1] | [What it does] | [Concrete example] |
| [Item 2] | [What it does] | [Concrete example] |
| [Item 3] | [What it does] | [Concrete example] |

## Benefits of [Topic]

1. **[Benefit 1]**: [Explanation in 1-2 sentences]
2. **[Benefit 2]**: [Explanation in 1-2 sentences]
3. **[Benefit 3]**: [Explanation in 1-2 sentences]

## Common Use Cases

- **[Use case 1]**: [Brief description]
- **[Use case 2]**: [Brief description]
- **[Use case 3]**: [Brief description]

## FAQ

### What is the difference between [Topic] and [Related Topic]?
[Clear answer in 2-3 sentences]

### Who should use [Topic]?
[Clear answer identifying target audience]

### How do I get started with [Topic]?
[Actionable first steps]

## Summary

[2-3 sentence recap of key points - this is another extraction opportunity]

---
*Last updated: [Date] | Author: [Name, Credentials]*
*Sources: [List key sources for credibility]*
```

---

## How-To Content Template

**Best for:** Process queries, tutorials, step-by-step guides

```markdown
# How to [Action]: [Subtitle with Benefit]

**TL;DR:** To [action], you need to [high-level steps in 1 sentence]. This process takes approximately [time estimate] and requires [key requirements].

## Quick Overview

| | |
|---|---|
| **Time Required** | [X minutes/hours] |
| **Difficulty** | [Beginner/Intermediate/Advanced] |
| **What You'll Need** | [Key requirements] |
| **Expected Result** | [What user will achieve] |

## Before You Start

### Prerequisites
- [Requirement 1]
- [Requirement 2]
- [Requirement 3]

### Tools/Materials Needed
- [Tool 1] - [why needed]
- [Tool 2] - [why needed]

## Step-by-Step Instructions

### Step 1: [Action Verb + What]

[1-2 sentences explaining this step]

**How to do it:**
1. [Sub-step a]
2. [Sub-step b]
3. [Sub-step c]

> **Pro Tip:** [Helpful insight for this step]

### Step 2: [Action Verb + What]

[1-2 sentences explaining this step]

**How to do it:**
1. [Sub-step a]
2. [Sub-step b]

⚠️ **Warning:** [Common mistake to avoid]

### Step 3: [Action Verb + What]

[Continue pattern...]

## Troubleshooting

### [Common Problem 1]
**Cause:** [Why this happens]
**Solution:** [How to fix]

### [Common Problem 2]
**Cause:** [Why this happens]
**Solution:** [How to fix]

## FAQ

### How long does it take to [action]?
[Direct answer with context]

### What if [common concern]?
[Reassuring answer with solution]

### Can I [related question]?
[Clear yes/no with explanation]

## Summary

You've learned how to [action]. The key steps are:
1. [Step 1 summary]
2. [Step 2 summary]
3. [Step 3 summary]

---
*Last updated: [Date] | Author: [Name, Credentials]*
```

---

## Comparison Content Template

**Best for:** "X vs Y" queries, decision-making content

```markdown
# [Option A] vs [Option B]: [What You Need to Know in 2025]

**TL;DR:** [Option A] is best for [use case], while [Option B] excels at [different use case]. Choose [A] if [criteria]; choose [B] if [other criteria].

## Quick Comparison

| Feature | [Option A] | [Option B] |
|---------|------------|------------|
| **Best For** | [Primary use case] | [Primary use case] |
| **Price** | [Range] | [Range] |
| **Ease of Use** | [Rating/description] | [Rating/description] |
| **Key Strength** | [Main advantage] | [Main advantage] |
| **Key Weakness** | [Main drawback] | [Main drawback] |

## [Option A] Overview

### What is [Option A]?
[2-3 sentence definition]

### Pros
- ✅ [Advantage 1]
- ✅ [Advantage 2]
- ✅ [Advantage 3]

### Cons
- ❌ [Disadvantage 1]
- ❌ [Disadvantage 2]

### Best For
[Option A] is ideal for [specific users/situations] because [reason].

## [Option B] Overview

### What is [Option B]?
[2-3 sentence definition]

### Pros
- ✅ [Advantage 1]
- ✅ [Advantage 2]
- ✅ [Advantage 3]

### Cons
- ❌ [Disadvantage 1]
- ❌ [Disadvantage 2]

### Best For
[Option B] is ideal for [specific users/situations] because [reason].

## Detailed Comparison

### [Criteria 1]: [Option A] vs [Option B]
[Detailed comparison - 2-3 paragraphs]

**Winner:** [Option X] - [1 sentence reason]

### [Criteria 2]: [Option A] vs [Option B]
[Detailed comparison - 2-3 paragraphs]

**Winner:** [Option X] - [1 sentence reason]

### [Criteria 3]: [Option A] vs [Option B]
[Detailed comparison - 2-3 paragraphs]

**Winner:** [Option X] - [1 sentence reason]

## Which Should You Choose?

### Choose [Option A] if:
- [Condition 1]
- [Condition 2]
- [Condition 3]

### Choose [Option B] if:
- [Condition 1]
- [Condition 2]
- [Condition 3]

## FAQ

### Is [Option A] better than [Option B]?
[Nuanced answer - "it depends on..."]

### Can I use both [Option A] and [Option B]?
[Clear answer]

### What's the main difference between [A] and [B]?
[1-2 sentence core difference]

## Conclusion

**Our Recommendation:** For [most common use case], we recommend [Option X] because [key reason]. However, if [alternative scenario], [Option Y] is the better choice.

---
*Last updated: [Date] | Author: [Name, Credentials]*
*Methodology: [How comparison was conducted]*
```

---

## FAQ-Optimized Template

**Best for:** Question clusters, comprehensive topic coverage

```markdown
# [Topic]: Frequently Asked Questions

**TL;DR:** This guide answers the most common questions about [topic], including [key question areas]. Last updated [Date].

## Quick Answers

| Question | Short Answer |
|----------|--------------|
| [Question 1]? | [10-word answer] |
| [Question 2]? | [10-word answer] |
| [Question 3]? | [10-word answer] |

## Detailed FAQ

### Basic Questions

#### What is [topic]?
[2-3 sentence complete answer that can stand alone]

#### Why is [topic] important?
[Complete answer with specific benefits/reasons]

#### Who needs [topic]?
[Clear description of target audience with examples]

### How-To Questions

#### How do I [common action]?
[Step-by-step answer, can be brief list]

#### How long does [process] take?
[Specific timeframe with context]

#### How much does [topic] cost?
[Price range with factors that affect cost]

### Comparison Questions

#### What's the difference between [X] and [Y]?
[Clear distinction in 2-3 sentences]

#### Is [topic] better than [alternative]?
[Balanced answer with "it depends" context]

### Troubleshooting Questions

#### What if [common problem]?
[Solution-focused answer]

#### Why isn't [expected outcome] happening?
[Diagnostic approach with solutions]

### Advanced Questions

#### Can I [advanced use case]?
[Yes/no with explanation and how-to if applicable]

#### What are the limitations of [topic]?
[Honest assessment of boundaries]

## Still Have Questions?

[Call to action - contact, comment, related resources]

---
*Last updated: [Date] | Expert: [Name, Credentials]*
```

---

## Writing Guidelines

### For AI Extraction Optimization

**Lead with the Answer**
```
❌ "In this article, we'll explore what SEO means..."
✅ "SEO (Search Engine Optimization) is the practice of improving website visibility in search results."
```

**Use Complete Sentences**
```
❌ "Benefits: faster, cheaper, better"
✅ "The main benefits include faster processing times, lower costs, and improved quality."
```

**Be Specific with Numbers**
```
❌ "This can significantly improve results"
✅ "This typically improves results by 25-40% within 3 months"
```

**Attribute Claims**
```
❌ "Studies show that..."
✅ "According to a 2024 HubSpot study of 5,000 websites..."
```

**Format for Scanning**
```
- Use bullet points for 3+ items
- Bold key terms on first use
- Keep paragraphs under 4 sentences
- Use tables for comparisons
- Include clear section headers
```

### Word Count Guidelines

| Content Type | Optimal Length | Snippet Target |
|--------------|----------------|----------------|
| Definition | 1,500-2,500 words | 40-60 words |
| How-To | 1,500-3,000 words | 45-50 words |
| Comparison | 2,000-3,500 words | 40-50 words |
| FAQ | 1,500-2,500 words | 40-50 words per answer |
