---
name: Global Coding Style
description: Follow core coding style principles including SOLID, DRY, KISS, and YAGNI when writing code. Apply consistent naming conventions, meaningful variable names, small focused functions, automated formatting, and proper code organization. Use this skill across all programming languages and file types when writing or refactoring code. Use when creating functions, classes, modules, or components to ensure Single Responsibility Principle, when avoiding code duplication (DRY), when choosing simple over clever implementations (KISS), or when resisting premature optimization and speculative features (YAGNI). Use when establishing naming conventions, removing dead code, or maintaining consistent indentation and formatting. Apply these principles universally across backend (.ts, .js, .py, .java, .go), frontend (.tsx, .jsx, .vue), and configuration files.
---

# Global Coding Style

This Skill provides Claude Code with specific guidance on fundamental coding style principles and best practices that apply across all programming languages and frameworks, including SOLID, DRY, KISS, and YAGNI principles.

## When to use this skill

- When writing or refactoring any code in any programming language
- When creating functions, classes, modules, or components in backend or frontend code
- When establishing or following naming conventions for variables, functions, and files
- When applying Single Responsibility Principle (SRP) to keep code focused
- When avoiding code duplication by extracting reusable logic (DRY principle)
- When choosing between simple and clever implementations (KISS principle)
- When deciding whether to add abstractions or features (YAGNI principle)
- When removing dead code, commented-out blocks, or unused imports
- When ensuring consistent formatting and indentation
- When writing meaningful, descriptive names that reveal intent
- When keeping functions small and focused on a single task
- When avoiding premature optimization or speculative generality
- When refactoring complex code into simpler, more maintainable structures

## Instructions

For details, refer to the information provided in this file:
[global coding style](../../../agent-os/standards/global/coding-style.md)
