---
name: Global Commenting
description: Write self-documenting code with clear structure and naming, using minimal but helpful comments only when necessary to explain complex logic. Use this skill across all code files when deciding whether to add comments or how to structure code for clarity. Use when refactoring code to be more self-explanatory, when removing outdated or temporary comments, when writing evergreen informational comments that remain relevant over time, or when choosing between adding a comment versus improving variable/function names. Apply when working with any programming language (.ts, .js, .py, .java, .go, .tsx, .jsx, .vue) to maintain clean, understandable code without over-commenting.
---

# Global Commenting

This Skill provides Claude Code with specific guidance on code commenting best practices, emphasizing self-documenting code and minimal, evergreen comments.

## When to use this skill

- When writing code in any programming language and deciding whether to add comments
- When refactoring code to make it more self-explanatory through better naming and structure
- When removing outdated, temporary, or unnecessary comments
- When adding comments to explain complex logic or large code sections
- When choosing between adding a comment versus improving code clarity through naming
- When ensuring comments are evergreen and won't become outdated
- When avoiding comments that explain recent changes or temporary fixes
- When reviewing code and identifying where self-documenting improvements can replace comments
- When working with complex algorithms or business logic that genuinely needs explanation
- When maintaining clean, readable code without comment clutter
- When applying across all file types (.ts, .js, .py, .java, .go, .tsx, .jsx, .vue, .rb, etc.)

## Instructions

For details, refer to the information provided in this file:
[global commenting](../../../agent-os/standards/global/commenting.md)
