---
name: Global Tech Stack
description: Reference and maintain project technology stack documentation including frameworks, languages, databases, testing tools, deployment infrastructure, and third-party services. Use this skill when needing to understand what technologies and frameworks are used in the project, when making architectural decisions about adding new dependencies, when documenting the tech stack for team members, or when ensuring consistency across technology choices. Use when working with configuration files (package.json, requirements.txt, Gemfile, Cargo.toml), when setting up new services or integrations, when choosing between multiple library options, or when onboarding new developers who need to understand the project's technical foundation. Reference this when making decisions about ORM choices, testing frameworks, CSS frameworks, frontend libraries, or deployment platforms.
---

# Global Tech Stack

This Skill provides Claude Code with specific guidance on understanding and maintaining the project's technology stack and architectural choices.

## When to use this skill

- When needing to understand what technologies and frameworks the project uses
- When making architectural decisions about adding new dependencies or services
- When documenting the tech stack in README or architecture documentation
- When choosing between multiple library or framework options for a feature
- When setting up new integrations or third-party services
- When working with package managers (npm, pip, bundler, cargo) and dependency files
- When ensuring consistency in technology choices across the project
- When onboarding new team members who need tech stack overview
- When selecting appropriate ORMs, query builders, or database tools
- When choosing testing frameworks or quality assurance tools
- When making deployment and infrastructure decisions
- When referencing which CSS framework, UI component library, or frontend framework to use

## Instructions

For details, refer to the information provided in this file:
[global tech stack](../../../agent-os/standards/global/tech-stack.md)
